package org.lightdi.util;

import junit.framework.TestCase;
import bean.TestBean;

public class ReflectionUtilTest extends TestCase
{
	public void test_getGetterMethodName_n() throws Exception
	{
		String[] fields = new String[]
		{ "name", "userName", "4aaa", };
		String[] expected = new String[]
		{ "getName", "getUserName", "get4aaa", };
		for (int i = 0; i < fields.length; i++)
		{
			String actual = ReflectionUtil.getGetterMethodName(fields[i]);
			assertEquals(expected[i], actual);
		}
	}

	public void test_getGetterMethodName_e() throws Exception
	{
		String[] fields = new String[]
		{ "", null, };
		for (int i = 0; i < fields.length; i++)
		{
			try
			{
				ReflectionUtil.getGetterMethodName(fields[i]);
				fail("expected exception did not be throwed.");
			} catch (IllegalArgumentException e)
			{
			} catch (Exception e)
			{
				e.printStackTrace();
				fail("unexpected exception");
			}
		}
	}

	public void test_getSetterMethodName_n() throws Exception
	{
		String[] fields = new String[]
		{ "name", "userName", "4aaa", };
		String[] expected = new String[]
		{ "setName", "setUserName", "set4aaa", };
		for (int i = 0; i < fields.length; i++)
		{
			String actual = ReflectionUtil.getSetterMethodName(fields[i]);
			assertEquals(expected[i], actual);
		}
	}

	public void test_getSetterMethodName_e() throws Exception
	{
		String[] fields = new String[]
		{ "", null, };
		for (int i = 0; i < fields.length; i++)
		{
			try
			{
				ReflectionUtil.getSetterMethodName(fields[i]);
				fail("expected exception did not be throwed.");
			} catch (IllegalArgumentException e)
			{
			} catch (Exception e)
			{
				e.printStackTrace();
				fail("unexpected exception");
			}
		}
	}

	public void test_instantiate_n_String() throws Exception
	{
		String expected = "aaa";
		String actual = ReflectionUtil.instantiate(String.class, expected);
		assertTrue(actual.equals(expected));
	}

	public void test_instantiate_n_String_empty() throws Exception
	{
		String expected = "";
		String actual = ReflectionUtil.instantiate(String.class, expected);
		assertTrue(actual.equals(expected));
	}

	public void test_instantiate_n_String_null() throws Exception
	{
		String expected = null;
		String actual = ReflectionUtil.instantiate(String.class, expected);
		assertNull(actual);
	}

	public void test_instantiate_n_Integer() throws Exception
	{
		String strExpected = "12345";
		Integer expected = 12345;
		Integer actual = ReflectionUtil.instantiate(Integer.class, strExpected);
		assertTrue(actual.equals(expected));
	}

	public void test_instantiate_n_Integer_null() throws Exception
	{
		String strExpected = null;
		Integer actual = ReflectionUtil.instantiate(Integer.class, strExpected);
		assertNull(actual);
	}

	public void test_instantiate_n_Bean_arg0() throws Exception
	{
		TestBean actual = ReflectionUtil.instantiate(TestBean.class, (Object[]) null);
		assertNotNull(actual);
	}

	public void test_instantiate_n_Bean_arg1() throws Exception
	{
		TestBean actual = ReflectionUtil.instantiate(TestBean.class, "name");
		assertNotNull(actual);
	}

	public void test_instantiate_n_Bean_arg1_null() throws Exception
	{
		Object[] args = new String[1];
		TestBean actual = ReflectionUtil.instantiate(TestBean.class, args);
		assertNotNull(actual);
	}

}
