/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.sunfish.javapp.editors;

import jp.gr.java_conf.sunfish.javapp.JavappPlugin;
import jp.gr.java_conf.sunfish.javapp.editors.ClassFileStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;

public class ClassFileInput
implements IStorageEditorInput {
    private IFile file;

    public ClassFileInput(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    /*
     * WARNING - void declaration
     */
    public IStorage getStorage() throws CoreException {
        void var4_8;
        void var3_7;
        String classname;
        String classpath;
        String fileName = this.file.getName();
        String wsPath = this.file.getWorkspace().getRoot().getLocation().toOSString();
        if (fileName.endsWith(".java")) {
            IJavaProject project = JavaCore.create((IProject)this.file.getProject());
            if (!project.exists()) {
                throw new CoreException((IStatus)new Status(4, JavappPlugin.getDefault().getBundle().getSymbolicName(), 4, "This is not java project.", null));
            }
            String outputPath = project.getOutputLocation().toOSString();
            IPackageDeclaration[] pac = JavaCore.createCompilationUnitFrom((IFile)this.file).getPackageDeclarations();
            String packName = pac.length == 0 ? "" : String.valueOf(pac[0].getElementName()) + '.';
            classpath = String.valueOf(wsPath) + outputPath;
            classname = String.valueOf(packName) + fileName.substring(0, fileName.length() - 5);
        } else if (fileName.endsWith(".class")) {
            classpath = String.valueOf(wsPath) + this.file.getFullPath().toOSString();
            classpath = classpath.substring(0, classpath.length() - fileName.length());
            classname = fileName.substring(0, fileName.length() - 6);
        } else {
            throw new CoreException((IStatus)new Status(4, JavappPlugin.getDefault().getBundle().getSymbolicName(), 4, "filename error.", null));
        }
        return new ClassFileStorage((String)var3_7, (String)var4_8, this.file.getName(), this.file.getFullPath());
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getToolTipText() {
        return this.file.getFullPath().makeRelative().toString();
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.file.getName());
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

