/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.sunfish.javapp.editors;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import jp.gr.java_conf.sunfish.javapp.JavapExecute;
import jp.gr.java_conf.sunfish.javapp.JavappPlugin;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class ClassFileStorage
implements IStorage {
    private String classpath;
    private String classname;
    private String name;
    private IPath fullpath;

    public ClassFileStorage(String classpath, String classname, String name, IPath fullpath) {
        this.classpath = classpath;
        this.classname = classname;
        this.name = name;
        this.fullpath = fullpath;
    }

    public InputStream getContents() throws CoreException {
        String pluginId = JavappPlugin.getDefault().getBundle().getSymbolicName();
        IPreferencesService service = Platform.getPreferencesService();
        String path = service.getString(pluginId, "javapp.pref.path", "", null);
        boolean isBackward = service.getBoolean(pluginId, "javapp.pref.isBackward", false, null);
        boolean isCode = service.getBoolean(pluginId, "javapp.pref.isCode", false, null);
        boolean isLine = service.getBoolean(pluginId, "javapp.pref.isLine", false, null);
        boolean isPublic = service.getBoolean(pluginId, "javapp.pref.isPublic", false, null);
        boolean isProtected = service.getBoolean(pluginId, "javapp.pref.isProtected", false, null);
        boolean isPackage = service.getBoolean(pluginId, "javapp.pref.isPackage", false, null);
        boolean isPrivate = service.getBoolean(pluginId, "javapp.pref.isPrivate", false, null);
        boolean isSignature = service.getBoolean(pluginId, "javapp.pref.isSignature", false, null);
        boolean isVerbose = service.getBoolean(pluginId, "javapp.pref.isVerbose", false, null);
        if (!"".equals(path)) {
            File f = new File(path);
            if (!f.exists() || !f.isFile()) {
                throw new CoreException((IStatus)new Status(4, pluginId, 4, "Command is not found.", null));
            }
            if (!path.endsWith("javap") && !path.endsWith("javap.exe")) {
                throw new CoreException((IStatus)new Status(4, pluginId, 4, "Command is not javap.", null));
            }
        }
        JavapExecute exec = new JavapExecute(path);
        String result = exec.exec(this.classpath, this.classname, isBackward, isCode, isLine, isPublic, isProtected, isPackage, isPrivate, isSignature, isVerbose);
        return new ByteArrayInputStream(result.getBytes());
    }

    public IPath getFullPath() {
        return this.fullpath;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

