/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.sunfish.javapp.editors;

import jp.gr.java_conf.sunfish.javapp.editors.ClassFileStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class JarFileInput
implements IStorageEditorInput {
    private IClassFile file;

    public JarFileInput(IClassFile file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    public IStorage getStorage() throws CoreException {
        String filename = this.file.getElementName();
        String path = this.file.getPath().toOSString();
        String pack = this.file.getParent().getElementName();
        String type = this.file.getType().getElementName();
        pack = String.valueOf(pack) + '.' + type;
        return new ClassFileStorage(path, pack, filename, null);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getName() {
        return this.file.getElementName();
    }

    public String getToolTipText() {
        return this.file.getElementName();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

