/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import org.eclipse.equinox.p2.internal.repository.comparator.Annotation;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFileStruct;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPoolEntry;

public class AnnotationComponentValue
extends ClassFileStruct {
    public static final int BYTE_TAG = 66;
    public static final int CHAR_TAG = 67;
    public static final int DOUBLE_TAG = 68;
    public static final int FLOAT_TAG = 70;
    public static final int INTEGER_TAG = 73;
    public static final int LONG_TAG = 74;
    public static final int SHORT_TAG = 83;
    public static final int BOOLEAN_TAG = 90;
    public static final int STRING_TAG = 115;
    public static final int ENUM_TAG = 101;
    public static final int CLASS_TAG = 99;
    public static final int ANNOTATION_TAG = 64;
    public static final int ARRAY_TAG = 91;
    private static final AnnotationComponentValue[] NO_VALUES = new AnnotationComponentValue[0];
    private AnnotationComponentValue[] annotationComponentValues;
    private Annotation annotationValue;
    private ConstantPoolEntry classInfo;
    private int classFileInfoIndex = -1;
    private ConstantPoolEntry constantValue;
    private int constantValueIndex = -1;
    private int enumConstantTypeNameIndex = -1;
    private int enumConstantNameIndex = -1;
    private char[] enumConstantTypeName;
    private char[] enumConstantName;
    private int readOffset;
    private int tag;
    private int valuesNumber;

    public AnnotationComponentValue(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        int t;
        this.tag = t = this.u1At(classFileBytes, 0, offset);
        this.readOffset = 1;
        switch (t) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                int constantIndex;
                this.constantValueIndex = constantIndex = this.u2At(classFileBytes, this.readOffset, offset);
                if (constantIndex != 0) {
                    ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(constantIndex);
                    switch (constantPoolEntry.getKind()) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            break;
                        }
                        default: {
                            throw new ClassFormatException(3);
                        }
                    }
                    this.constantValue = constantPoolEntry;
                }
                this.readOffset += 2;
                break;
            }
            case 101: {
                ConstantPoolEntry constantPoolEntry;
                int index;
                this.enumConstantTypeNameIndex = index = this.u2At(classFileBytes, this.readOffset, offset);
                if (index != 0) {
                    constantPoolEntry = constantPool.decodeEntry(index);
                    if (constantPoolEntry.getKind() != 1) {
                        throw new ClassFormatException(3);
                    }
                    this.enumConstantTypeName = constantPoolEntry.getUtf8Value();
                }
                this.readOffset += 2;
                this.enumConstantNameIndex = index = this.u2At(classFileBytes, this.readOffset, offset);
                if (index != 0) {
                    constantPoolEntry = constantPool.decodeEntry(index);
                    if (constantPoolEntry.getKind() != 1) {
                        throw new ClassFormatException(3);
                    }
                    this.enumConstantName = constantPoolEntry.getUtf8Value();
                }
                this.readOffset += 2;
                break;
            }
            case 99: {
                int classFileIndex;
                this.classFileInfoIndex = classFileIndex = this.u2At(classFileBytes, this.readOffset, offset);
                if (classFileIndex != 0) {
                    ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(classFileIndex);
                    if (constantPoolEntry.getKind() != 1) {
                        throw new ClassFormatException(3);
                    }
                    this.classInfo = constantPoolEntry;
                }
                this.readOffset += 2;
                break;
            }
            case 64: {
                Annotation annotation;
                this.annotationValue = annotation = new Annotation(classFileBytes, constantPool, this.readOffset + offset);
                this.readOffset += annotation.sizeInBytes();
                break;
            }
            case 91: {
                int numberOfValues;
                this.valuesNumber = numberOfValues = this.u2At(classFileBytes, this.readOffset, offset);
                this.readOffset += 2;
                if (numberOfValues != 0) {
                    this.annotationComponentValues = new AnnotationComponentValue[numberOfValues];
                    int i = 0;
                    while (i < numberOfValues) {
                        AnnotationComponentValue value;
                        this.annotationComponentValues[i] = value = new AnnotationComponentValue(classFileBytes, constantPool, offset + this.readOffset);
                        this.readOffset += value.sizeInBytes();
                        ++i;
                    }
                    break;
                }
                this.annotationComponentValues = NO_VALUES;
            }
        }
    }

    public AnnotationComponentValue[] getAnnotationComponentValues() {
        return this.annotationComponentValues;
    }

    public Annotation getAnnotationValue() {
        return this.annotationValue;
    }

    public ConstantPoolEntry getClassInfo() {
        return this.classInfo;
    }

    public int getClassInfoIndex() {
        return this.classFileInfoIndex;
    }

    public ConstantPoolEntry getConstantValue() {
        return this.constantValue;
    }

    public int getConstantValueIndex() {
        return this.constantValueIndex;
    }

    public char[] getEnumConstantName() {
        return this.enumConstantName;
    }

    public int getEnumConstantNameIndex() {
        return this.enumConstantNameIndex;
    }

    public char[] getEnumConstantTypeName() {
        return this.enumConstantTypeName;
    }

    public int getEnumConstantTypeNameIndex() {
        return this.enumConstantTypeNameIndex;
    }

    public int getTag() {
        return this.tag;
    }

    public int getValuesNumber() {
        return this.valuesNumber;
    }

    int sizeInBytes() {
        return this.readOffset;
    }
}

