/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElementWrapper;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;

public class CategoryElementWrapper
extends QueriedElementWrapper {
    private Set referredIUs = new HashSet();

    public CategoryElementWrapper(IQueryable queryable, Object parent) {
        super(queryable, parent);
    }

    protected boolean shouldWrap(Object match) {
        if (match instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)match;
            IRequiredCapability[] requirements = iu.getRequiredCapabilities();
            int i = 0;
            while (i < requirements.length) {
                if (requirements[i].getNamespace().equals("org.eclipse.equinox.p2.iu")) {
                    this.referredIUs.add(requirements[i].getName());
                }
                ++i;
            }
            Iterator iter = super.getCollection().iterator();
            while (iter.hasNext()) {
                CategoryElement element = (CategoryElement)iter.next();
                if (!element.shouldMerge(iu)) continue;
                element.mergeIU(iu);
                return false;
            }
            return true;
        }
        return false;
    }

    public Collection getElements(Collector collector) {
        if (collector.isEmpty()) {
            return super.getElements(collector);
        }
        Collection results = super.getElements(collector);
        this.cleanList();
        return results;
    }

    protected Object wrap(Object item) {
        IInstallableUnit iu = (IInstallableUnit)item;
        return super.wrap(new CategoryElement(this.parent, iu));
    }

    private void cleanList() {
        this.removeNestedCategories();
    }

    private void removeNestedCategories() {
        CategoryElement[] categoryIUs = this.getCollection().toArray(new CategoryElement[this.getCollection().size()]);
        int i = 0;
        while (i < categoryIUs.length) {
            if (this.referredIUs.contains(categoryIUs[i].getIU().getId())) {
                this.getCollection().remove(categoryIUs[i]);
            }
            ++i;
        }
    }
}

