/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui;

import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.ICopyright;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.ILicense;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.IUPropertyQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.osgi.framework.BundleContext;

public class IUPropertyUtils {
    static final Locale DEFAULT_LOCALE = new Locale("df", "LT");
    static final String NAMESPACE_IU_LOCALIZATION = "org.eclipse.equinox.p2.localization";
    private static Map LocaleCollectorCache = new HashMap(2);
    static /* synthetic */ Class class$0;

    public static ILicense getLicense(IInstallableUnit iu) {
        return IUPropertyUtils.getLicense(iu, IUPropertyUtils.getCurrentLocale());
    }

    public static ICopyright getCopyright(IInstallableUnit iu) {
        return IUPropertyUtils.getCopyright(iu, IUPropertyUtils.getCurrentLocale());
    }

    public static String getIUProperty(IInstallableUnit iu, String propertyKey) {
        return IUPropertyUtils.getIUProperty(iu, propertyKey, IUPropertyUtils.getCurrentLocale());
    }

    public static ILicense getLicense(IInstallableUnit iu, Locale locale) {
        String body;
        ILicense license = iu.getLicense();
        String string = body = license != null ? license.getBody() : null;
        if (body == null || body.length() <= 1 || body.charAt(0) != '%') {
            return license;
        }
        String actualKey = body.substring(1);
        body = IUPropertyUtils.getLocalizedIUProperty(iu, actualKey, locale);
        return MetadataFactory.createLicense((URI)license.getLocation(), (String)body);
    }

    public static ICopyright getCopyright(IInstallableUnit iu, Locale locale) {
        String body;
        ICopyright copyright = iu.getCopyright();
        String string = body = copyright != null ? copyright.getBody() : null;
        if (body == null || body.length() <= 1 || body.charAt(0) != '%') {
            return copyright;
        }
        String actualKey = body.substring(1);
        body = IUPropertyUtils.getLocalizedIUProperty(iu, actualKey, locale);
        return MetadataFactory.createCopyright((URI)copyright.getLocation(), (String)body);
    }

    public static String getIUProperty(IInstallableUnit iu, String propertyKey, Locale locale) {
        String value = iu.getProperty(propertyKey);
        if (value == null || value.length() <= 1 || value.charAt(0) != '%') {
            return value;
        }
        String actualKey = value.substring(1);
        return IUPropertyUtils.getLocalizedIUProperty(iu, actualKey, locale);
    }

    private static String getLocalizedIUProperty(IInstallableUnit iu, String actualKey, Locale locale) {
        String localizedKey = IUPropertyUtils.makeLocalizedKey(actualKey, locale.toString());
        String localizedValue = null;
        if (iu instanceof InstallableUnit) {
            localizedValue = ((InstallableUnit)iu).getLocalizedProperty(localizedKey);
        }
        if (localizedValue == null) {
            localizedValue = iu.getProperty(localizedKey);
        }
        if (localizedValue != null) {
            return localizedValue;
        }
        List locales = IUPropertyUtils.buildLocaleVariants(locale);
        final IInstallableUnit theUnit = iu;
        Collector localizationFragments = IUPropertyUtils.getLocalizationFragments(locale, locales);
        Collector hostLocalizationCollector = new Collector(){

            public boolean accept(Object object) {
                boolean haveHost = false;
                if (object instanceof IInstallableUnitFragment) {
                    IInstallableUnitFragment fragment = (IInstallableUnitFragment)object;
                    IRequiredCapability[] hosts = fragment.getHost();
                    int i = 0;
                    while (i < hosts.length) {
                        IRequiredCapability nextHost = hosts[i];
                        if ("org.eclipse.equinox.p2.iu".equals(nextHost.getNamespace()) && theUnit.getId().equals(nextHost.getName()) && nextHost.getRange() != null && nextHost.getRange().isIncluded(theUnit.getVersion())) {
                            haveHost = true;
                            break;
                        }
                        ++i;
                    }
                }
                return haveHost ? super.accept(object) : true;
            }
        };
        IUPropertyQuery iuQuery = new IUPropertyQuery("org.eclipse.equinox.p2.type.fragment", "true");
        Collector collected = iuQuery.perform(localizationFragments.iterator(), hostLocalizationCollector);
        if (!collected.isEmpty()) {
            String translation = null;
            Iterator iter = collected.iterator();
            while (iter.hasNext() && translation == null) {
                IInstallableUnit localizationIU = (IInstallableUnit)iter.next();
                Iterator jter = locales.iterator();
                while (jter.hasNext()) {
                    String localeKey = IUPropertyUtils.makeLocalizedKey(actualKey, (String)jter.next());
                    translation = localizationIU.getProperty(localeKey);
                    if (translation == null) continue;
                    return IUPropertyUtils.cacheResult(iu, localizedKey, translation);
                }
            }
        }
        Iterator iter = locales.iterator();
        while (iter.hasNext()) {
            String nextLocale = (String)iter.next();
            String localeKey = IUPropertyUtils.makeLocalizedKey(actualKey, nextLocale);
            String nextValue = iu.getProperty(localeKey);
            if (nextValue == null) continue;
            return IUPropertyUtils.cacheResult(iu, localizedKey, nextValue);
        }
        return IUPropertyUtils.cacheResult(iu, localizedKey, actualKey);
    }

    private static String cacheResult(IInstallableUnit iu, String localizedKey, String localizedValue) {
        if (iu instanceof InstallableUnit) {
            ((InstallableUnit)iu).setLocalizedProperty(localizedKey, localizedValue);
        }
        return localizedValue;
    }

    private static synchronized Collector getLocalizationFragments(Locale locale, List localeVariants) {
        IProfileRegistry profileRegistry;
        Collector cached;
        SoftReference collectorRef = (SoftReference)LocaleCollectorCache.get(locale);
        if (collectorRef != null && (cached = (Collector)collectorRef.get()) != null) {
            return cached;
        }
        final List locales = localeVariants;
        Collector localeFragmentCollector = new Collector(){

            public boolean accept(Object object) {
                boolean haveLocale = false;
                if (object instanceof IInstallableUnitFragment) {
                    IInstallableUnitFragment fragment = (IInstallableUnitFragment)object;
                    IProvidedCapability[] provides = fragment.getProvidedCapabilities();
                    int j = 0;
                    while (j < provides.length && !haveLocale) {
                        String providedLocale;
                        IProvidedCapability nextProvide = provides[j];
                        if (IUPropertyUtils.NAMESPACE_IU_LOCALIZATION.equals(nextProvide.getNamespace()) && (providedLocale = nextProvide.getName()) != null) {
                            Iterator iter = locales.iterator();
                            while (iter.hasNext()) {
                                if (!providedLocale.equals(iter.next())) continue;
                                haveLocale = true;
                                break;
                            }
                        }
                        ++j;
                    }
                }
                return haveLocale ? super.accept(object) : true;
            }
        };
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", "Profile registry unavailable. Default language will be used.", (Throwable)new RuntimeException()));
            return new Collector();
        }
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", "Profile unavailable. Default language will be used.", (Throwable)new RuntimeException()));
            return new Collector();
        }
        IUPropertyQuery iuQuery = new IUPropertyQuery("org.eclipse.equinox.p2.type.fragment", "true");
        Collector collected = profile.query((Query)iuQuery, localeFragmentCollector, null);
        LocaleCollectorCache.put(locale, new SoftReference<Collector>(collected));
        return collected;
    }

    private static List buildLocaleVariants(Locale locale) {
        String nl = locale.toString();
        ArrayList<String> result = new ArrayList<String>(4);
        while (true) {
            result.add(nl);
            int lastSeparator = nl.lastIndexOf(95);
            if (lastSeparator == -1) break;
            nl = nl.substring(0, lastSeparator);
        }
        result.add(DEFAULT_LOCALE.toString());
        return result;
    }

    private static String makeLocalizedKey(String actualKey, String localeImage) {
        return String.valueOf(localeImage) + '.' + actualKey;
    }

    private static Locale getCurrentLocale() {
        return Locale.getDefault();
    }
}

