/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.core.ArithmeticalAnimatableValue;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.exprelems.IntegerProperty;
import java.util.Collection;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableInteger
extends ArithmeticalAnimatableValue<Integer>
implements IAnimatableInteger {
    public AnimatableInteger(Integer staticValue, Collection<Keyframe<Integer>> keyframes, String expression) {
        super(staticValue, keyframes, expression, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public AnimatableInteger(Integer defaultValue) {
        super(defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public AnimatableInteger(Integer defaultValue, Integer minValue, Integer maxValue) {
        super(defaultValue, minValue, maxValue);
    }

    @Override
    public Integer clamp(Integer value) {
        value = value < (Integer)this._minValue ? (Integer)this._minValue : value;
        return value > (Integer)this._maxValue ? (Integer)this._maxValue : value;
    }

    @Override
    public Integer jsToJava(Object jsValue) {
        return (Integer)Context.jsToJava((Object)jsValue, Integer.TYPE);
    }

    @Override
    protected double[] toArray(Integer value) {
        return new double[]{value.doubleValue()};
    }

    @Override
    protected Integer valueOf(double[] d) {
        return Math.round((float)d[0]);
    }

    public Scriptable createExpressionElement(final RenderContext renderContext) {
        IntegerProperty ip = new IntegerProperty(){

            public int getValue() {
                return (Integer)AnimatableInteger.this.value(renderContext);
            }

            public int valueAtTime(double t) {
                return (Integer)AnimatableInteger.this.valueAtTime(t, renderContext);
            }
        };
        return renderContext.toNativeJavaObject(ip, ScriptRuntime.NumberClass);
    }
}

