/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static String randomId() {
        return UUID.randomUUID().toString();
    }

    public static <E> List<E> newList() {
        return Util.newArrayList();
    }

    public static <E> List<E> newList(Collection<? extends E> c) {
        return Util.newArrayList(c);
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(Collection<? extends E> c) {
        return new ArrayList<E>(c);
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> Set<E> newSet() {
        return Util.newHashSet();
    }

    public static <E> Set<E> newSet(Collection<? extends E> c) {
        return Util.newHashSet(c);
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(Collection<? extends E> c) {
        return new HashSet<E>(c);
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Collection<? extends E> c) {
        return new LinkedHashSet<E>(c);
    }

    public static <K, V> Map<K, V> newMap() {
        return Util.newHashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> SortedMap<K, V> newSortedMap() {
        return Util.newTreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> WeakHashMap<K, V> newWeakHashMap() {
        return new WeakHashMap();
    }

    public static <E> Set<E> unmodifiableSet(E ... elements) {
        List<E> list = Arrays.asList(elements);
        LinkedHashSet<E> set = new LinkedHashSet<E>(list);
        return Collections.unmodifiableSet(set);
    }

    public static <E> void addAll(Collection<? extends E> src, Collection<E> dst) {
        if (src != null) {
            dst.addAll(src);
        }
    }

    private Util() {
    }
}

