/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.core.AbstractTransformableLayer;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.BlendMode;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CollapseTransformation;
import ch.kuramo.javie.core.DepthBuffer;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VectorMediaInput;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.VideoLayerBuffer;
import ch.kuramo.javie.core.VideoLayerComposer;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.LayerMatrixUtil;
import ch.kuramo.javie.core.internal.VideoLayerBufferImpl;
import ch.kuramo.javie.core.services.AudioEffectPipeline;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.VideoEffectPipeline;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMediaLayer
extends AbstractTransformableLayer
implements MediaLayer {
    private boolean _videoNature;
    private boolean _audioNature;
    private boolean _videoEnabled;
    private boolean _audioEnabled;
    private boolean _effectsEnabled = true;
    private List<Effect> _effects = Util.newList();
    private TrackMatte _trackMatte = TrackMatte.NONE;
    private AnimatableVec2d _depthBase = new AnimatableVec2d(new Vec2d(0.0, 0.0));
    private AnimatableString _intersectionGroup = new AnimatableString("");
    private AnimatableDouble _opacity = new AnimatableDouble((Double)100.0, 0.0, 100.0);
    private BlendMode _blendMode = BlendMode.NORMAL;
    private AnimatableVec2d _audioLevels = new AnimatableVec2d(Vec2d.ZERO, new Vec2d(-48.0, -48.0), new Vec2d(48.0, 48.0));
    private AnimatableDouble _timeRemap = new AnimatableDouble(0.0);
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private VideoEffectPipeline _vePipeline;
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private AudioEffectPipeline _aePipeline;
    @Inject
    private IArrayPools _arrayPools;

    @Override
    public void initialize() {
        throw new UnsupportedOperationException("Use initialize(boolean, boolean) method instead.");
    }

    protected void initialize(boolean videoAvailable, boolean audioAvailable) {
        if (!videoAvailable && !audioAvailable) {
            throw new IllegalArgumentException();
        }
        super.initialize();
        if (videoAvailable) {
            this._videoNature = true;
            this._videoEnabled = true;
        }
        if (audioAvailable) {
            this._audioNature = true;
            this._audioEnabled = true;
        }
    }

    @Override
    public boolean isVideoNature() {
        return this._videoNature;
    }

    public void setVideoNature(boolean videoNature) {
        this._videoNature = videoNature;
    }

    @Override
    public boolean isAudioNature() {
        return this._audioNature;
    }

    public void setAudioNature(boolean audioNature) {
        this._audioNature = audioNature;
    }

    @Override
    public boolean isVideoEnabled() {
        return this._videoEnabled;
    }

    @Override
    public void setVideoEnabled(boolean enabled) {
        this._videoEnabled = enabled;
    }

    @Override
    public boolean isAudioEnabled() {
        return this._audioEnabled;
    }

    @Override
    public void setAudioEnabled(boolean enabled) {
        this._audioEnabled = enabled;
    }

    @Override
    public boolean isEffectsEnabled() {
        return this._effectsEnabled;
    }

    @Override
    public void setEffectsEnabled(boolean effectsEnabled) {
        this._effectsEnabled = effectsEnabled;
    }

    @Override
    public List<Effect> getEffects() {
        return this._effects;
    }

    public void setEffects(List<Effect> effects) {
        this._effects = effects;
    }

    @Override
    public TrackMatte getTrackMatte() {
        return this._trackMatte;
    }

    @Override
    public void setTrackMatte(TrackMatte trackMatte) {
        this._trackMatte = trackMatte;
    }

    @Override
    public AnimatableVec2d getDepthBase() {
        return this._depthBase;
    }

    public void setDepthBase(AnimatableVec2d depthBase) {
        depthBase.copyConfigurationFrom(this._depthBase);
        this._depthBase = depthBase;
    }

    @Override
    public AnimatableString getIntersectionGroup() {
        return this._intersectionGroup;
    }

    public void setIntersectionGroup(AnimatableString intersectionGroup) {
        intersectionGroup.copyConfigurationFrom(this._intersectionGroup);
        this._intersectionGroup = intersectionGroup;
    }

    @Override
    public AnimatableDouble getOpacity() {
        return this._opacity;
    }

    public void setOpacity(AnimatableDouble opacity) {
        opacity.copyConfigurationFrom(this._opacity);
        this._opacity = opacity;
    }

    @Override
    public BlendMode getBlendMode() {
        return this._blendMode;
    }

    @Override
    public void setBlendMode(BlendMode blendMode) {
        this._blendMode = blendMode;
    }

    @Override
    public AnimatableVec2d getAudioLevels() {
        return this._audioLevels;
    }

    public void setAudioLevels(AnimatableVec2d audioLevels) {
        audioLevels.copyConfigurationFrom(this._audioLevels);
        this._audioLevels = audioLevels;
    }

    @Override
    public AnimatableDouble getTimeRemap() {
        return this._timeRemap;
    }

    public void setTimeRemap(AnimatableDouble timeRemap) {
        timeRemap.copyConfigurationFrom(this._timeRemap);
        this._timeRemap = timeRemap;
    }

    @Override
    public boolean isVectorLayer() {
        return this.getMediaInput() instanceof VectorMediaInput;
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        super.prepareExpression(scope);
        scope.assignTo(this._depthBase);
        scope.assignTo(this._intersectionGroup);
        scope.assignTo(this._opacity);
        scope.assignTo(this._audioLevels);
        scope.assignTo(this._timeRemap);
        for (Effect effect : this._effects) {
            effect.prepareExpression(scope.clone());
        }
    }

    @Override
    public void setupVideoRenderer(VideoLayerComposer composer, Camera camera, CollapseTransformation ct) {
        MediaInput input = this.getMediaInput();
        if (input == null || !input.isVideoAvailable()) {
            return;
        }
        if (this.isVectorLayer() && LayerNature.isCTCR(this)) {
            this.setupVideoRendererCR(composer, camera, ct);
        } else {
            this.setupVideoRendererNormal(composer, camera, ct);
        }
    }

    protected Time calcVideoMediaTime(MediaInput input) {
        Time time;
        if (LayerNature.isTimeRemapEnabled(this)) {
            double t0 = (Double)this._timeRemap.value(this._vrContext);
            Time ctxTime = this._vrContext.getTime();
            double t1 = (Double)this._timeRemap.valueAtTime(new Time(ctxTime.timeValue + 1L, ctxTime.timeScale), (RenderContext)this._vrContext);
            Time frameDuration = input.getVideoFrameDuration();
            int timeScale = frameDuration.timeScale;
            time = new Time(Math.round(t0 * (double)timeScale), timeScale);
            if (t0 > t1) {
                time = time.subtract(frameDuration);
            }
        } else {
            time = this._vrContext.getTime().subtract(this.getStartTime());
            double rate = this.getRate();
            if (rate != 1.0) {
                time = new Time(Math.round((double)time.timeValue * rate), time.timeScale);
                if (rate < 0.0) {
                    Time duration = input.getDuration();
                    if (duration != null) {
                        time = time.add(duration);
                        Time frameDuration = input.getVideoFrameDuration();
                        time = time.subtract(frameDuration);
                    } else {
                        duration = this.getOutPoint().subtract(this.getStartTime());
                        time = time.add(duration);
                    }
                }
            }
        }
        return time;
    }

    private void setupVideoRendererNormal(VideoLayerComposer composer, final Camera camera, CollapseTransformation ct) {
        final MediaInput input = this.getMediaInput();
        final RenderResolution resolution = this._vrContext.getRenderResolution();
        WrappedOperation<VideoBounds> inputBoundsOperation = new WrappedOperation<VideoBounds>(){

            @Override
            public VideoBounds execute() {
                return resolution.scale(input.getVideoFrameBounds());
            }
        };
        VideoBounds bounds = this._vePipeline.getVideoBounds(this._effectsEnabled ? this._effects : Collections.emptyList(), inputBoundsOperation);
        Vec2d offset = new Vec2d(-bounds.x / resolution.scale, -bounds.y / resolution.scale);
        final double[] mvMatrix = new double[16];
        final double[] prjMatrix = new double[16];
        this.createMatrix(camera, ct, offset, mvMatrix, prjMatrix);
        final double opacity = ct == null ? (Double)this._opacity.value(this._vrContext) / 100.0 : (Double)this._opacity.value(this._vrContext) / 100.0 * ct.getOpacity();
        final Time time = this._vrContext.getTime();
        VideoLayerRenderer r = new VideoLayerRenderer(){

            public VideoLayerBuffer render(boolean withDepthBuffer) {
                AbstractMediaLayer.this._vrContext.setTime(time);
                VideoBuffer effectedBuffer = null;
                VideoBuffer trnsfrmdBuffer = null;
                DepthBuffer depthBuffer = null;
                try {
                    WrappedOperation<VideoBuffer> inputBufferOperation = new WrappedOperation<VideoBuffer>(){

                        @Override
                        public VideoBuffer execute() {
                            return input.getVideoFrameImage(AbstractMediaLayer.this.calcVideoMediaTime(input));
                        }
                    };
                    effectedBuffer = AbstractMediaLayer.this._vePipeline.doVideoEffects(AbstractMediaLayer.this._effectsEnabled ? AbstractMediaLayer.this._effects : Collections.emptyList(), inputBufferOperation);
                    trnsfrmdBuffer = AbstractMediaLayer.this._vrSupport.createVideoBuffer(AbstractMediaLayer.this._vrContext.getColorMode(), camera.getViewportSize());
                    trnsfrmdBuffer.allocateAsTexture();
                    trnsfrmdBuffer.clear();
                    depthBuffer = withDepthBuffer ? AbstractMediaLayer.this._vrSupport.createDepthBuffer(camera.getViewportSize()) : null;
                    AbstractMediaLayer.this._vrSupport.transform(effectedBuffer, trnsfrmdBuffer, depthBuffer, mvMatrix, prjMatrix);
                    VideoLayerBufferImpl vlb = new VideoLayerBufferImpl(trnsfrmdBuffer, depthBuffer, AbstractMediaLayer.this._blendMode, opacity);
                    trnsfrmdBuffer = null;
                    depthBuffer = null;
                    VideoLayerBufferImpl videoLayerBufferImpl = vlb;
                    return videoLayerBufferImpl;
                }
                finally {
                    if (depthBuffer != null) {
                        depthBuffer.dispose();
                    }
                    if (trnsfrmdBuffer != null) {
                        trnsfrmdBuffer.dispose();
                    }
                    if (effectedBuffer != null) {
                        effectedBuffer.dispose();
                    }
                }
            }
        };
        if (LayerNature.isThreeD(this)) {
            Vec2d depthBase2d = (Vec2d)this._depthBase.value(this._vrContext);
            Vec3d depthBase = new Vec3d(depthBase2d.x + offset.x, depthBase2d.y + offset.y);
            depthBase = resolution.scale(depthBase);
            Size2i vp = camera.getViewportSize();
            Vec3d[] vertices = new Vec3d[]{this._vrSupport.project(depthBase, mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp)};
            composer.add3D(r, vertices, (String)this._intersectionGroup.value(this._vrContext));
        } else {
            composer.add2D(r);
        }
    }

    private void setupVideoRendererCR(VideoLayerComposer composer, final Camera camera, CollapseTransformation ct) {
        final VectorMediaInput input = (VectorMediaInput)this.getMediaInput();
        RenderResolution resolution = this._vrContext.getRenderResolution();
        VideoBounds bounds = resolution.scale(input.getVideoFrameBounds());
        final double[] mvMatrix = new double[16];
        final double[] prjMatrix = new double[16];
        this.createMatrix(camera, ct, null, mvMatrix, prjMatrix);
        final double opacity = ct == null ? (Double)this._opacity.value(this._vrContext) / 100.0 : (Double)this._opacity.value(this._vrContext) / 100.0 * ct.getOpacity();
        final Time time = this._vrContext.getTime();
        VideoLayerRenderer r = new VideoLayerRenderer(){

            public VideoLayerBuffer render(boolean withDepthBuffer) {
                AbstractMediaLayer.this._vrContext.setTime(time);
                VideoBuffer rasterBuffer = null;
                VideoBuffer effectedBuffer = null;
                VideoBuffer resultBuffer = null;
                DepthBuffer depthBuffer = null;
                try {
                    rasterBuffer = AbstractMediaLayer.this._vrSupport.createVideoBuffer(AbstractMediaLayer.this._vrContext.getColorMode(), camera.getViewportSize());
                    rasterBuffer.allocateAsTexture();
                    if (withDepthBuffer) {
                        depthBuffer = AbstractMediaLayer.this._vrSupport.createDepthBuffer(camera.getViewportSize());
                        AbstractMediaLayer.this._vrSupport.fillDepth(rasterBuffer, depthBuffer, mvMatrix, prjMatrix);
                    } else {
                        depthBuffer = null;
                    }
                    rasterBuffer.clear();
                    final VideoBuffer inputBuffer = rasterBuffer;
                    WrappedOperation<VideoBuffer> inputBufferOperation = new WrappedOperation<VideoBuffer>(){

                        @Override
                        public VideoBuffer execute() {
                            input.rasterize(inputBuffer, mvMatrix, prjMatrix, AbstractMediaLayer.this.calcVideoMediaTime(input));
                            return inputBuffer;
                        }
                    };
                    effectedBuffer = AbstractMediaLayer.this._vePipeline.doVideoEffects(AbstractMediaLayer.this._effectsEnabled ? AbstractMediaLayer.this._effects : Collections.emptyList(), inputBufferOperation);
                    rasterBuffer = null;
                    VideoBounds resultBounds = new VideoBounds(camera.getViewportSize());
                    if (effectedBuffer.getBounds().equals((Object)resultBounds)) {
                        resultBuffer = effectedBuffer;
                        effectedBuffer = null;
                    } else {
                        resultBuffer = AbstractMediaLayer.this._vrSupport.createVideoBuffer(AbstractMediaLayer.this._vrContext.getColorMode(), resultBounds);
                        resultBuffer.allocateAsTexture();
                        resultBuffer.clear();
                        AbstractMediaLayer.this._vrSupport.copy(effectedBuffer, resultBuffer);
                    }
                    VideoLayerBufferImpl vlb = new VideoLayerBufferImpl(resultBuffer, depthBuffer, AbstractMediaLayer.this._blendMode, opacity);
                    resultBuffer = null;
                    depthBuffer = null;
                    VideoLayerBufferImpl videoLayerBufferImpl = vlb;
                    return videoLayerBufferImpl;
                }
                finally {
                    if (depthBuffer != null) {
                        depthBuffer.dispose();
                    }
                    if (resultBuffer != null) {
                        resultBuffer.dispose();
                    }
                    if (effectedBuffer != null) {
                        effectedBuffer.dispose();
                    }
                    if (rasterBuffer != null) {
                        rasterBuffer.dispose();
                    }
                }
            }
        };
        if (LayerNature.isThreeD(this)) {
            Vec2d depthBase2d = (Vec2d)this._depthBase.value(this._vrContext);
            Vec3d depthBase = new Vec3d(depthBase2d.x, depthBase2d.y);
            depthBase = resolution.scale(depthBase);
            Size2i vp = camera.getViewportSize();
            Vec3d[] vertices = new Vec3d[]{this._vrSupport.project(depthBase, mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x + (double)bounds.width, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp), this._vrSupport.project(new Vec3d(bounds.x, bounds.y + (double)bounds.height), mvMatrix, prjMatrix, vp)};
            composer.add3D(r, vertices, (String)this._intersectionGroup.value(this._vrContext));
        } else {
            composer.add2D(r);
        }
    }

    private void createMatrix(final Camera camera, final CollapseTransformation ct, final Vec2d offset, final double[] mvMatrix, final double[] prjMatrix) {
        WrappedOperation<Object> operation = new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                if (camera == null) {
                    AbstractMediaLayer.this._vrSupport.resetMatrix();
                } else if (LayerNature.isThreeD(AbstractMediaLayer.this)) {
                    AbstractMediaLayer.this._vrSupport.setMatrix(camera.getModelView3D(), camera.getProjection3D());
                } else {
                    AbstractMediaLayer.this._vrSupport.setMatrix(camera.getModelView2D(), camera.getProjection2D());
                }
                LayerMatrixUtil.multModelViewMatrix(AbstractMediaLayer.this, offset, ct, AbstractMediaLayer.this._vrContext, AbstractMediaLayer.this._vrSupport);
                AbstractMediaLayer.this._vrSupport.getMatrix(mvMatrix, prjMatrix);
                return null;
            }
        };
        this._vrSupport.pushMatrixAndExecute(operation);
    }

    private AudioBuffer getTimeRemappedAudioChunk(MediaInput input) {
        AudioBuffer ab1 = null;
        AudioBuffer ab2 = null;
        IObjectArray times = null;
        try {
            AudioMode audioMode = this._arContext.getAudioMode();
            int sampleRate = audioMode.sampleRate;
            ab1 = this._arSupport.createAudioBuffer();
            times = this._arrayPools.getObjectArray(ab1.getFrameCount());
            this._timeRemap.values(times, audioMode.sampleDuration, this._arContext.getEvaluationResolution(), this._arContext);
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            Object[] timeArray = (Object[])times.getArray();
            int i = 0;
            int n = times.getLength();
            while (i < n) {
                min = Math.min(min, (Double)timeArray[i]);
                max = Math.max(max, (Double)timeArray[i]);
                ++i;
            }
            long timeValueMin = (long)Math.floor(min * (double)sampleRate);
            long timeValueMax = (long)Math.ceil(max * (double)sampleRate);
            this._arContext.setFrameCount((int)(timeValueMax - timeValueMin) + 1);
            ab2 = input.getAudioChunk(new Time(timeValueMin, sampleRate));
            if (ab2 == null) {
                return null;
            }
            Object data1 = ab1.getData();
            Object data2 = ab2.getData();
            int n1 = ab1.getFrameCount();
            switch (audioMode.dataType) {
                case SHORT: {
                    Object[] array1 = (short[])data1;
                    short[] array2 = (short[])data2;
                    int i2 = 0;
                    while (i2 < n1) {
                        int j = (int)(Math.round((Double)timeArray[i2] * (double)sampleRate) - timeValueMin);
                        array1[i2 * 2] = array2[j * 2];
                        array1[i2 * 2 + 1] = array2[j * 2 + 1];
                        ++i2;
                    }
                    break;
                }
                case INT: {
                    Object[] array1 = (int[])data1;
                    int[] array2 = (int[])data2;
                    int i3 = 0;
                    while (i3 < n1) {
                        int j = (int)(Math.round((Double)timeArray[i3] * (double)sampleRate) - timeValueMin);
                        array1[i3 * 2] = array2[j * 2];
                        array1[i3 * 2 + 1] = array2[j * 2 + 1];
                        ++i3;
                    }
                    break;
                }
                case FLOAT: {
                    Object[] array1 = (float[])data1;
                    float[] array2 = (float[])data2;
                    int i4 = 0;
                    while (i4 < n1) {
                        int j = (int)(Math.round((Double)timeArray[i4] * (double)sampleRate) - timeValueMin);
                        array1[i4 * 2] = (short)array2[j * 2];
                        array1[i4 * 2 + 1] = (short)array2[j * 2 + 1];
                        ++i4;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
                }
            }
            AudioBuffer result = ab1;
            ab1 = null;
            AudioBuffer audioBuffer = result;
            return audioBuffer;
        }
        finally {
            if (ab1 != null) {
                ab1.dispose();
            }
            if (ab2 != null) {
                ab2.dispose();
            }
            if (times != null) {
                times.release();
            }
        }
    }

    private AudioBuffer getRateChangedAudioChunk(MediaInput input, Time time, double rate) {
        AudioBuffer ab1 = null;
        AudioBuffer ab2 = null;
        try {
            long timeValueMax;
            Time t;
            long timeValueMin;
            AudioMode audioMode = this._arContext.getAudioMode();
            int sampleRate = audioMode.sampleRate;
            ab1 = this._arSupport.createAudioBuffer();
            double duration = input.getDuration().toSecond();
            if (rate >= 0.0) {
                timeValueMin = (long)Math.floor(time.toSecond() * (double)sampleRate * rate);
                t = time.add(new Time((long)this._arContext.getFrameCount(), sampleRate));
                timeValueMax = (long)Math.ceil(t.toSecond() * (double)sampleRate * rate);
            } else {
                timeValueMax = (long)Math.ceil(duration * (double)sampleRate + time.toSecond() * (double)sampleRate * rate);
                t = time.add(new Time((long)this._arContext.getFrameCount(), sampleRate));
                timeValueMin = (long)Math.floor(duration * (double)sampleRate + t.toSecond() * (double)sampleRate * rate);
            }
            this._arContext.setFrameCount((int)(timeValueMax - timeValueMin) + 1);
            ab2 = input.getAudioChunk(new Time(timeValueMin, sampleRate));
            if (ab2 == null) {
                return null;
            }
            Object data1 = ab1.getData();
            Object data2 = ab2.getData();
            int n1 = ab1.getFrameCount();
            switch (audioMode.dataType) {
                case SHORT: {
                    Object[] array1 = (short[])data1;
                    short[] array2 = (short[])data2;
                    int i = 0;
                    while (i < n1) {
                        int j = rate >= 0.0 ? (int)(Math.round((time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin) : (int)(Math.round(duration * (double)sampleRate + (time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin);
                        array1[i * 2] = array2[j * 2];
                        array1[i * 2 + 1] = array2[j * 2 + 1];
                        ++i;
                    }
                    break;
                }
                case INT: {
                    Object[] array1 = (int[])data1;
                    int[] array2 = (int[])data2;
                    int i = 0;
                    while (i < n1) {
                        int j = rate >= 0.0 ? (int)(Math.round((time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin) : (int)(Math.round(duration * (double)sampleRate + (time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin);
                        array1[i * 2] = array2[j * 2];
                        array1[i * 2 + 1] = array2[j * 2 + 1];
                        ++i;
                    }
                    break;
                }
                case FLOAT: {
                    Object[] array1 = (float[])data1;
                    float[] array2 = (float[])data2;
                    int i = 0;
                    while (i < n1) {
                        int j = rate >= 0.0 ? (int)(Math.round((time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin) : (int)(Math.round(duration * (double)sampleRate + (time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin);
                        array1[i * 2] = (short)array2[j * 2];
                        array1[i * 2 + 1] = (short)array2[j * 2 + 1];
                        ++i;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
                }
            }
            AudioBuffer result = ab1;
            ab1 = null;
            AudioBuffer audioBuffer = result;
            return audioBuffer;
        }
        finally {
            if (ab1 != null) {
                ab1.dispose();
            }
            if (ab2 != null) {
                ab2.dispose();
            }
        }
    }

    @Override
    public AudioBuffer renderAudioChunk() {
        if (!LayerNature.isAudioEnabled(this)) {
            return null;
        }
        final MediaInput input = this.getMediaInput();
        if (input == null || !input.isAudioAvailable()) {
            return null;
        }
        WrappedOperation<AudioBuffer> inputOperation = new WrappedOperation<AudioBuffer>(){

            @Override
            public AudioBuffer execute() {
                if (LayerNature.isTimeRemapEnabled(AbstractMediaLayer.this)) {
                    return AbstractMediaLayer.this.getTimeRemappedAudioChunk(input);
                }
                Time time = AbstractMediaLayer.this._arContext.getTime().subtract(AbstractMediaLayer.this.getStartTime());
                double rate = AbstractMediaLayer.this.getRate();
                if (rate == 1.0) {
                    return input.getAudioChunk(time);
                }
                return AbstractMediaLayer.this.getRateChangedAudioChunk(input, time, rate);
            }
        };
        AudioBuffer ab = this._aePipeline.doAudioEffects(this._effectsEnabled ? this._effects : Collections.emptyList(), inputOperation);
        if (this._audioLevels.hasKeyframe() || this._audioLevels.getExpression() != null || !((Vec2d)this._audioLevels.getStaticValue()).equals((Object)Vec2d.ZERO)) {
            IObjectArray audioLevels = this._arrayPools.getObjectArray(ab.getFrameCount());
            this._audioLevels.values(audioLevels, ab.getAudioMode().sampleDuration, this._arContext.getEvaluationResolution(), this._arContext);
            this._arSupport.amplify(ab, (IObjectArray<Vec2d>)audioLevels);
            audioLevels.release();
        }
        Time time = this._arContext.getTime();
        Time sampleDuration = this._arContext.getAudioMode().sampleDuration;
        int clearFrameCount = (int)this.getInPoint().subtract(time).toFrameNumber(sampleDuration);
        if (clearFrameCount > 0) {
            this._arSupport.clear(ab, 0, clearFrameCount);
        }
        int clearFrameOffset = (int)this.getOutPoint().subtract(time).toFrameNumber(sampleDuration);
        clearFrameCount = this._arContext.getFrameCount() - clearFrameOffset;
        if (clearFrameCount > 0) {
            this._arSupport.clear(ab, clearFrameOffset, clearFrameCount);
        }
        return ab;
    }

    @Override
    public void afterDecode(Project p, LayerComposition c) throws ProjectDecodeException {
        super.afterDecode(p, c);
        for (Effect effect : this._effects) {
            effect.afterDecode(p);
        }
    }

    @Override
    public Object createExpressionElement(RenderContext renderContext) {
        return new MediaLayerExpressionElement(renderContext);
    }

    public class MediaLayerExpressionElement
    extends AbstractTransformableLayer.TransformableLayerExpressionElement {
        public MediaLayerExpressionElement(RenderContext renderContext) {
            super(renderContext);
        }

        public Object getDepthBase() {
            return this.elem(AbstractMediaLayer.this._depthBase);
        }

        public Object getIntersectionGroup() {
            return this.elem(AbstractMediaLayer.this._intersectionGroup);
        }

        public Object getOpacity() {
            return this.elem(AbstractMediaLayer.this._opacity);
        }

        public Object getAudioLevels() {
            return this.elem(AbstractMediaLayer.this._audioLevels);
        }

        public Object getTimeRemap() {
            return LayerNature.isTimeRemapEnabled(AbstractMediaLayer.this) ? this.elem(AbstractMediaLayer.this._timeRemap) : null;
        }

        public Object effect(int index) {
            Effect effect = (Effect)AbstractMediaLayer.this._effects.get(index - 1);
            return this.renderContext.getExpressionElement(effect);
        }
    }
}

