/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CollapseTransformation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.VideoLayerBuffer;
import ch.kuramo.javie.core.VideoLayerComposer;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.AbstractMediaLayer;
import ch.kuramo.javie.core.internal.VideoLayerBufferImpl;
import ch.kuramo.javie.core.internal.VideoLayerComposerImpl;
import ch.kuramo.javie.core.services.VideoEffectPipeline;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.Collections;
import net.arnx.jsonic.JSONHint;

@ProjectElement(value="mediaItemLayer")
public class MediaItemLayerImpl
extends AbstractMediaLayer
implements MediaItemLayer {
    private String _itemId;
    private MediaItem _mediaItem;
    private boolean _ctcr;
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private VideoEffectPipeline _vePipeline;

    protected void initialize(boolean videoAvailable, boolean audioAvailable) {
        throw new UnsupportedOperationException("Use initialize(MediaItem) method instead.");
    }

    public void initialize(MediaItem mediaItem) {
        MediaInput input = mediaItem.getMediaInput();
        boolean videoAvailable = input.isVideoAvailable();
        boolean audioAvailable = input.isAudioAvailable();
        if (!videoAvailable && !audioAvailable) {
            throw new IllegalArgumentException("No video nor audio is available.");
        }
        super.initialize(videoAvailable, audioAvailable);
        this._itemId = mediaItem.getId();
        this._mediaItem = mediaItem;
        this.setName(mediaItem.getName());
    }

    public String getItemId() {
        return this._itemId;
    }

    public void setItemId(String itemId) {
        this._itemId = itemId;
    }

    @JSONHint(ignore=true)
    public MediaItem getItem() {
        return this._mediaItem;
    }

    public boolean isCTCR() {
        return this._ctcr;
    }

    public void setCTCR(boolean ctcr) {
        this._ctcr = ctcr;
    }

    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._mediaItem.getMediaInput();
    }

    @JSONHint(ignore=true)
    public boolean isPrecompositionLayer() {
        return this.getPrecomposition() != null;
    }

    private LayerComposition getPrecomposition() {
        Composition comp;
        if (this._mediaItem instanceof CompositionItem && (comp = ((CompositionItem)this._mediaItem).getComposition()) instanceof LayerComposition) {
            return (LayerComposition)comp;
        }
        return null;
    }

    public void afterDecode(Project p, LayerComposition c) throws ProjectDecodeException {
        super.afterDecode(p, c);
        this._mediaItem = (MediaItem)p.getItem(this._itemId);
        if (this._mediaItem == null) {
            throw new ProjectDecodeException("no such MediaItem found: id=" + this._itemId);
        }
    }

    public void prepareExpression(ExpressionScope scope) {
        ExpressionScope preCompScope;
        super.prepareExpression(scope);
        LayerComposition preComp = this.getPrecomposition();
        if (preComp != null && (preCompScope = scope.createPrecompositionScope(preComp)) != null) {
            preComp.prepareExpression(preCompScope);
        }
    }

    public void setupVideoRenderer(VideoLayerComposer composer, Camera camera, CollapseTransformation ct) {
        LayerComposition preComp;
        if (LayerNature.isCTCR(this) && (preComp = this.getPrecomposition()) != null) {
            this.setupCollapseTransformation(composer, camera, ct, preComp);
            return;
        }
        super.setupVideoRenderer(composer, camera, ct);
    }

    private void setupCollapseTransformation(final VideoLayerComposer composer, final Camera camera, final CollapseTransformation ct, final LayerComposition preComp) {
        final Time time = this._vrContext.getTime();
        final double opacity = ct != null ? (Double)this.getOpacity().value(this._vrContext) / 100.0 * ct.getOpacity() : (Double)this.getOpacity().value(this._vrContext) / 100.0;
        final CollapseTransformation ct2 = new CollapseTransformation(){

            public CollapseTransformation getParent() {
                return ct;
            }

            public MediaItemLayer getLayer() {
                return MediaItemLayerImpl.this;
            }

            public Time getTime() {
                return time;
            }

            public double getOpacity() {
                return opacity;
            }
        };
        if (this.getEffects().isEmpty()) {
            this._vrContext.saveAndExecute(new WrappedOperation<Object>(){

                @Override
                public Object execute() {
                    MediaItemLayerImpl.this._vrContext.setTime(MediaItemLayerImpl.this.calcVideoMediaTime(MediaItemLayerImpl.this.getMediaInput()));
                    preComp.setupCollapseTransformation(composer, camera, ct2);
                    return null;
                }
            });
        } else {
            final VideoLayerComposerImpl composer2 = new VideoLayerComposerImpl(this._vrContext, this._vrSupport, this._vrContext.getColorMode(), camera.getViewportSize(), camera.getPosition());
            this._vrContext.saveAndExecute(new WrappedOperation<Object>(){

                @Override
                public Object execute() {
                    MediaItemLayerImpl.this._vrContext.setTime(MediaItemLayerImpl.this.calcVideoMediaTime(MediaItemLayerImpl.this.getMediaInput()));
                    preComp.setupCollapseTransformation(composer2, camera, ct2);
                    return null;
                }
            });
            composer.add2D(new VideoLayerRenderer(){

                public VideoLayerBuffer render(boolean withDepthBuffer) {
                    VideoBuffer effectedBuffer = null;
                    VideoBuffer resultBuffer = null;
                    try {
                        WrappedOperation<VideoBuffer> inputBufferOperation = new WrappedOperation<VideoBuffer>(){

                            @Override
                            public VideoBuffer execute() {
                                return composer2.compose();
                            }
                        };
                        effectedBuffer = MediaItemLayerImpl.this._vePipeline.doVideoEffects(MediaItemLayerImpl.this.isEffectsEnabled() ? MediaItemLayerImpl.this.getEffects() : Collections.emptyList(), inputBufferOperation);
                        VideoBounds resultBounds = new VideoBounds(camera.getViewportSize());
                        if (effectedBuffer.getBounds().equals((Object)resultBounds)) {
                            resultBuffer = effectedBuffer;
                            effectedBuffer = null;
                        } else {
                            resultBuffer = MediaItemLayerImpl.this._vrSupport.createVideoBuffer(MediaItemLayerImpl.this._vrContext.getColorMode(), resultBounds);
                            resultBuffer.allocateAsTexture();
                            resultBuffer.clear();
                            MediaItemLayerImpl.this._vrSupport.copy(effectedBuffer, resultBuffer);
                        }
                        VideoLayerBufferImpl vlb = new VideoLayerBufferImpl(resultBuffer, null, MediaItemLayerImpl.this.getBlendMode(), 1.0);
                        resultBuffer = null;
                        VideoLayerBufferImpl videoLayerBufferImpl = vlb;
                        return videoLayerBufferImpl;
                    }
                    finally {
                        if (resultBuffer != null) {
                            resultBuffer.dispose();
                        }
                        if (effectedBuffer != null) {
                            effectedBuffer.dispose();
                        }
                    }
                }
            });
        }
    }
}

