/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.core.services.VideoRenderContext;
import javax.media.opengl.GL2;

public class AntiAliasSupportImpl
implements IAntiAliasSupport {
    private final VideoRenderContext _vrContext;
    private final int _samples;
    private int _frameBuffer;
    private int _renderBuffer;
    private int _width;
    private int _height;

    AntiAliasSupportImpl(VideoRenderContext vrContext, int samples) {
        this._vrContext = vrContext;
        this._samples = samples;
    }

    void dispose() {
        GL2 gl = this._vrContext.getGL().getGL2();
        this._width = 0;
        this._height = 0;
        if (this._renderBuffer != 0) {
            gl.glDeleteRenderbuffers(1, new int[]{this._renderBuffer}, 0);
            this._renderBuffer = 0;
        }
        if (this._frameBuffer != 0) {
            gl.glDeleteFramebuffers(1, new int[]{this._frameBuffer}, 0);
            this._frameBuffer = 0;
        }
    }

    private int getFrameBuffer(GL2 gl) {
        if (this._frameBuffer == 0) {
            int[] fb = new int[1];
            gl.glGenFramebuffers(1, fb, 0);
            this._frameBuffer = fb[0];
        }
        return this._frameBuffer;
    }

    private int getRenderBuffer(GL2 gl) {
        if (this._renderBuffer == 0) {
            int[] rb = new int[1];
            gl.glGenRenderbuffers(1, rb, 0);
            this._renderBuffer = rb[0];
        }
        return this._renderBuffer;
    }

    public void antiAlias(int width, int height, Color clearColor, Runnable operation) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this._samples < 2) {
            operation.run();
            return;
        }
        GL2 gl = this._vrContext.getGL().getGL2();
        int[] savedFb = new int[1];
        gl.glGetIntegerv(36006, savedFb, 0);
        try {
            int fb = this.getFrameBuffer(gl);
            int rb = this.getRenderBuffer(gl);
            gl.glBindFramebuffer(36160, fb);
            gl.glBindRenderbuffer(36161, rb);
            if (width != this._width || height != this._height) {
                gl.glRenderbufferStorageMultisample(36161, this._samples, this._vrContext.getColorMode().glInternalFormat, width, height);
                this._width = width;
                this._height = height;
            }
            gl.glFramebufferRenderbuffer(36160, 36064, 36161, rb);
            if (clearColor != null) {
                float a = (float)clearColor.a;
                float r = (float)clearColor.r * a;
                float g = (float)clearColor.g * a;
                float b = (float)clearColor.b * a;
                gl.glClearColor(r, g, b, a);
                gl.glClear(16384);
            }
            operation.run();
            gl.glBindFramebuffer(36008, fb);
            gl.glBindFramebuffer(36009, savedFb[0]);
            gl.glBlitFramebuffer(0, 0, width, height, 0, 0, width, height, 16384, 9728);
        }
        finally {
            gl.glFramebufferRenderbuffer(36160, 36064, 36161, 0);
            gl.glBindRenderbuffer(36161, 0);
            gl.glBindFramebuffer(36160, savedFb[0]);
        }
    }

    public void antiAlias(int width, int height, Runnable operation) {
        this.antiAlias(width, height, Color.COLORLESS_TRANSPARENT, operation);
    }
}

