/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.core.internal.services.AntiAliasSupportImpl;
import ch.kuramo.javie.core.services.VideoRenderContext;

public class AntiAliasSupportProxy
implements IAntiAliasSupport {
    private static final ThreadLocal<AntiAliasSupportImpl> _threadLocal = new ThreadLocal();

    static AntiAliasSupportImpl createImpl(VideoRenderContext vrContext, int samples) {
        if (_threadLocal.get() != null) {
            throw new IllegalStateException("AntiAliasSupportImpl already exists on this thread.");
        }
        AntiAliasSupportImpl impl = new AntiAliasSupportImpl(vrContext, samples);
        _threadLocal.set(impl);
        return impl;
    }

    static void disposeImpl() {
        AntiAliasSupportImpl impl = _threadLocal.get();
        if (impl != null) {
            impl.dispose();
            _threadLocal.set(null);
        }
    }

    private AntiAliasSupportImpl getImpl() {
        AntiAliasSupportImpl impl = _threadLocal.get();
        if (impl == null) {
            throw new IllegalStateException("No AntiAliasSupportImpl exist on this thread.");
        }
        return impl;
    }

    public void antiAlias(int width, int height, Color clearColor, Runnable operation) {
        this.getImpl().antiAlias(width, height, clearColor, operation);
    }

    public void antiAlias(int width, int height, Runnable operation) {
        this.getImpl().antiAlias(width, height, operation);
    }
}

