/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableString;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IAnimatableVec3d;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.core.AnimatableBoolean;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.Util;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EffectDescriptorImpl
implements EffectDescriptor {
    private final String _type;
    private final Class<?> _interiorClass;
    private final Class<Effect> _exteriorClass;
    private final Class<?> _exprInterface;
    private final ResourceBundle _bundle;
    private final String _category;
    private final String _label;
    private final Map<String, PropertyDescriptor> _propertyDescriptorMap;
    private final List<PropertyDescriptor> _propertyDescriptorList;

    EffectDescriptorImpl(String type, Class<?> interiorClass, Class<Effect> exteriorClass, Class<?> exprInterface) {
        this._type = type;
        this._interiorClass = interiorClass;
        this._exteriorClass = exteriorClass;
        this._exprInterface = exprInterface;
        this._bundle = this.getBundle();
        this._category = interiorClass.getAnnotation(ch.kuramo.javie.api.annotations.Effect.class).category().trim();
        this._label = this.getString("label");
        this._propertyDescriptorMap = Collections.unmodifiableMap(this.createPropertyDescriptors());
        this._propertyDescriptorList = Collections.unmodifiableList(Util.newList(this._propertyDescriptorMap.values()));
    }

    private ResourceBundle getBundle() {
        try {
            String className = this._interiorClass.getName();
            String bundleName = String.valueOf(className.substring(0, className.lastIndexOf(46) + 1)) + "messages";
            return ResourceBundle.getBundle(bundleName, Locale.getDefault(), this._interiorClass.getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private String getString(String key) {
        String str = this.getString(key, null);
        return str != null ? str : String.valueOf('!') + key + '!';
    }

    private String getString(String key, String defaultStr) {
        String str = null;
        if (this._bundle != null) {
            try {
                str = this._bundle.getString(String.format("%s.%s", this._interiorClass.getSimpleName(), key));
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return str != null ? str : defaultStr;
    }

    private Map<String, PropertyDescriptor> createPropertyDescriptors() {
        LinkedHashMap<String, PropertyDescriptor> map = Util.newLinkedHashMap();
        Field[] fieldArray = this._interiorClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            Property anno = f.getAnnotation(Property.class);
            if (anno != null) {
                String name = f.getName();
                String value = anno.value();
                String min = anno.min();
                String max = anno.max();
                Class<?> type = f.getType();
                if (IAnimatableDouble.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableDoublePropertyDescriptor(name, value, min, max));
                } else if (IAnimatableInteger.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableIntegerPropertyDescriptor(name, value, min, max));
                } else if (IAnimatableVec2d.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableVec2dPropertyDescriptor(name, value, min, max));
                } else if (IAnimatableVec3d.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableVec3dPropertyDescriptor(name, value, min, max));
                } else if (IAnimatableColor.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableColorPropertyDescriptor(name, value));
                } else if (IAnimatableString.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableStringPropertyDescriptor(name, value));
                } else if (IAnimatableBoolean.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableBooleanPropertyDescriptor(name, value));
                } else if (IAnimatableEnum.class.isAssignableFrom(type)) {
                    map.put(name, new AnimatableEnumPropertyDescriptor(name, value));
                }
            }
            ++n2;
        }
        return map;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public Class<Effect> getEffectClass() {
        return this._exteriorClass;
    }

    @Override
    public Class<?> getExpressionInterface() {
        return this._exprInterface;
    }

    @Override
    public String getCategory() {
        return this._category;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public List<PropertyDescriptor> getPropertyDescriptors() {
        return this._propertyDescriptorList;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this._propertyDescriptorMap.get(name);
    }

    private <A extends AnimatableValue<?>> Class<A> getPropertyType(String propertyName) {
        try {
            String upperCamelCase = String.valueOf(Character.toUpperCase(propertyName.charAt(0))) + propertyName.substring(1);
            Class<?> propertyType = this._exteriorClass.getMethod("get" + upperCamelCase, new Class[0]).getReturnType();
            return propertyType;
        }
        catch (NoSuchMethodException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private static boolean toBoolean(String s) {
        return Boolean.parseBoolean(s.trim());
    }

    private static double toDouble(String s, double defaultValue) {
        if (s.length() > 0) {
            try {
                return Double.parseDouble(s.trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private static float toFloat(String s, float defaultValue) {
        if (s.length() > 0) {
            try {
                return Float.parseFloat(s.trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private static long toLong(String s, long defaultValue) {
        if (s.length() > 0) {
            try {
                return Long.parseLong(s.trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private static int toInteger(String s, int defaultValue) {
        if (s.length() > 0) {
            try {
                return Integer.parseInt(s.trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private static short toShort(String s, short defaultValue) {
        if (s.length() > 0) {
            try {
                return Short.parseShort(s.trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private static char toCharacter(String s, char defaultValue) {
        if (s.length() > 0) {
            try {
                int intValue = Integer.parseInt(s.trim());
                if (intValue < 0 || intValue > 65535) {
                    throw new NumberFormatException(s);
                }
                return (char)intValue;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private static byte toByte(String s, byte defaultValue) {
        if (s.length() > 0) {
            try {
                int intValue = Integer.parseInt(s.trim());
                if (intValue < -128 || intValue > 127) {
                    throw new NumberFormatException(s);
                }
                return (byte)intValue;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private static Vec2d toVec2d(String s, Vec2d defaultValue) {
        if (s.length() > 0) {
            try {
                double x;
                double y;
                String[] array = s.trim().split("\\s*,\\s*");
                switch (array.length) {
                    case 1: {
                        x = y = Double.parseDouble(array[0]);
                        break;
                    }
                    default: {
                        x = Double.parseDouble(array[0]);
                        y = Double.parseDouble(array[1]);
                    }
                }
                return new Vec2d(x, y);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private static Vec3d toVec3d(String s, Vec3d defaultValue) {
        if (s.length() > 0) {
            try {
                double x;
                double y;
                double z;
                String[] array = s.trim().split("\\s*,\\s*");
                switch (array.length) {
                    case 1: {
                        y = z = Double.parseDouble(array[0]);
                        x = z;
                        break;
                    }
                    case 2: {
                        x = Double.parseDouble(array[0]);
                        y = Double.parseDouble(array[1]);
                        z = 0.0;
                        break;
                    }
                    default: {
                        x = Double.parseDouble(array[0]);
                        y = Double.parseDouble(array[1]);
                        z = Double.parseDouble(array[2]);
                    }
                }
                return new Vec3d(x, y, z);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private static Color toColor(String s, Color defaultValue) {
        if (s.length() > 0) {
            try {
                double a;
                double r;
                double g;
                double b;
                String[] array = s.trim().split("\\s*,\\s*");
                switch (array.length) {
                    case 1: {
                        g = b = Double.parseDouble(array[0]);
                        r = b;
                        a = 1.0;
                        break;
                    }
                    case 2: {
                        g = b = Double.parseDouble(array[0]);
                        r = b;
                        a = Double.parseDouble(array[1]);
                        break;
                    }
                    case 3: {
                        r = Double.parseDouble(array[0]);
                        g = Double.parseDouble(array[1]);
                        b = Double.parseDouble(array[2]);
                        a = 1.0;
                        break;
                    }
                    default: {
                        r = Double.parseDouble(array[0]);
                        g = Double.parseDouble(array[1]);
                        b = Double.parseDouble(array[2]);
                        a = Double.parseDouble(array[3]);
                    }
                }
                return new Color(r, g, b, a);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private static <E extends Enum<E>> E toEnum(Class<E> enumType, String s) {
        try {
            return Enum.valueOf(enumType, s.trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Enum first = (Enum)Array.get(enumType.getMethod("values", new Class[0]).invoke(null, new Object[0]), 0);
                return (E)first;
            }
            catch (IllegalAccessException e) {
                throw new JavieRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new JavieRuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new JavieRuntimeException(e);
            }
        }
    }

    private static Object toPrimitive(Class<?> primitiveType, String s) {
        if (primitiveType == Boolean.TYPE) {
            return EffectDescriptorImpl.toBoolean(s);
        }
        if (primitiveType == Double.TYPE) {
            return EffectDescriptorImpl.toDouble(s, 0.0);
        }
        if (primitiveType == Float.TYPE) {
            return Float.valueOf(EffectDescriptorImpl.toFloat(s, 0.0f));
        }
        if (primitiveType == Long.TYPE) {
            return EffectDescriptorImpl.toLong(s, 0L);
        }
        if (primitiveType == Integer.TYPE) {
            return EffectDescriptorImpl.toInteger(s, 0);
        }
        if (primitiveType == Short.TYPE) {
            return EffectDescriptorImpl.toShort(s, (short)0);
        }
        if (primitiveType == Character.TYPE) {
            return Character.valueOf(EffectDescriptorImpl.toCharacter(s, '\u0000'));
        }
        if (primitiveType == Byte.TYPE) {
            return EffectDescriptorImpl.toByte(s, (byte)0);
        }
        throw new JavieRuntimeException("unsupported type: " + primitiveType.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractPropertyDescriptor<T>
    implements PropertyDescriptor {
        protected final Class<T> type;
        protected final String name;
        protected final String label;
        protected final Method getter;
        protected final Method setter;

        private AbstractPropertyDescriptor(Class<T> type, String name) {
            this.type = type;
            this.name = name;
            this.label = EffectDescriptorImpl.this.getString(String.valueOf(name) + ".label");
            try {
                String upperCamelCase = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
                this.getter = EffectDescriptorImpl.this._exteriorClass.getDeclaredMethod("get" + upperCamelCase, new Class[0]);
                this.setter = EffectDescriptorImpl.this._exteriorClass.getDeclaredMethod("set" + upperCamelCase, type);
            }
            catch (NoSuchMethodException e) {
                throw new JavieRuntimeException(e);
            }
        }

        public Class<T> getPropertyClass() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getString(String key) {
            return EffectDescriptorImpl.this.getString(String.valueOf(this.name) + "." + key, null);
        }

        @Override
        public void afterDecode(Project p, Effect effect) throws ProjectDecodeException {
        }

        public T get(Effect effect) {
            try {
                Object value = this.getter.invoke((Object)effect, new Object[0]);
                return (T)value;
            }
            catch (IllegalAccessException e) {
                throw new JavieRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new JavieRuntimeException(e);
            }
        }

        protected void set(Effect effect, T value) {
            try {
                this.setter.invoke((Object)effect, value);
            }
            catch (IllegalAccessException e) {
                throw new JavieRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new JavieRuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableBooleanPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableBoolean> {
        private final Boolean value;

        private AnimatableBooleanPropertyDescriptor(String name, String value) {
            super(AnimatableBoolean.class, name);
            this.value = EffectDescriptorImpl.toBoolean(value);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableBoolean(this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableColorPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableColor> {
        private final Color value;

        private AnimatableColorPropertyDescriptor(String name, String value) {
            super(AnimatableColor.class, name);
            this.value = EffectDescriptorImpl.toColor(value, Color.BLACK);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableColor(this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableDoublePropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableDouble> {
        private final Double value;
        private final Double min;
        private final Double max;

        private AnimatableDoublePropertyDescriptor(String name, String value, String min, String max) {
            super(AnimatableDouble.class, name);
            this.min = EffectDescriptorImpl.toDouble(min, Double.NEGATIVE_INFINITY);
            this.max = Math.max(this.min, EffectDescriptorImpl.toDouble(max, Double.POSITIVE_INFINITY));
            this.value = Math.max(this.min, Math.min(this.max, EffectDescriptorImpl.toDouble(value, 0.0)));
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableDouble(this.value, this.min, this.max));
        }
    }

    private class AnimatableEnumPropertyDescriptor
    extends AbstractPropertyDescriptor {
        private final Class<Enum> enumType;
        private final Constructor<?> constructor;
        private final Enum value;

        private AnimatableEnumPropertyDescriptor(String name, String value) {
            super(EffectDescriptorImpl.this.getPropertyType(name), name);
            try {
                ParameterizedType genericSuper = (ParameterizedType)this.type.getGenericSuperclass();
                this.enumType = (Class)genericSuper.getActualTypeArguments()[0];
                this.constructor = this.type.getConstructor(this.enumType);
                this.value = EffectDescriptorImpl.toEnum(this.enumType, value);
            }
            catch (NoSuchMethodException e) {
                throw new JavieRuntimeException(e);
            }
        }

        public void initValue(Effect effect) {
            try {
                this.set(effect, this.constructor.newInstance(this.value));
            }
            catch (InstantiationException e) {
                throw new JavieRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new JavieRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new JavieRuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableIntegerPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableInteger> {
        private final Integer value;
        private final Integer min;
        private final Integer max;

        private AnimatableIntegerPropertyDescriptor(String name, String value, String min, String max) {
            super(AnimatableInteger.class, name);
            this.min = EffectDescriptorImpl.toInteger(min, Integer.MIN_VALUE);
            this.max = Math.max(this.min, EffectDescriptorImpl.toInteger(max, Integer.MAX_VALUE));
            this.value = Math.max(this.min, Math.min(this.max, EffectDescriptorImpl.toInteger(value, 0)));
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableInteger(this.value, this.min, this.max));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableStringPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableString> {
        private final String value;

        private AnimatableStringPropertyDescriptor(String name, String value) {
            super(AnimatableString.class, name);
            this.value = value;
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableString(this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableVec2dPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableVec2d> {
        private final Vec2d value;
        private final Vec2d min;
        private final Vec2d max;

        private AnimatableVec2dPropertyDescriptor(String name, String value, String min, String max) {
            super(AnimatableVec2d.class, name);
            this.min = EffectDescriptorImpl.toVec2d(min, Vec2d.NEGATIVE_INFINITY);
            this.max = Vec2d.max((Vec2d)this.min, (Vec2d)EffectDescriptorImpl.toVec2d(max, Vec2d.POSITIVE_INFINITY));
            this.value = Vec2d.max((Vec2d)this.min, (Vec2d)Vec2d.min((Vec2d)this.max, (Vec2d)EffectDescriptorImpl.toVec2d(value, Vec2d.ZERO)));
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableVec2d(this.value, this.min, this.max));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimatableVec3dPropertyDescriptor
    extends AbstractPropertyDescriptor<AnimatableVec3d> {
        private final Vec3d value;
        private final Vec3d min;
        private final Vec3d max;

        private AnimatableVec3dPropertyDescriptor(String name, String value, String min, String max) {
            super(AnimatableVec3d.class, name);
            this.min = EffectDescriptorImpl.toVec3d(min, Vec3d.NEGATIVE_INFINITY);
            this.max = Vec3d.max((Vec3d)this.min, (Vec3d)EffectDescriptorImpl.toVec3d(max, Vec3d.POSITIVE_INFINITY));
            this.value = Vec3d.max((Vec3d)this.min, (Vec3d)Vec3d.min((Vec3d)this.max, (Vec3d)EffectDescriptorImpl.toVec3d(value, Vec3d.ZERO)));
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, new AnimatableVec3d(this.value, this.min, this.max));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnumPropertyDescriptor
    extends AbstractPropertyDescriptor<Enum> {
        private final Enum value;

        private EnumPropertyDescriptor(String name, String value, Class<Enum> enumType) {
            super(enumType, name);
            this.value = EffectDescriptorImpl.toEnum(enumType, value);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrimitivePropertyDescriptor
    extends AbstractPropertyDescriptor {
        private final Object value;

        private PrimitivePropertyDescriptor(String name, String value, Class<?> primitiveType) {
            super(primitiveType, name);
            this.value = EffectDescriptorImpl.toPrimitive(primitiveType, value);
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringPropertyDescriptor
    extends AbstractPropertyDescriptor<String> {
        private final String value;

        private StringPropertyDescriptor(String name, String value) {
            super(String.class, name);
            this.value = value;
        }

        @Override
        public void initValue(Effect effect) {
            this.set(effect, this.value);
        }
    }
}

