/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.core.BlendMode;
import ch.kuramo.javie.core.DepthBuffer;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.VideoLayerBuffer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.DepthBufferImpl;
import ch.kuramo.javie.core.internal.VideoBufferImpl;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import ch.kuramo.javie.core.shaders.BlendModeShaders;
import ch.kuramo.javie.core.shaders.TrackMatteShaders;
import com.google.inject.Inject;
import com.google.inject.Injector;
import ftgl.FTGL;
import ftgl.FTGLfont;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoRenderSupportImpl
implements VideoRenderSupport {
    private static final Logger _logger = LoggerFactory.getLogger(VideoRenderSupportImpl.class);
    private static final float[] FLOAT0000 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    @Inject
    private Injector _injector;
    @Inject
    private GLGlobal _glGlobal;
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private IShaderRegistry _shaders;
    @Inject
    private IAntiAliasSupport _aaSupport;
    @Inject
    private IArrayPools _arrayPools;
    private static final int[][] _frustumEdgeTable;
    private static final int[][] _frustumClipSearchTable;

    static {
        int[][] nArrayArray = new int[12][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 6;
        nArrayArray[2] = nArray3;
        nArrayArray[3] = new int[]{1, 3};
        nArrayArray[4] = new int[]{1, 7};
        nArrayArray[5] = new int[]{2, 3};
        nArrayArray[6] = new int[]{2, 4};
        nArrayArray[7] = new int[]{3, 5};
        nArrayArray[8] = new int[]{4, 5};
        nArrayArray[9] = new int[]{4, 6};
        nArrayArray[10] = new int[]{5, 7};
        nArrayArray[11] = new int[]{6, 7};
        _frustumEdgeTable = nArrayArray;
        int[][] nArrayArray2 = new int[12][];
        nArrayArray2[0] = new int[]{1, 3, 5, 2, 4, 11};
        int[] nArray4 = new int[6];
        nArray4[1] = 3;
        nArray4[2] = 5;
        nArray4[3] = 2;
        nArray4[4] = 6;
        nArray4[5] = 9;
        nArrayArray2[1] = nArray4;
        int[] nArray5 = new int[6];
        nArray5[0] = 1;
        nArray5[1] = 6;
        nArray5[2] = 9;
        nArray5[4] = 4;
        nArray5[5] = 11;
        nArrayArray2[2] = nArray5;
        int[] nArray6 = new int[6];
        nArray6[1] = 1;
        nArray6[2] = 5;
        nArray6[3] = 4;
        nArray6[4] = 7;
        nArray6[5] = 10;
        nArrayArray2[3] = nArray6;
        int[] nArray7 = new int[6];
        nArray7[1] = 2;
        nArray7[2] = 11;
        nArray7[3] = 3;
        nArray7[4] = 7;
        nArray7[5] = 10;
        nArrayArray2[4] = nArray7;
        int[] nArray8 = new int[6];
        nArray8[1] = 1;
        nArray8[2] = 3;
        nArray8[3] = 6;
        nArray8[4] = 7;
        nArray8[5] = 8;
        nArrayArray2[5] = nArray8;
        nArrayArray2[6] = new int[]{1, 2, 9, 5, 7, 8};
        nArrayArray2[7] = new int[]{3, 4, 10, 5, 6, 8};
        nArrayArray2[8] = new int[]{5, 6, 7, 9, 10, 11};
        nArrayArray2[9] = new int[]{1, 2, 6, 8, 10, 11};
        nArrayArray2[10] = new int[]{3, 4, 7, 8, 9, 11};
        int[] nArray9 = new int[6];
        nArray9[1] = 2;
        nArray9[2] = 4;
        nArray9[3] = 8;
        nArray9[4] = 9;
        nArray9[5] = 10;
        nArrayArray2[11] = nArray9;
        _frustumClipSearchTable = nArrayArray2;
    }

    @Override
    public VideoBuffer createVideoBuffer(ColorMode colorMode, Size2i size) {
        VideoBufferImpl vb = new VideoBufferImpl(colorMode, size);
        this._injector.injectMembers((Object)vb);
        return vb;
    }

    @Override
    public VideoBuffer createVideoBuffer(ColorMode colorMode, VideoBounds bounds) {
        VideoBufferImpl vb = new VideoBufferImpl(colorMode, bounds);
        this._injector.injectMembers((Object)vb);
        return vb;
    }

    @Override
    public DepthBuffer createDepthBuffer(Size2i size) {
        DepthBufferImpl db = new DepthBufferImpl(size);
        this._injector.injectMembers((Object)db);
        return db;
    }

    @Override
    public int createTexture(ColorMode colorMode, Size2i textureSize) {
        GL2 gl = this._vrContext.getGL().getGL2();
        int[] tex = new int[1];
        gl.glGenTextures(1, tex, 0);
        gl.glBindTexture(34037, tex[0]);
        gl.glTexParameteri(34037, 10241, 9729);
        gl.glTexParameteri(34037, 10240, 9729);
        gl.glTexParameteri(34037, 10242, 33069);
        gl.glTexParameteri(34037, 10243, 33069);
        gl.glTexParameterfv(34037, 4100, FLOAT0000, 0);
        gl.glTexImage2D(34037, 0, colorMode.glInternalFormat, Math.max(1, textureSize.width), Math.max(1, textureSize.height), 0, 32993, colorMode.glDataType, null);
        gl.glBindTexture(34037, 0);
        return tex[0];
    }

    @Override
    public int createDepthTexture(Size2i textureSize) {
        GL2 gl = this._vrContext.getGL().getGL2();
        int[] tex = new int[1];
        gl.glGenTextures(1, tex, 0);
        gl.glBindTexture(34037, tex[0]);
        gl.glTexParameteri(34037, 10241, 9728);
        gl.glTexParameteri(34037, 10240, 9728);
        gl.glTexParameteri(34037, 10242, 33069);
        gl.glTexParameteri(34037, 10243, 33069);
        gl.glTexParameterfv(34037, 4100, FLOAT0000, 0);
        gl.glTexImage2D(34037, 0, 33191, Math.max(1, textureSize.width), Math.max(1, textureSize.height), 0, 6402, 5126, null);
        gl.glBindTexture(34037, 0);
        return tex[0];
    }

    @Override
    public void deleteTexture(int texture) {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glDeleteTextures(1, new int[]{texture}, 0);
    }

    @Override
    public IArray<?> createArray(ColorMode colorMode, Size2i imageSize) {
        int arraySize = imageSize.width * imageSize.height * 4;
        switch (colorMode) {
            case RGBA8: {
                return this._arrayPools.getByteArray(arraySize);
            }
            case RGBA16: {
                return this._arrayPools.getShortArray(arraySize);
            }
            case RGBA16_FLOAT: 
            case RGBA32_FLOAT: {
                return this._arrayPools.getFloatArray(arraySize);
            }
        }
        throw new UnsupportedOperationException("ColorMode: " + colorMode.name());
    }

    @Override
    public void copyArrayToTexture(Object array, int texture, ColorMode colorMode, Size2i imageSize) {
        ReentrantLock lock = this._glGlobal.getGlobalLock();
        lock.lock();
        try {
            GL2 gl = this._vrContext.getGL().getGL2();
            int[] pbo = new int[1];
            gl.glGenBuffers(1, pbo, 0);
            gl.glBindBuffer(35052, pbo[0]);
            gl.glBindTexture(34037, texture);
            int imageBytes = imageSize.width * imageSize.height * colorMode.javaPixelBytes;
            gl.glBufferData(35052, imageBytes, this.toNioBuffer(array), 35040);
            gl.glTexSubImage2D(34037, 0, 0, 0, imageSize.width, imageSize.height, 32993, colorMode.glDataType, 0L);
            gl.glBindTexture(34037, 0);
            gl.glBindBuffer(35052, 0);
            gl.glDeleteBuffers(1, pbo, 0);
        }
        finally {
            lock.unlock();
        }
    }

    private Buffer toNioBuffer(Object array) {
        if (array instanceof byte[]) {
            return ByteBuffer.wrap((byte[])array);
        }
        if (array instanceof short[]) {
            return ShortBuffer.wrap((short[])array);
        }
        if (array instanceof float[]) {
            return FloatBuffer.wrap((float[])array);
        }
        throw new IllegalArgumentException("not array or unsupported array type: " + array.getClass().getName());
    }

    @Override
    public void copyTextureToArray(int texture, Object array, ColorMode colorMode, Size2i imageSize) {
        ReentrantLock lock = this._glGlobal.getGlobalLock();
        lock.lock();
        try {
            GL2 gl = this._vrContext.getGL().getGL2();
            int[] pbo = new int[1];
            gl.glGenBuffers(1, pbo, 0);
            gl.glBindBuffer(35051, pbo[0]);
            gl.glBindTexture(34037, texture);
            int imageBytes = imageSize.width * imageSize.height * colorMode.javaPixelBytes;
            gl.glBufferData(35051, imageBytes, null, 35041);
            gl.glFramebufferTexture2D(36160, 36064, 34037, texture, 0);
            gl.glReadBuffer(36064);
            gl.glReadPixels(0, 0, imageSize.width, imageSize.height, 32993, colorMode.glDataType, 0L);
            ByteBuffer mappedPBO = gl.glMapBuffer(35051, 35000);
            this.copyPBOToArray(mappedPBO, array);
            gl.glUnmapBuffer(35051);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            gl.glBindTexture(34037, 0);
            gl.glBindBuffer(35051, 0);
            gl.glDeleteBuffers(1, pbo, 0);
        }
        finally {
            lock.unlock();
        }
    }

    private void copyPBOToArray(ByteBuffer mappedPBO, Object array) {
        if (array instanceof byte[]) {
            mappedPBO.get((byte[])array, 0, mappedPBO.capacity());
        } else if (array instanceof short[]) {
            mappedPBO.asShortBuffer().get((short[])array, 0, mappedPBO.capacity() / 2);
        } else if (array instanceof float[]) {
            mappedPBO.asFloatBuffer().get((float[])array, 0, mappedPBO.capacity() / 4);
        } else {
            throw new IllegalArgumentException("not array or unsupported array type: " + array.getClass().getName());
        }
    }

    @Override
    public void clear(VideoBuffer videoBuffer) {
        if (videoBuffer.isArray()) {
            Size2i size = videoBuffer.getImageSize();
            this.clear(videoBuffer.getArray(), size.width * size.height * 4);
            return;
        }
        if (!videoBuffer.isAllocated()) {
            videoBuffer.allocateAsTexture();
        }
        this.fill(videoBuffer.getTexture(), Color.COLORLESS_TRANSPARENT);
    }

    private void clear(Object array, int length) {
        if (array instanceof byte[]) {
            Arrays.fill((byte[])array, 0, length, (byte)0);
        } else if (array instanceof short[]) {
            Arrays.fill((short[])array, 0, length, (short)0);
        } else if (array instanceof float[]) {
            Arrays.fill((float[])array, 0, length, 0.0f);
        } else {
            throw new IllegalArgumentException("not array or unsupported array type: " + array.getClass().getName());
        }
    }

    @Override
    public void fill(VideoBuffer videoBuffer, Color color) {
        if (videoBuffer.isArray()) {
            this.fill(videoBuffer.getArray(), videoBuffer.getImageSize(), color);
            return;
        }
        if (!videoBuffer.isAllocated()) {
            videoBuffer.allocateAsTexture();
        }
        if (videoBuffer.getBounds().isEmpty()) {
            this.fill(videoBuffer.getTexture(), Color.COLORLESS_TRANSPARENT);
        } else {
            this.fill(videoBuffer.getTexture(), color);
        }
    }

    private void fill(int texture, Color color) {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glFramebufferTexture2D(36160, 36064, 34037, texture, 0);
        gl.glDrawBuffer(36064);
        float a = (float)color.a;
        float r = (float)color.r * a;
        float g = (float)color.g * a;
        float b = (float)color.b * a;
        gl.glClearColor(r, g, b, a);
        gl.glClear(16384);
        gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
    }

    private void fill(Object array, Size2i imageSize, Color color) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void fillRectCR(VideoBuffer resultBuffer, final double[] mvMatrix, final double[] prjMatrix, final Size2i size, final Color color) {
        final int resultTexture = resultBuffer.getTexture();
        final Size2i resultImageSize = resultBuffer.getImageSize();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                gl.glViewport(0, 0, resultImageSize.width, resultImageSize.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(prjMatrix, 0);
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                float a = (float)color.a;
                float r = (float)color.r * a;
                float g = (float)color.g * a;
                float b = (float)color.b * a;
                gl.glColor4f(r, g, b, a);
                VideoRenderSupportImpl.this._aaSupport.antiAlias(resultImageSize.width, resultImageSize.height, new Runnable(){

                    public void run() {
                        gl.glBegin(7);
                        gl.glVertex2i(0, 0);
                        gl.glVertex2i(size.width, 0);
                        gl.glVertex2i(size.width, size.height);
                        gl.glVertex2i(0, size.height);
                        gl.glEnd();
                    }
                });
                gl.glColor4fv(savedColor, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    private void ortho2D(GL2 gl, GLU glu, Size2i imageSize) {
        this.ortho2D(gl, glu, imageSize.width, imageSize.height);
    }

    private void ortho2D(GL2 gl, GLU glu, int width, int height) {
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(0.0f, (float)width, 0.0f, (float)height);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    @Override
    public void trackMatte(VideoBuffer matteBuffer, VideoBuffer fillBuffer, VideoBuffer resultBuffer, final TrackMatte trackMatte, final double matteOpacity) {
        if (trackMatte == TrackMatte.NONE) {
            throw new IllegalArgumentException();
        }
        final int matteTexture = matteBuffer.getTexture();
        final int fillTexture = fillBuffer.getTexture();
        final int resultTexture = resultBuffer.getTexture();
        final Size2i imageSize = resultBuffer.getImageSize();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                VideoRenderSupportImpl.this.ortho2D(gl, VideoRenderSupportImpl.this._vrContext.getGLU(), imageSize);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, fillTexture);
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, matteTexture);
                final IShaderProgram program = VideoRenderSupportImpl.this._shaders.getProgram(TrackMatteShaders.class, trackMatte.name());
                program.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1i(program.getUniformLocation("texFill"), 0);
                        gl.glUniform1i(program.getUniformLocation("texMatte"), 1);
                        gl.glUniform1f(program.getUniformLocation("matteOpacity"), (float)matteOpacity);
                        gl.glBegin(7);
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f((float)imageSize.width, 0.0f);
                        gl.glVertex2f((float)imageSize.width, 0.0f);
                        gl.glTexCoord2f((float)imageSize.width, (float)imageSize.height);
                        gl.glVertex2f((float)imageSize.width, (float)imageSize.height);
                        gl.glTexCoord2f(0.0f, (float)imageSize.height);
                        gl.glVertex2f(0.0f, (float)imageSize.height);
                        gl.glEnd();
                    }
                });
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, 0);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void blend(VideoBuffer srcBuffer, VideoBuffer dstBuffer, VideoBuffer resultBuffer, final BlendMode blendMode, final double opacity) {
        final int srcTexture = srcBuffer.getTexture();
        final int dstTexture = dstBuffer.getTexture();
        final int resultTexture = resultBuffer.getTexture();
        final Size2i imageSize = resultBuffer.getImageSize();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                VideoRenderSupportImpl.this.ortho2D(gl, VideoRenderSupportImpl.this._vrContext.getGLU(), imageSize);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, dstTexture);
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, srcTexture);
                final IShaderProgram program = VideoRenderSupportImpl.this._shaders.getProgram(BlendModeShaders.class, blendMode.name());
                program.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1i(program.getUniformLocation("texDst"), 0);
                        gl.glUniform1i(program.getUniformLocation("texSrc"), 1);
                        gl.glUniform1f(program.getUniformLocation("opacity"), (float)opacity);
                        if (blendMode == BlendMode.DANCING_DISSOLVE) {
                            gl.glUniform1f(program.getUniformLocation("time"), (float)VideoRenderSupportImpl.this._vrContext.getTime().toSecond());
                        }
                        gl.glBegin(7);
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f((float)imageSize.width, 0.0f);
                        gl.glVertex2f((float)imageSize.width, 0.0f);
                        gl.glTexCoord2f((float)imageSize.width, (float)imageSize.height);
                        gl.glVertex2f((float)imageSize.width, (float)imageSize.height);
                        gl.glTexCoord2f(0.0f, (float)imageSize.height);
                        gl.glVertex2f(0.0f, (float)imageSize.height);
                        gl.glEnd();
                    }
                });
                gl.glActiveTexture(33985);
                gl.glBindTexture(34037, 0);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void blend(final Collection<VideoLayerBuffer> srcBuffers, final VideoBuffer dstBuffer, VideoBuffer resultBuffer) {
        final int resultTexture = resultBuffer.getTexture();
        final Size2i imageSize = resultBuffer.getImageSize();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                VideoRenderSupportImpl.this.ortho2D(gl, VideoRenderSupportImpl.this._vrContext.getGLU(), imageSize);
                final int maxLayers = BlendModeShaders.getMaxIntersectingLayers();
                if (srcBuffers.size() > maxLayers) {
                    _logger.warn(String.format("number of layers in a inersection group exceeds limit: limit=%d, layers=%d", maxLayers, srcBuffers.size()));
                }
                final int nLayers = Math.min(srcBuffers.size(), maxLayers);
                final int[] blendMode = new int[nLayers];
                final float[] opacity = new float[maxLayers];
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, dstBuffer.getTexture());
                int i = 0;
                for (VideoLayerBuffer vlb : srcBuffers) {
                    gl.glActiveTexture(33984 + i + 1);
                    gl.glBindTexture(34037, vlb.getVideoBuffer().getTexture());
                    gl.glActiveTexture(33984 + i + 1 + maxLayers);
                    gl.glBindTexture(34037, vlb.getDepthBuffer().getTexture());
                    blendMode[i] = vlb.getBlendMode().ordinal();
                    opacity[i] = (float)vlb.getOpacity();
                    if (++i >= nLayers) break;
                }
                final IShaderProgram program = VideoRenderSupportImpl.this._shaders.getProgram(BlendModeShaders.getIntersectingBlendSourceFactory(blendMode));
                program.useProgram(new Runnable(){

                    public void run() {
                        gl.glUniform1i(program.getUniformLocation("nLayers"), nLayers);
                        gl.glUniform1i(program.getUniformLocation("texDst"), 0);
                        int i = 0;
                        while (i < maxLayers) {
                            gl.glUniform1i(program.getUniformLocation("texSrc" + i), i + 1);
                            gl.glUniform1i(program.getUniformLocation("texDep" + i), i + 1 + maxLayers);
                            ++i;
                        }
                        i = 0;
                        while (i < nLayers) {
                            gl.glUniform1i(program.getUniformLocation("blendMode" + i), blendMode[i]);
                            ++i;
                        }
                        gl.glUniform1fv(program.getUniformLocation("opacity[0]"), maxLayers, opacity, 0);
                        gl.glUniform1f(program.getUniformLocation("time"), (float)VideoRenderSupportImpl.this._vrContext.getTime().toSecond());
                        gl.glBegin(7);
                        gl.glTexCoord2f(0.0f, 0.0f);
                        gl.glVertex2f(0.0f, 0.0f);
                        gl.glTexCoord2f((float)imageSize.width, 0.0f);
                        gl.glVertex2f((float)imageSize.width, 0.0f);
                        gl.glTexCoord2f((float)imageSize.width, (float)imageSize.height);
                        gl.glVertex2f((float)imageSize.width, (float)imageSize.height);
                        gl.glTexCoord2f(0.0f, (float)imageSize.height);
                        gl.glVertex2f(0.0f, (float)imageSize.height);
                        gl.glEnd();
                    }
                });
                int j = 0;
                int n = maxLayers * 2 + 1;
                while (j < n) {
                    gl.glActiveTexture(33984 + j);
                    gl.glBindTexture(34037, 0);
                    ++j;
                }
                gl.glActiveTexture(33984);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void premultiply(final VideoBuffer vb) {
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                GLU glu = VideoRenderSupportImpl.this._vrContext.getGLU();
                VideoBounds bounds = vb.getBounds();
                VideoRenderSupportImpl.this.ortho2D(gl, glu, bounds.width, bounds.height);
                gl.glFramebufferTexture2D(36160, 36064, 34037, vb.getTexture(), 0);
                gl.glDrawBuffer(36064);
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(0, 772, 0, 1);
                gl.glBegin(7);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glVertex2f((float)bounds.width, 0.0f);
                gl.glVertex2f((float)bounds.width, (float)bounds.height);
                gl.glVertex2f(0.0f, (float)bounds.height);
                gl.glEnd();
                gl.glDisable(3042);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void copy(VideoBuffer src, VideoBuffer dst) {
        final int srcTexture = src.getTexture();
        final VideoBounds srcBounds = src.getBounds();
        final int dstTexture = dst.getTexture();
        final VideoBounds dstBounds = dst.getBounds();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                VideoRenderSupportImpl.this.ortho2D(gl, VideoRenderSupportImpl.this._vrContext.getGLU(), dstBounds.width, dstBounds.height);
                gl.glTranslatef((float)(-dstBounds.x), (float)(-dstBounds.y), 0.0f);
                gl.glFramebufferTexture2D(36160, 36064, 34037, dstTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, srcTexture);
                gl.glEnable(34037);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f((float)srcBounds.x, (float)srcBounds.y);
                gl.glTexCoord2f((float)srcBounds.width, 0.0f);
                gl.glVertex2f((float)(srcBounds.x + (double)srcBounds.width), (float)srcBounds.y);
                gl.glTexCoord2f((float)srcBounds.width, (float)srcBounds.height);
                gl.glVertex2f((float)(srcBounds.x + (double)srcBounds.width), (float)(srcBounds.y + (double)srcBounds.height));
                gl.glTexCoord2f(0.0f, (float)srcBounds.height);
                gl.glVertex2f((float)srcBounds.x, (float)(srcBounds.y + (double)srcBounds.height));
                gl.glEnd();
                gl.glColor4fv(savedColor, 0);
                gl.glBindTexture(34037, 0);
                gl.glDisable(34037);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public <T> T pushMatrixAndExecute(WrappedOperation<T> operation) {
        GL2 gl = this._vrContext.getGL().getGL2();
        int[] viewport = new int[4];
        gl.glGetIntegerv(2978, viewport, 0);
        int[] matrixMode = new int[1];
        gl.glGetIntegerv(2976, matrixMode, 0);
        double[] mvMatrix = new double[16];
        double[] prjMatrix = new double[16];
        this.getMatrix(mvMatrix, prjMatrix);
        try {
            T t = operation.execute();
            return t;
        }
        finally {
            this.setMatrix(mvMatrix, prjMatrix);
            gl.glMatrixMode(matrixMode[0]);
            gl.glViewport(viewport[0], viewport[1], viewport[2], viewport[3]);
        }
    }

    @Override
    public void multModelViewMatrix(Vec3d anchorPoint, Vec3d scale, Vec3d orientation, Vec3d rotate, Vec3d position) {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)position.x, (float)position.y, (float)position.z);
        gl.glRotatef((float)orientation.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)orientation.z, 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)rotate.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)rotate.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)rotate.z, 0.0f, 0.0f, 1.0f);
        gl.glScalef((float)(scale.x / 100.0), (float)(scale.y / 100.0), (float)(scale.z / 100.0));
        gl.glTranslatef((float)(-anchorPoint.x), (float)(-anchorPoint.y), (float)(-anchorPoint.z));
    }

    @Override
    public void multModelViewMatrixInverse(Vec3d anchorPoint, Vec3d scale, Vec3d orientation, Vec3d rotate, Vec3d position) {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)anchorPoint.x, (float)anchorPoint.y, (float)anchorPoint.z);
        gl.glScalef((float)(100.0 / scale.x), (float)(100.0 / scale.y), (float)(100.0 / scale.z));
        gl.glRotatef((float)(-rotate.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-rotate.y), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)(-rotate.x), 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)(-orientation.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-orientation.y), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)(-orientation.x), 1.0f, 0.0f, 0.0f);
        gl.glTranslatef((float)(-position.x), (float)(-position.y), (float)(-position.z));
    }

    @Override
    public void multCameraMatrix(Vec3d orientation, Vec3d rotate, Vec3d position, Vec3d pointOfInterest, boolean flipZ) {
        double dx = pointOfInterest.x - position.x;
        double dy = pointOfInterest.y - position.y;
        double dz = pointOfInterest.z - position.z;
        float _1 = flipZ ? -1 : 1;
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glRotatef((float)(-rotate.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-rotate.y), 0.0f, _1, 0.0f);
        gl.glRotatef((float)(-rotate.x), _1, 0.0f, 0.0f);
        gl.glRotatef((float)(-orientation.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-orientation.y), 0.0f, _1, 0.0f);
        gl.glRotatef((float)(-orientation.x), _1, 0.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))), _1, 0.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(-Math.atan2(dx, dz)), 0.0f, _1, 0.0f);
        gl.glTranslatef((float)(-position.x), (float)(-position.y), (float)(-position.z) * _1);
        if (flipZ) {
            gl.glScalef(1.0f, 1.0f, -1.0f);
        }
    }

    @Override
    public void multCameraMatrixInverse(Vec3d orientation, Vec3d rotate, Vec3d position, Vec3d pointOfInterest) {
        double dx = pointOfInterest.x - position.x;
        double dy = pointOfInterest.y - position.y;
        double dz = pointOfInterest.z - position.z;
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)position.x, (float)position.y, (float)position.z);
        gl.glRotatef((float)Math.toDegrees(Math.atan2(dx, dz)), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(-Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))), 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)orientation.z, 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)rotate.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)rotate.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)rotate.z, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void multModelViewMatrix(double[] mvMatrix) {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glMultMatrixd(mvMatrix, 0);
    }

    @Override
    public void getMatrix(double[] mvMatrix, double[] prjMatrix) {
        GL2 gl = this._vrContext.getGL().getGL2();
        if (mvMatrix != null) {
            gl.glGetDoublev(2982, mvMatrix, 0);
        }
        if (prjMatrix != null) {
            gl.glGetDoublev(2983, prjMatrix, 0);
        }
    }

    @Override
    public void setMatrix(double[] mvMatrix, double[] prjMatrix) {
        GL2 gl = this._vrContext.getGL().getGL2();
        if (prjMatrix != null) {
            gl.glMatrixMode(5889);
            gl.glLoadMatrixd(prjMatrix, 0);
        }
        if (mvMatrix != null) {
            gl.glMatrixMode(5888);
            gl.glLoadMatrixd(mvMatrix, 0);
        }
    }

    @Override
    public void resetMatrix() {
        GL2 gl = this._vrContext.getGL().getGL2();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    @Override
    public Vec3d project(Vec3d point, double[] mvMatrix, double[] prjMatrix, Size2i viewportSize) {
        int[] nArray = new int[4];
        nArray[2] = viewportSize.width;
        nArray[3] = viewportSize.height;
        int[] viewport = nArray;
        double[] result = new double[3];
        this._vrContext.getGLU().gluProject(point.x, point.y, point.z, mvMatrix, 0, prjMatrix, 0, viewport, 0, result, 0);
        return new Vec3d(result[0], result[1], result[2]);
    }

    @Override
    public void transform(VideoBuffer srcBuffer, VideoBuffer resultBuffer, DepthBuffer depthBuffer, final double[] mvMatrix, final double[] prjMatrix) {
        final int srcTexture = srcBuffer.getTexture();
        final Size2i srcImageSize = srcBuffer.getImageSize();
        final int resultTexture = resultBuffer.getTexture();
        final Size2i resultImageSize = resultBuffer.getImageSize();
        final int depthTexture = depthBuffer != null ? depthBuffer.getTexture() : 0;
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                gl.glViewport(0, 0, resultImageSize.width, resultImageSize.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(prjMatrix, 0);
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, srcTexture);
                gl.glEnable(34037);
                if (depthTexture != 0) {
                    gl.glFramebufferTexture2D(36160, 36096, 34037, depthTexture, 0);
                    gl.glEnable(2929);
                    gl.glClearDepth(1.0);
                    gl.glClear(256);
                }
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f((float)srcImageSize.width, 0.0f);
                gl.glVertex2f((float)srcImageSize.width, 0.0f);
                gl.glTexCoord2f((float)srcImageSize.width, (float)srcImageSize.height);
                gl.glVertex2f((float)srcImageSize.width, (float)srcImageSize.height);
                gl.glTexCoord2f(0.0f, (float)srcImageSize.height);
                gl.glVertex2f(0.0f, (float)srcImageSize.height);
                gl.glEnd();
                gl.glColor4fv(savedColor, 0);
                if (depthTexture != 0) {
                    gl.glDisable(2929);
                    gl.glFramebufferTexture2D(36160, 36096, 34037, 0, 0);
                }
                gl.glBindTexture(34037, 0);
                gl.glDisable(34037);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void scaleAndFlipVertical(VideoBuffer srcBuffer, VideoBuffer resultBuffer, final double scale) {
        final int srcTexture = srcBuffer.getTexture();
        final Size2i srcImageSize = srcBuffer.getImageSize();
        final int resultTexture = resultBuffer.getTexture();
        final Size2i resultImageSize = resultBuffer.getImageSize();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                GLU glu = VideoRenderSupportImpl.this._vrContext.getGLU();
                gl.glViewport(0, 0, resultImageSize.width, resultImageSize.height);
                gl.glMatrixMode(5889);
                gl.glLoadIdentity();
                glu.gluOrtho2D(0.0f, (float)resultImageSize.width, (float)resultImageSize.height, 0.0f);
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glScalef((float)scale, (float)scale, 1.0f);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(34037, srcTexture);
                gl.glEnable(34037);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f((float)srcImageSize.width, 0.0f);
                gl.glVertex2f((float)srcImageSize.width, 0.0f);
                gl.glTexCoord2f((float)srcImageSize.width, (float)srcImageSize.height);
                gl.glVertex2f((float)srcImageSize.width, (float)srcImageSize.height);
                gl.glTexCoord2f(0.0f, (float)srcImageSize.height);
                gl.glVertex2f(0.0f, (float)srcImageSize.height);
                gl.glEnd();
                gl.glColor4fv(savedColor, 0);
                gl.glBindTexture(34037, 0);
                gl.glDisable(34037);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void fillDepth(VideoBuffer tmpBuffer, DepthBuffer depthBuffer, final double[] mvMatrix, final double[] prjMatrix) {
        Size2i size = depthBuffer.getImageSize();
        final int w = size.width;
        final int h = size.height;
        int[] nArray = new int[4];
        nArray[2] = w;
        nArray[3] = h;
        int[] viewport = nArray;
        double[][] unprj = new double[8][3];
        GLU glu = this._vrContext.getGLU();
        glu.gluUnProject(0.0, 0.0, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[0], 0);
        glu.gluUnProject(0.0, 0.0, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[1], 0);
        glu.gluUnProject((double)w, 0.0, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[2], 0);
        glu.gluUnProject((double)w, 0.0, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[3], 0);
        glu.gluUnProject((double)w, (double)h, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[4], 0);
        glu.gluUnProject((double)w, (double)h, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[5], 0);
        glu.gluUnProject(0.0, (double)h, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[6], 0);
        glu.gluUnProject(0.0, (double)h, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[7], 0);
        Point3d[] frustumVertices = new Point3d[8];
        int i = 0;
        while (i < 8) {
            frustumVertices[i] = new Point3d(unprj[i]);
            ++i;
        }
        Point3d[][] frustumEdges = new Point3d[12][2];
        int i2 = 0;
        while (i2 < 12) {
            frustumEdges[i2][0] = frustumVertices[_frustumEdgeTable[i2][0]];
            frustumEdges[i2][1] = frustumVertices[_frustumEdgeTable[i2][1]];
            ++i2;
        }
        final LinkedHashSet<Point2d> set = Util.newLinkedHashSet();
        Vector3d v = new Vector3d();
        int i3 = 0;
        while (i3 < 12) {
            boolean y;
            Point3d p0 = frustumEdges[i3][0];
            Point3d p1 = frustumEdges[i3][1];
            v.sub((Tuple3d)p1, (Tuple3d)p0);
            Point2d p = new Point2d(p0.x - v.x / v.z * p0.z, p0.y - v.y / v.z * p0.z);
            boolean x = p0.x <= p.x && p.x <= p1.x || p1.x <= p.x && p.x <= p0.x;
            boolean bl = y = p0.y <= p.y && p.y <= p1.y || p1.y <= p.y && p.y <= p0.y;
            if (!x || !y) {
                ++i3;
                continue;
            }
            set.add(p);
            block3: while (true) {
                int j = 0;
                while (j < 6) {
                    int k = _frustumClipSearchTable[i3][j];
                    p0 = frustumEdges[k][0];
                    p1 = frustumEdges[k][1];
                    v.sub((Tuple3d)p1, (Tuple3d)p0);
                    p = new Point2d(p0.x - v.x / v.z * p0.z, p0.y - v.y / v.z * p0.z);
                    x = p0.x <= p.x && p.x <= p1.x || p1.x <= p.x && p.x <= p0.x;
                    boolean bl2 = y = p0.y <= p.y && p.y <= p1.y || p1.y <= p.y && p.y <= p0.y;
                    if (x && y && !set.contains(p)) {
                        set.add(p);
                        i3 = k;
                        continue block3;
                    }
                    ++j;
                }
                break block2;
                break;
            }
        }
        final int tmpTexture = tmpBuffer.getTexture();
        final int depthTexture = depthBuffer.getTexture();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                gl.glViewport(0, 0, w, h);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(prjMatrix, 0);
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, tmpTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glFramebufferTexture2D(36160, 36096, 34037, depthTexture, 0);
                gl.glEnable(2929);
                gl.glClearDepth(1.0);
                gl.glClear(256);
                if (set.size() >= 3) {
                    gl.glBegin(9);
                    for (Point2d pt : set) {
                        gl.glVertex2d(pt.x, pt.y);
                    }
                    gl.glEnd();
                }
                gl.glDisable(2929);
                gl.glFramebufferTexture2D(36160, 36096, 34037, 0, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void renderText(final FTGLfont font, final Color fillColor, final String[] texts, final double[][] offsets, VideoBuffer resultBuffer) {
        final VideoBounds resultBounds = resultBuffer.getBounds();
        if (resultBounds.isEmpty()) {
            return;
        }
        final int resultTexture = resultBuffer.getTexture();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                GLU glu = VideoRenderSupportImpl.this._vrContext.getGLU();
                float scale = (float)((VideoRenderSupportImpl)VideoRenderSupportImpl.this)._vrContext.getRenderResolution().scale;
                VideoRenderSupportImpl.this.ortho2D(gl, glu, resultBounds.width, resultBounds.height);
                gl.glTranslatef((float)(-resultBounds.x), (float)(-resultBounds.y), 0.0f);
                double[] mvMatrix = new double[16];
                VideoRenderSupportImpl.this.getMatrix(mvMatrix, null);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                gl.glColor4f((float)fillColor.r, (float)fillColor.g, (float)fillColor.b, (float)fillColor.a);
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(770, 771, 1, 771);
                int i = 0;
                while (i < texts.length) {
                    VideoRenderSupportImpl.this.setMatrix(mvMatrix, null);
                    gl.glTranslatef((float)offsets[i][0], (float)offsets[i][1], 0.0f);
                    gl.glScalef(scale, -scale, scale);
                    FTGL.ftglRenderFont((FTGLfont)font, (String)texts[i], (int)65535);
                    ++i;
                }
                gl.glDisable(3042);
                gl.glColor4fv(savedColor, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void renderText(final FTGLfont font, final Color fillColor, final String[] texts, final double[][] offsets, VideoBuffer resultBuffer, final double[] mvMatrix, final double[] prjMatrix) {
        final int resultTexture = resultBuffer.getTexture();
        final Size2i resultImageSize = resultBuffer.getImageSize();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImpl.this._vrContext.getGL().getGL2();
                final float scale = (float)((VideoRenderSupportImpl)VideoRenderSupportImpl.this)._vrContext.getRenderResolution().scale;
                gl.glViewport(0, 0, resultImageSize.width, resultImageSize.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(prjMatrix, 0);
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                final double[] mvMatrix2 = new double[16];
                VideoRenderSupportImpl.this.getMatrix(mvMatrix2, null);
                gl.glFramebufferTexture2D(36160, 36064, 34037, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                float a = (float)fillColor.a;
                float r = (float)fillColor.r * a;
                float g = (float)fillColor.g * a;
                float b = (float)fillColor.b * a;
                gl.glColor4f(r, g, b, a);
                VideoRenderSupportImpl.this._aaSupport.antiAlias(resultImageSize.width, resultImageSize.height, new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < texts.length) {
                            VideoRenderSupportImpl.this.setMatrix(mvMatrix2, null);
                            gl.glTranslatef((float)offsets[i][0], (float)offsets[i][1], 0.0f);
                            gl.glScalef(scale, -scale, scale);
                            FTGL.ftglRenderFont((FTGLfont)font, (String)texts[i], (int)65535);
                            ++i;
                        }
                    }
                });
                gl.glColor4fv(savedColor, 0);
                gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                return null;
            }
        });
    }
}

