/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.output;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.misc.AtiIntelLock;
import ch.kuramo.javie.core.output.ProgressMonitor;
import ch.kuramo.javie.core.services.AudioRenderContext;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PullSourceOutput {
    private static final Logger _logger = LoggerFactory.getLogger(PullSourceOutput.class);
    private static final VideoRequest END_VIDEO = new VideoRequest(null);
    private static final AudioRequest END_AUDIO = new AudioRequest(null, 0);
    private ProgressMonitor _progressMonitor;
    private final BlockingQueue<VideoRequest> _videoRequestQueue = new ArrayBlockingQueue<VideoRequest>(1);
    private final BlockingQueue<Object> _videoResponseQueue = new ArrayBlockingQueue<Object>(1);
    private final BlockingQueue<AudioRequest> _audioRequestQueue = new ArrayBlockingQueue<AudioRequest>(1);
    private final BlockingQueue<Object> _audioResponseQueue = new ArrayBlockingQueue<Object>(1);
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderContext _arContext;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private GLGlobal _glGlobal;

    public void doOutput(final Composition comp, final AudioMode audioMode, File file, ProgressMonitor progMon) {
        Thread videoThread = new Thread(new Runnable(){

            public void run() {
                PullSourceOutput.this.videoLoop(comp);
            }
        });
        videoThread.start();
        Thread audioThread = new Thread(new Runnable(){

            public void run() {
                PullSourceOutput.this.audioLoop(comp, audioMode);
            }
        });
        audioThread.start();
        this._progressMonitor = progMon != null ? progMon : ProgressMonitor.NULL;
        this.doOutput(comp, audioMode, file);
        try {
            this._videoRequestQueue.put(END_VIDEO);
        }
        catch (InterruptedException e) {
            _logger.warn("unexpected interruption", (Throwable)e);
        }
        try {
            this._audioRequestQueue.put(END_AUDIO);
        }
        catch (InterruptedException e) {
            _logger.warn("unexpected interruption", (Throwable)e);
        }
    }

    protected abstract void doOutput(Composition var1, AudioMode var2, File var3);

    /*
     * Unable to fully structure code
     */
    protected void videoLoop(Composition comp) {
        block13: {
            atiIntelLock = AtiIntelLock.get(this._glGlobal);
            this._vrContext.activate();
            comp.prepareExpression(this._vrContext.createInitialExpressionScope(comp));
            while (true) lbl-1000:
            // 5 sources

            {
                vb = null;
                try {
                    request = this._videoRequestQueue.take();
                    time = request.time;
                    if (time == null) break block13;
                    try {
                        this._vrContext.reset();
                        this._vrContext.setRenderResolution(RenderResolution.FULL);
                        this._vrContext.setTime(time);
                        atiIntelLock.lock();
                        try {
                            vb = comp.renderVideoFrame();
                            this._vrSupport.premultiply(vb);
                            this.finishVideoRequest(request, vb);
                            this._videoResponseQueue.put(this);
                        }
                        finally {
                            atiIntelLock.unlock();
                        }
                    }
                    catch (InterruptedException e) {
                        PullSourceOutput._logger.warn("unexpected interruption", (Throwable)e);
                    }
                }
                finally {
                    if (vb == null) continue;
                    vb.dispose();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                this._vrContext.deactivate();
            }
        }
    }

    protected void postVideoRequest(VideoRequest request) throws InterruptedException {
        this._videoRequestQueue.put(request);
        this._videoResponseQueue.take();
    }

    protected abstract void finishVideoRequest(VideoRequest var1, VideoBuffer var2);

    /*
     * Unable to fully structure code
     */
    protected void audioLoop(Composition comp, AudioMode audioMode) {
        block11: {
            totalFrames = comp.getDuration().toFrameNumber(audioMode.sampleDuration);
            this._arContext.activate();
            comp.prepareExpression(this._arContext.createInitialExpressionScope(comp));
            while (true) lbl-1000:
            // 4 sources

            {
                ab = null;
                try {
                    request = this._audioRequestQueue.take();
                    time = request.time;
                    if (time == null) break block11;
                    try {
                        this._arContext.reset();
                        this._arContext.setAudioMode(audioMode);
                        this._arContext.setTime(time);
                        this._arContext.setFrameCount((int)Math.min((long)request.frameCount, totalFrames - time.timeValue));
                        this._arContext.setEvaluationResolution(audioMode.sampleRate / 100);
                        ab = comp.renderAudioChunk();
                        if (ab == null) {
                            ab = this.createAudioBufferClear();
                        }
                        this.finishAudioRequest(request, ab);
                        this._audioResponseQueue.put(this);
                    }
                    catch (InterruptedException e) {
                        PullSourceOutput._logger.warn("unexpected interruption", (Throwable)e);
                    }
                }
                finally {
                    if (ab == null) continue;
                    ab.dispose();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                this._arContext.deactivate();
            }
        }
    }

    protected void postAudioRequest(AudioRequest request) throws InterruptedException {
        this._audioRequestQueue.put(request);
        this._audioResponseQueue.take();
    }

    protected abstract void finishAudioRequest(AudioRequest var1, AudioBuffer var2);

    private AudioBuffer createAudioBufferClear() {
        AudioBuffer ab = this._arSupport.createAudioBuffer();
        switch (ab.getAudioMode().dataType) {
            case SHORT: {
                Arrays.fill((short[])ab.getData(), 0, ab.getDataLength(), (short)0);
                break;
            }
            case INT: {
                Arrays.fill((int[])ab.getData(), 0, ab.getDataLength(), 0);
                break;
            }
            case FLOAT: {
                Arrays.fill((float[])ab.getData(), 0, ab.getDataLength(), 0.0f);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + ab.getAudioMode().dataType);
            }
        }
        return ab;
    }

    protected void beginTask(int totalWork) {
        this._progressMonitor.beginTask(totalWork);
    }

    protected void currentWork(int currentWork) {
        this._progressMonitor.currentWork(currentWork);
    }

    protected void done() {
        this._progressMonitor.done();
    }

    protected boolean isCanceled() {
        return this._progressMonitor.isCanceled();
    }

    protected static class AudioRequest {
        protected final Time time;
        protected final int frameCount;

        protected AudioRequest(Time time, int frameCount) {
            this.time = time;
            this.frameCount = frameCount;
        }
    }

    protected static class VideoRequest {
        protected final Time time;

        protected VideoRequest(Time time) {
            this.time = time;
        }
    }
}

