/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.runtime;

import com.sun.gluegen.runtime.PointerBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class BufferFactory {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;
    private static final boolean isLittleEndian;

    public static boolean isLittleEndian() {
        return isLittleEndian;
    }

    public static ByteBuffer newDirectByteBuffer(int n) {
        return BufferFactory.nativeOrder(ByteBuffer.allocateDirect(n));
    }

    public static ByteBuffer nativeOrder(ByteBuffer byteBuffer) {
        return byteBuffer.order(ByteOrder.nativeOrder());
    }

    public static boolean isDirect(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof ByteBuffer) {
            return ((ByteBuffer)object).isDirect();
        }
        if (object instanceof FloatBuffer) {
            return ((FloatBuffer)object).isDirect();
        }
        if (object instanceof DoubleBuffer) {
            return ((DoubleBuffer)object).isDirect();
        }
        if (object instanceof CharBuffer) {
            return ((CharBuffer)object).isDirect();
        }
        if (object instanceof ShortBuffer) {
            return ((ShortBuffer)object).isDirect();
        }
        if (object instanceof IntBuffer) {
            return ((IntBuffer)object).isDirect();
        }
        if (object instanceof LongBuffer) {
            return ((LongBuffer)object).isDirect();
        }
        if (object instanceof PointerBuffer) {
            return ((PointerBuffer)object).isDirect();
        }
        throw new RuntimeException("Unexpected buffer type " + object.getClass().getName());
    }

    public static int getDirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return n;
            }
            if (object instanceof FloatBuffer) {
                return n * 4;
            }
            if (object instanceof IntBuffer) {
                return n * 4;
            }
            if (object instanceof ShortBuffer) {
                return n * 2;
            }
            if (object instanceof DoubleBuffer) {
                return n * 8;
            }
            if (object instanceof LongBuffer) {
                return n * 8;
            }
            if (object instanceof CharBuffer) {
                return n * 2;
            }
        } else if (object instanceof PointerBuffer) {
            return ((PointerBuffer)object).position() * 8;
        }
        throw new RuntimeException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static Object getArray(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ByteBuffer) {
            return ((ByteBuffer)object).array();
        }
        if (object instanceof FloatBuffer) {
            return ((FloatBuffer)object).array();
        }
        if (object instanceof IntBuffer) {
            return ((IntBuffer)object).array();
        }
        if (object instanceof ShortBuffer) {
            return ((ShortBuffer)object).array();
        }
        if (object instanceof DoubleBuffer) {
            return ((DoubleBuffer)object).array();
        }
        if (object instanceof LongBuffer) {
            return ((LongBuffer)object).array();
        }
        if (object instanceof CharBuffer) {
            return ((CharBuffer)object).array();
        }
        if (object instanceof PointerBuffer) {
            return ((PointerBuffer)object).array();
        }
        throw new RuntimeException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static int getIndirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return ((ByteBuffer)object).arrayOffset() + n;
            }
            if (object instanceof FloatBuffer) {
                return 4 * (((FloatBuffer)object).arrayOffset() + n);
            }
            if (object instanceof IntBuffer) {
                return 4 * (((IntBuffer)object).arrayOffset() + n);
            }
            if (object instanceof ShortBuffer) {
                return 2 * (((ShortBuffer)object).arrayOffset() + n);
            }
            if (object instanceof DoubleBuffer) {
                return 8 * (((DoubleBuffer)object).arrayOffset() + n);
            }
            if (object instanceof LongBuffer) {
                return 8 * (((LongBuffer)object).arrayOffset() + n);
            }
            if (object instanceof CharBuffer) {
                return 2 * (((CharBuffer)object).arrayOffset() + n);
            }
        } else if (object instanceof PointerBuffer) {
            return 8 * (((PointerBuffer)object).arrayOffset() + ((PointerBuffer)object).position());
        }
        throw new RuntimeException("Unknown buffer type " + object.getClass().getName());
    }

    public static void rangeCheck(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return;
        }
        if (byArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (byArray.length - n));
        }
    }

    public static void rangeCheck(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return;
        }
        if (cArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (cArray.length - n));
        }
    }

    public static void rangeCheck(short[] sArray, int n, int n2) {
        if (sArray == null) {
            return;
        }
        if (sArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (sArray.length - n));
        }
    }

    public static void rangeCheck(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return;
        }
        if (nArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (nArray.length - n));
        }
    }

    public static void rangeCheck(long[] lArray, int n, int n2) {
        if (lArray == null) {
            return;
        }
        if (lArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (lArray.length - n));
        }
    }

    public static void rangeCheck(float[] fArray, int n, int n2) {
        if (fArray == null) {
            return;
        }
        if (fArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (fArray.length - n));
        }
    }

    public static void rangeCheck(double[] dArray, int n, int n2) {
        if (dArray == null) {
            return;
        }
        if (dArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (dArray.length - n));
        }
    }

    public static void rangeCheck(Buffer buffer, int n) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining elements in buffer, only had " + buffer.remaining());
        }
    }

    public static void rangeCheckBytes(Object object, int n) {
        if (object == null) {
            return;
        }
        int n2 = 0;
        if (object instanceof Buffer) {
            int n3 = ((Buffer)object).remaining();
            if (object instanceof ByteBuffer) {
                n2 = n3;
            } else if (object instanceof FloatBuffer) {
                n2 = n3 * 4;
            } else if (object instanceof IntBuffer) {
                n2 = n3 * 4;
            } else if (object instanceof ShortBuffer) {
                n2 = n3 * 2;
            } else if (object instanceof DoubleBuffer) {
                n2 = n3 * 8;
            } else if (object instanceof LongBuffer) {
                n2 = n3 * 8;
            } else if (object instanceof CharBuffer) {
                n2 = n3 * 2;
            }
        } else if (object instanceof PointerBuffer) {
            n2 = ((PointerBuffer)object).remaining() * 8;
        }
        if (n2 < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining bytes in buffer, only had " + n2);
        }
    }

    static {
        ByteBuffer byteBuffer = BufferFactory.newDirectByteBuffer(4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        intBuffer.put(0, 168496141);
        isLittleEndian = 3085 == shortBuffer.get(0);
    }
}

