/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableImpl;
import java.nio.Buffer;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public abstract class GLDrawableFactoryImpl
extends GLDrawableFactory {
    protected static final boolean DEBUG = Debug.debug("GLDrawableFactory");
    private boolean gammaShutdownHookRegistered;
    private Thread gammaShutdownHook;
    private Buffer originalGammaRamp;

    public abstract GLDrawableImpl createOffscreenDrawable(GLCapabilities var1, GLCapabilitiesChooser var2, int var3, int var4);

    protected GLDrawableFactoryImpl() {
    }

    public static GLDrawableFactoryImpl getFactoryImpl(GLProfile gLProfile) {
        return (GLDrawableFactoryImpl)GLDrawableFactoryImpl.getFactory(gLProfile);
    }

    public abstract void loadGLULibrary();

    public void lockToolkit() {
        NativeWindowFactory.getDefaultFactory().getToolkitLock().lock();
    }

    public void unlockToolkit() {
        NativeWindowFactory.getDefaultFactory().getToolkitLock().unlock();
    }

    public abstract boolean canCreateContextOnJava2DSurface();

    public abstract GLContext createContextOnJava2DSurface(Object var1, GLContext var2) throws GLException;

    public boolean setDisplayGamma(float f, float f2, float f3) throws IllegalArgumentException {
        if (f2 < -1.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Brightness must be between -1.0 and 1.0");
        }
        if (f3 < 0.0f) {
            throw new IllegalArgumentException("Contrast must be greater than 0.0");
        }
        int n = this.getGammaRampLength();
        if (n == 0) {
            return false;
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            float f4 = (float)i / (float)(n - 1);
            float f5 = (float)Math.pow(f4, f);
            f5 += f2;
            if ((f5 = (f5 - 0.5f) * f3 + 0.5f) > 1.0f) {
                f5 = 1.0f;
            } else if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            fArray[i] = f5;
        }
        this.registerGammaShutdownHook();
        return this.setGammaRamp(fArray);
    }

    public synchronized void resetDisplayGamma() {
        if (this.gammaShutdownHook == null) {
            throw new IllegalArgumentException("Should not call this unless setDisplayGamma called first");
        }
        this.resetGammaRamp(this.originalGammaRamp);
        this.unregisterGammeShutdownHook();
    }

    protected int getGammaRampLength() {
        return 0;
    }

    protected boolean setGammaRamp(float[] fArray) {
        return false;
    }

    protected Buffer getGammaRamp() {
        return null;
    }

    protected void resetGammaRamp(Buffer buffer) {
    }

    private synchronized void registerGammaShutdownHook() {
        if (this.gammaShutdownHookRegistered) {
            return;
        }
        if (this.gammaShutdownHook == null) {
            this.gammaShutdownHook = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    GLDrawableFactoryImpl gLDrawableFactoryImpl = GLDrawableFactoryImpl.this;
                    synchronized (gLDrawableFactoryImpl) {
                        GLDrawableFactoryImpl.this.resetGammaRamp(GLDrawableFactoryImpl.this.originalGammaRamp);
                    }
                }
            });
            this.originalGammaRamp = this.getGammaRamp();
        }
        Runtime.getRuntime().addShutdownHook(this.gammaShutdownHook);
        this.gammaShutdownHookRegistered = true;
    }

    private synchronized void unregisterGammeShutdownHook() {
        if (!this.gammaShutdownHookRegistered) {
            return;
        }
        if (this.gammaShutdownHook == null) {
            throw new InternalError("Error in gamma shutdown hook logic");
        }
        Runtime.getRuntime().removeShutdownHook(this.gammaShutdownHook);
        this.gammaShutdownHookRegistered = false;
    }
}

