/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.gl2;

import com.sun.opengl.impl.InternalBufferUtil;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL2;

public class ProjectDouble {
    private static final double[] IDENTITY_MATRIX = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    private final double[] matrix = new double[16];
    private final double[][] tempMatrix = new double[4][4];
    private final double[] in = new double[4];
    private final double[] out = new double[4];
    private final double[] forward = new double[3];
    private final double[] side = new double[3];
    private final double[] up = new double[3];
    private DoubleBuffer locbuf;
    private final DoubleBuffer matrixBuf;
    private final DoubleBuffer tempMatrixBuf;
    private final DoubleBuffer inBuf;
    private final DoubleBuffer outBuf;
    private final DoubleBuffer forwardBuf;
    private final DoubleBuffer sideBuf;
    private final DoubleBuffer upBuf;

    public ProjectDouble() {
        DoubleBuffer doubleBuffer = InternalBufferUtil.newDoubleBuffer(128);
        int n = 0;
        int n2 = 16;
        this.matrixBuf = ProjectDouble.slice(doubleBuffer, n, n2);
        this.tempMatrixBuf = ProjectDouble.slice(doubleBuffer, n += n2, n2);
        n += n2;
        n2 = 4;
        this.inBuf = ProjectDouble.slice(doubleBuffer, n, n2);
        this.outBuf = ProjectDouble.slice(doubleBuffer, n += n2, n2);
        n += n2;
        n2 = 3;
        this.forwardBuf = ProjectDouble.slice(doubleBuffer, n, n2);
        this.sideBuf = ProjectDouble.slice(doubleBuffer, n += n2, n2);
        this.upBuf = ProjectDouble.slice(doubleBuffer, n += n2, n2);
    }

    public void destroy() {
        if (this.locbuf != null) {
            this.locbuf.clear();
            this.locbuf = null;
        }
    }

    private static DoubleBuffer slice(DoubleBuffer doubleBuffer, int n, int n2) {
        doubleBuffer.position(n);
        doubleBuffer.limit(n + n2);
        return doubleBuffer.slice();
    }

    private void __gluMakeIdentityd(DoubleBuffer doubleBuffer) {
        int n = doubleBuffer.position();
        doubleBuffer.put(IDENTITY_MATRIX);
        doubleBuffer.position(n);
    }

    private void __gluMakeIdentityd(double[] dArray) {
        for (int i = 0; i < 16; ++i) {
            dArray[i] = IDENTITY_MATRIX[i];
        }
    }

    private void __gluMultMatrixVecd(double[] dArray, int n, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < 4; ++i) {
            dArray3[i] = dArray2[0] * dArray[0 + i + n] + dArray2[1] * dArray[4 + i + n] + dArray2[2] * dArray[8 + i + n] + dArray2[3] * dArray[12 + i + n];
        }
    }

    private void __gluMultMatrixVecd(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, DoubleBuffer doubleBuffer3) {
        int n = doubleBuffer2.position();
        int n2 = doubleBuffer3.position();
        int n3 = doubleBuffer.position();
        for (int i = 0; i < 4; ++i) {
            doubleBuffer3.put(i + n2, doubleBuffer2.get(0 + n) * doubleBuffer.get(0 + i + n3) + doubleBuffer2.get(1 + n) * doubleBuffer.get(4 + i + n3) + doubleBuffer2.get(2 + n) * doubleBuffer.get(8 + i + n3) + doubleBuffer2.get(3 + n) * doubleBuffer.get(12 + i + n3));
        }
    }

    private boolean __gluInvertMatrixd(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        double[][] dArray3 = this.tempMatrix;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                dArray3[n2][n] = dArray[n2 * 4 + n];
            }
        }
        this.__gluMakeIdentityd(dArray2);
        for (n2 = 0; n2 < 4; ++n2) {
            double d;
            int n3;
            int n4 = n2;
            for (n = n2 + 1; n < 4; ++n) {
                if (!(Math.abs(dArray3[n][n2]) > Math.abs(dArray3[n2][n2]))) continue;
                n4 = n;
            }
            if (n4 != n2) {
                for (n3 = 0; n3 < 4; ++n3) {
                    d = dArray3[n2][n3];
                    dArray3[n2][n3] = dArray3[n4][n3];
                    dArray3[n4][n3] = d;
                    d = dArray2[n2 * 4 + n3];
                    dArray2[n2 * 4 + n3] = dArray2[n4 * 4 + n3];
                    dArray2[n4 * 4 + n3] = d;
                }
            }
            if (dArray3[n2][n2] == 0.0) {
                return false;
            }
            d = dArray3[n2][n2];
            for (n3 = 0; n3 < 4; ++n3) {
                double[] dArray4 = dArray3[n2];
                int n5 = n3;
                dArray4[n5] = dArray4[n5] / d;
                int n6 = n2 * 4 + n3;
                dArray2[n6] = dArray2[n6] / d;
            }
            for (n = 0; n < 4; ++n) {
                if (n == n2) continue;
                d = dArray3[n][n2];
                for (n3 = 0; n3 < 4; ++n3) {
                    double[] dArray5 = dArray3[n];
                    int n7 = n3;
                    dArray5[n7] = dArray5[n7] - dArray3[n2][n3] * d;
                    int n8 = n * 4 + n3;
                    dArray2[n8] = dArray2[n8] - dArray2[n2 * 4 + n3] * d;
                }
            }
        }
        return true;
    }

    private boolean __gluInvertMatrixd(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        int n;
        int n2;
        int n3 = doubleBuffer.position();
        int n4 = doubleBuffer2.position();
        DoubleBuffer doubleBuffer3 = this.tempMatrixBuf;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                doubleBuffer3.put(n2 * 4 + n, doubleBuffer.get(n2 * 4 + n + n3));
            }
        }
        this.__gluMakeIdentityd(doubleBuffer2);
        for (n2 = 0; n2 < 4; ++n2) {
            double d;
            int n5;
            int n6 = n2;
            for (n = n2 + 1; n < 4; ++n) {
                if (!(Math.abs(doubleBuffer3.get(n * 4 + n2)) > Math.abs(doubleBuffer3.get(n2 * 4 + n2)))) continue;
                n6 = n;
            }
            if (n6 != n2) {
                for (n5 = 0; n5 < 4; ++n5) {
                    d = doubleBuffer3.get(n2 * 4 + n5);
                    doubleBuffer3.put(n2 * 4 + n5, doubleBuffer3.get(n6 * 4 + n5));
                    doubleBuffer3.put(n6 * 4 + n5, d);
                    d = doubleBuffer2.get(n2 * 4 + n5 + n4);
                    doubleBuffer2.put(n2 * 4 + n5 + n4, doubleBuffer2.get(n6 * 4 + n5 + n4));
                    doubleBuffer2.put(n6 * 4 + n5 + n4, d);
                }
            }
            if (doubleBuffer3.get(n2 * 4 + n2) == 0.0) {
                return false;
            }
            d = doubleBuffer3.get(n2 * 4 + n2);
            for (n5 = 0; n5 < 4; ++n5) {
                doubleBuffer3.put(n2 * 4 + n5, doubleBuffer3.get(n2 * 4 + n5) / d);
                doubleBuffer2.put(n2 * 4 + n5 + n4, doubleBuffer2.get(n2 * 4 + n5 + n4) / d);
            }
            for (n = 0; n < 4; ++n) {
                if (n == n2) continue;
                d = doubleBuffer3.get(n * 4 + n2);
                for (n5 = 0; n5 < 4; ++n5) {
                    doubleBuffer3.put(n * 4 + n5, doubleBuffer3.get(n * 4 + n5) - doubleBuffer3.get(n2 * 4 + n5) * d);
                    doubleBuffer2.put(n * 4 + n5 + n4, doubleBuffer2.get(n * 4 + n5 + n4) - doubleBuffer2.get(n2 * 4 + n5 + n4) * d);
                }
            }
        }
        return true;
    }

    private void __gluMultMatricesd(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray3[i * 4 + j] = dArray[i * 4 + 0 + n] * dArray2[0 + j + n2] + dArray[i * 4 + 1 + n] * dArray2[4 + j + n2] + dArray[i * 4 + 2 + n] * dArray2[8 + j + n2] + dArray[i * 4 + 3 + n] * dArray2[12 + j + n2];
            }
        }
    }

    private void __gluMultMatricesd(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, DoubleBuffer doubleBuffer3) {
        int n = doubleBuffer.position();
        int n2 = doubleBuffer2.position();
        int n3 = doubleBuffer3.position();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                doubleBuffer3.put(i * 4 + j + n3, doubleBuffer.get(i * 4 + 0 + n) * doubleBuffer2.get(0 + j + n2) + doubleBuffer.get(i * 4 + 1 + n) * doubleBuffer2.get(4 + j + n2) + doubleBuffer.get(i * 4 + 2 + n) * doubleBuffer2.get(8 + j + n2) + doubleBuffer.get(i * 4 + 3 + n) * doubleBuffer2.get(12 + j + n2));
            }
        }
    }

    private static void normalize(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        if (d == 0.0) {
            return;
        }
        d = 1.0 / d;
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        dArray[2] = dArray[2] * d;
    }

    private static void normalize(DoubleBuffer doubleBuffer) {
        int n = doubleBuffer.position();
        double d = Math.sqrt(doubleBuffer.get(0 + n) * doubleBuffer.get(0 + n) + doubleBuffer.get(1 + n) * doubleBuffer.get(1 + n) + doubleBuffer.get(2 + n) * doubleBuffer.get(2 + n));
        if (d == 0.0) {
            return;
        }
        d = 1.0 / d;
        doubleBuffer.put(0 + n, doubleBuffer.get(0 + n) * d);
        doubleBuffer.put(1 + n, doubleBuffer.get(1 + n) * d);
        doubleBuffer.put(2 + n, doubleBuffer.get(2 + n) * d);
    }

    private static void cross(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[1] * dArray2[2] - dArray[2] * dArray2[1];
        dArray3[1] = dArray[2] * dArray2[0] - dArray[0] * dArray2[2];
        dArray3[2] = dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
    }

    private static void cross(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, DoubleBuffer doubleBuffer3) {
        int n = doubleBuffer.position();
        int n2 = doubleBuffer2.position();
        int n3 = doubleBuffer3.position();
        doubleBuffer3.put(0 + n3, doubleBuffer.get(1 + n) * doubleBuffer2.get(2 + n2) - doubleBuffer.get(2 + n) * doubleBuffer2.get(1 + n2));
        doubleBuffer3.put(1 + n3, doubleBuffer.get(2 + n) * doubleBuffer2.get(0 + n2) - doubleBuffer.get(0 + n) * doubleBuffer2.get(2 + n2));
        doubleBuffer3.put(2 + n3, doubleBuffer.get(0 + n) * doubleBuffer2.get(1 + n2) - doubleBuffer.get(1 + n) * doubleBuffer2.get(0 + n2));
    }

    public void gluOrtho2D(GL2 gL2, double d, double d2, double d3, double d4) {
        gL2.glOrtho(d, d2, d3, d4, -1.0, 1.0);
    }

    public void gluPerspective(GL2 gL2, double d, double d2, double d3, double d4) {
        double d5 = d / 2.0 * Math.PI / 180.0;
        double d6 = d4 - d3;
        double d7 = Math.sin(d5);
        if (d6 == 0.0 || d7 == 0.0 || d2 == 0.0) {
            return;
        }
        double d8 = Math.cos(d5) / d7;
        this.__gluMakeIdentityd(this.matrixBuf);
        this.matrixBuf.put(0, d8 / d2);
        this.matrixBuf.put(5, d8);
        this.matrixBuf.put(10, -(d4 + d3) / d6);
        this.matrixBuf.put(11, -1.0);
        this.matrixBuf.put(14, -2.0 * d3 * d4 / d6);
        this.matrixBuf.put(15, 0.0);
        gL2.glMultMatrixd(this.matrixBuf);
    }

    public void gluLookAt(GL2 gL2, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        DoubleBuffer doubleBuffer = this.forwardBuf;
        DoubleBuffer doubleBuffer2 = this.sideBuf;
        DoubleBuffer doubleBuffer3 = this.upBuf;
        doubleBuffer.put(0, d4 - d);
        doubleBuffer.put(1, d5 - d2);
        doubleBuffer.put(2, d6 - d3);
        doubleBuffer3.put(0, d7);
        doubleBuffer3.put(1, d8);
        doubleBuffer3.put(2, d9);
        ProjectDouble.normalize(doubleBuffer);
        ProjectDouble.cross(doubleBuffer, doubleBuffer3, doubleBuffer2);
        ProjectDouble.normalize(doubleBuffer2);
        ProjectDouble.cross(doubleBuffer2, doubleBuffer, doubleBuffer3);
        this.__gluMakeIdentityd(this.matrixBuf);
        this.matrixBuf.put(0, doubleBuffer2.get(0));
        this.matrixBuf.put(4, doubleBuffer2.get(1));
        this.matrixBuf.put(8, doubleBuffer2.get(2));
        this.matrixBuf.put(1, doubleBuffer3.get(0));
        this.matrixBuf.put(5, doubleBuffer3.get(1));
        this.matrixBuf.put(9, doubleBuffer3.get(2));
        this.matrixBuf.put(2, -doubleBuffer.get(0));
        this.matrixBuf.put(6, -doubleBuffer.get(1));
        this.matrixBuf.put(10, -doubleBuffer.get(2));
        gL2.glMultMatrixd(this.matrixBuf);
        gL2.glTranslated(-d, -d2, -d3);
    }

    public boolean gluProject(double d, double d2, double d3, double[] dArray, int n, double[] dArray2, int n2, int[] nArray, int n3, double[] dArray3, int n4) {
        double[] dArray4 = this.in;
        double[] dArray5 = this.out;
        dArray4[0] = d;
        dArray4[1] = d2;
        dArray4[2] = d3;
        dArray4[3] = 1.0;
        this.__gluMultMatrixVecd(dArray, n, dArray4, dArray5);
        this.__gluMultMatrixVecd(dArray2, n2, dArray5, dArray4);
        if (dArray4[3] == 0.0) {
            return false;
        }
        dArray4[3] = 1.0 / dArray4[3] * 0.5;
        dArray4[0] = dArray4[0] * dArray4[3] + 0.5;
        dArray4[1] = dArray4[1] * dArray4[3] + 0.5;
        dArray4[2] = dArray4[2] * dArray4[3] + 0.5;
        dArray3[0 + n4] = dArray4[0] * (double)nArray[2 + n3] + (double)nArray[0 + n3];
        dArray3[1 + n4] = dArray4[1] * (double)nArray[3 + n3] + (double)nArray[1 + n3];
        dArray3[2 + n4] = dArray4[2];
        return true;
    }

    public boolean gluProject(double d, double d2, double d3, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, IntBuffer intBuffer, DoubleBuffer doubleBuffer3) {
        DoubleBuffer doubleBuffer4 = this.inBuf;
        DoubleBuffer doubleBuffer5 = this.outBuf;
        doubleBuffer4.put(0, d);
        doubleBuffer4.put(1, d2);
        doubleBuffer4.put(2, d3);
        doubleBuffer4.put(3, 1.0);
        this.__gluMultMatrixVecd(doubleBuffer, doubleBuffer4, doubleBuffer5);
        this.__gluMultMatrixVecd(doubleBuffer2, doubleBuffer5, doubleBuffer4);
        if (doubleBuffer4.get(3) == 0.0) {
            return false;
        }
        doubleBuffer4.put(3, 1.0 / doubleBuffer4.get(3) * 0.5);
        doubleBuffer4.put(0, doubleBuffer4.get(0) * doubleBuffer4.get(3) + 0.5);
        doubleBuffer4.put(1, doubleBuffer4.get(1) * doubleBuffer4.get(3) + 0.5);
        doubleBuffer4.put(2, doubleBuffer4.get(2) * doubleBuffer4.get(3) + 0.5);
        int n = intBuffer.position();
        int n2 = doubleBuffer3.position();
        doubleBuffer3.put(0 + n2, doubleBuffer4.get(0) * (double)intBuffer.get(2 + n) + (double)intBuffer.get(0 + n));
        doubleBuffer3.put(1 + n2, doubleBuffer4.get(1) * (double)intBuffer.get(3 + n) + (double)intBuffer.get(1 + n));
        doubleBuffer3.put(2 + n2, doubleBuffer4.get(2));
        return true;
    }

    public boolean gluUnProject(double d, double d2, double d3, double[] dArray, int n, double[] dArray2, int n2, int[] nArray, int n3, double[] dArray3, int n4) {
        double[] dArray4 = this.in;
        double[] dArray5 = this.out;
        this.__gluMultMatricesd(dArray, n, dArray2, n2, this.matrix);
        if (!this.__gluInvertMatrixd(this.matrix, this.matrix)) {
            return false;
        }
        dArray4[0] = d;
        dArray4[1] = d2;
        dArray4[2] = d3;
        dArray4[3] = 1.0;
        dArray4[0] = (dArray4[0] - (double)nArray[0 + n3]) / (double)nArray[2 + n3];
        dArray4[1] = (dArray4[1] - (double)nArray[1 + n3]) / (double)nArray[3 + n3];
        dArray4[0] = dArray4[0] * 2.0 - 1.0;
        dArray4[1] = dArray4[1] * 2.0 - 1.0;
        dArray4[2] = dArray4[2] * 2.0 - 1.0;
        this.__gluMultMatrixVecd(this.matrix, 0, dArray4, dArray5);
        if (dArray5[3] == 0.0) {
            return false;
        }
        dArray5[3] = 1.0 / dArray5[3];
        dArray3[0 + n4] = dArray5[0] * dArray5[3];
        dArray3[1 + n4] = dArray5[1] * dArray5[3];
        dArray3[2 + n4] = dArray5[2] * dArray5[3];
        return true;
    }

    public boolean gluUnProject(double d, double d2, double d3, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, IntBuffer intBuffer, DoubleBuffer doubleBuffer3) {
        DoubleBuffer doubleBuffer4 = this.inBuf;
        DoubleBuffer doubleBuffer5 = this.outBuf;
        this.__gluMultMatricesd(doubleBuffer, doubleBuffer2, this.matrixBuf);
        if (!this.__gluInvertMatrixd(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        doubleBuffer4.put(0, d);
        doubleBuffer4.put(1, d2);
        doubleBuffer4.put(2, d3);
        doubleBuffer4.put(3, 1.0);
        int n = intBuffer.position();
        int n2 = doubleBuffer3.position();
        doubleBuffer4.put(0, (doubleBuffer4.get(0) - (double)intBuffer.get(0 + n)) / (double)intBuffer.get(2 + n));
        doubleBuffer4.put(1, (doubleBuffer4.get(1) - (double)intBuffer.get(1 + n)) / (double)intBuffer.get(3 + n));
        doubleBuffer4.put(0, doubleBuffer4.get(0) * 2.0 - 1.0);
        doubleBuffer4.put(1, doubleBuffer4.get(1) * 2.0 - 1.0);
        doubleBuffer4.put(2, doubleBuffer4.get(2) * 2.0 - 1.0);
        this.__gluMultMatrixVecd(this.matrixBuf, doubleBuffer4, doubleBuffer5);
        if (doubleBuffer5.get(3) == 0.0) {
            return false;
        }
        doubleBuffer5.put(3, 1.0 / doubleBuffer5.get(3));
        doubleBuffer3.put(0 + n2, doubleBuffer5.get(0) * doubleBuffer5.get(3));
        doubleBuffer3.put(1 + n2, doubleBuffer5.get(1) * doubleBuffer5.get(3));
        doubleBuffer3.put(2 + n2, doubleBuffer5.get(2) * doubleBuffer5.get(3));
        return true;
    }

    public boolean gluUnProject4(double d, double d2, double d3, double d4, double[] dArray, int n, double[] dArray2, int n2, int[] nArray, int n3, double d5, double d6, double[] dArray3, int n4) {
        double[] dArray4 = this.in;
        double[] dArray5 = this.out;
        this.__gluMultMatricesd(dArray, n, dArray2, n2, this.matrix);
        if (!this.__gluInvertMatrixd(this.matrix, this.matrix)) {
            return false;
        }
        dArray4[0] = d;
        dArray4[1] = d2;
        dArray4[2] = d3;
        dArray4[3] = d4;
        dArray4[0] = (dArray4[0] - (double)nArray[0 + n3]) / (double)nArray[2 + n3];
        dArray4[1] = (dArray4[1] - (double)nArray[1 + n3]) / (double)nArray[3 + n3];
        dArray4[2] = (dArray4[2] - d5) / (d6 - d5);
        dArray4[0] = dArray4[0] * 2.0 - 1.0;
        dArray4[1] = dArray4[1] * 2.0 - 1.0;
        dArray4[2] = dArray4[2] * 2.0 - 1.0;
        this.__gluMultMatrixVecd(this.matrix, 0, dArray4, dArray5);
        if (dArray5[3] == 0.0) {
            return false;
        }
        dArray3[0 + n4] = dArray5[0];
        dArray3[1 + n4] = dArray5[1];
        dArray3[2 + n4] = dArray5[2];
        dArray3[3 + n4] = dArray5[3];
        return true;
    }

    public boolean gluUnProject4(double d, double d2, double d3, double d4, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, IntBuffer intBuffer, double d5, double d6, DoubleBuffer doubleBuffer3) {
        DoubleBuffer doubleBuffer4 = this.inBuf;
        DoubleBuffer doubleBuffer5 = this.outBuf;
        this.__gluMultMatricesd(doubleBuffer, doubleBuffer2, this.matrixBuf);
        if (!this.__gluInvertMatrixd(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        doubleBuffer4.put(0, d);
        doubleBuffer4.put(1, d2);
        doubleBuffer4.put(2, d3);
        doubleBuffer4.put(3, d4);
        int n = intBuffer.position();
        doubleBuffer4.put(0, (doubleBuffer4.get(0) - (double)intBuffer.get(0 + n)) / (double)intBuffer.get(2 + n));
        doubleBuffer4.put(1, (doubleBuffer4.get(1) - (double)intBuffer.get(1 + n)) / (double)intBuffer.get(3 + n));
        doubleBuffer4.put(2, (doubleBuffer4.get(2) - d5) / (d6 - d5));
        doubleBuffer4.put(0, doubleBuffer4.get(0) * 2.0 - 1.0);
        doubleBuffer4.put(1, doubleBuffer4.get(1) * 2.0 - 1.0);
        doubleBuffer4.put(2, doubleBuffer4.get(2) * 2.0 - 1.0);
        this.__gluMultMatrixVecd(this.matrixBuf, doubleBuffer4, doubleBuffer5);
        if (doubleBuffer5.get(3) == 0.0) {
            return false;
        }
        int n2 = doubleBuffer3.position();
        doubleBuffer3.put(0 + n2, doubleBuffer5.get(0));
        doubleBuffer3.put(1 + n2, doubleBuffer5.get(1));
        doubleBuffer3.put(2 + n2, doubleBuffer5.get(2));
        doubleBuffer3.put(3 + n2, doubleBuffer5.get(3));
        return true;
    }

    public void gluPickMatrix(GL2 gL2, double d, double d2, double d3, double d4, IntBuffer intBuffer) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            return;
        }
        int n = intBuffer.position();
        gL2.glTranslated(((double)intBuffer.get(2 + n) - 2.0 * (d - (double)intBuffer.get(0 + n))) / d3, ((double)intBuffer.get(3 + n) - 2.0 * (d2 - (double)intBuffer.get(1 + n))) / d4, 0.0);
        gL2.glScaled((double)intBuffer.get(2) / d3, (double)intBuffer.get(3) / d4, 1.0);
    }

    public void gluPickMatrix(GL2 gL2, double d, double d2, double d3, double d4, int[] nArray, int n) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            return;
        }
        gL2.glTranslated(((double)nArray[2 + n] - 2.0 * (d - (double)nArray[0 + n])) / d3, ((double)nArray[3 + n] - 2.0 * (d2 - (double)nArray[1 + n])) / d4, 0.0);
        gL2.glScaled((double)nArray[2 + n] / d3, (double)nArray[3 + n] / d4, 1.0);
    }
}

