/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows.wgl;

import com.sun.gluegen.runtime.DynamicLookupHelper;
import com.sun.nativewindow.impl.NWReflection;
import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.GLPbufferImpl;
import com.sun.opengl.impl.windows.wgl.WGL;
import com.sun.opengl.impl.windows.wgl.WGLExt;
import com.sun.opengl.impl.windows.wgl.WindowsDummyWGLDrawable;
import com.sun.opengl.impl.windows.wgl.WindowsExternalWGLContext;
import com.sun.opengl.impl.windows.wgl.WindowsExternalWGLDrawable;
import com.sun.opengl.impl.windows.wgl.WindowsOffscreenWGLDrawable;
import com.sun.opengl.impl.windows.wgl.WindowsOnscreenWGLDrawable;
import com.sun.opengl.impl.windows.wgl.WindowsPbufferWGLDrawable;
import com.sun.opengl.impl.windows.wgl.WindowsWGLContext;
import com.sun.opengl.impl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.Threading;

public class WindowsWGLDrawableFactory
extends GLDrawableFactoryImpl
implements DynamicLookupHelper {
    private static final boolean VERBOSE = Debug.verbose();
    private long hglu32;
    private long hopengl32;
    private boolean pbufferSupportInitialized = false;
    private boolean canCreateGLPbuffer = false;
    private static final int GAMMA_RAMP_LENGTH = 256;

    public WindowsWGLDrawableFactory() {
        new WindowsWGLGraphicsConfigurationFactory();
        try {
            NWReflection.createInstance((String)"com.sun.opengl.impl.windows.wgl.awt.WindowsAWTWGLGraphicsConfigurationFactory", (Object[])new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.loadOpenGL32Library();
    }

    public GLDrawable createGLDrawable(NativeWindow nativeWindow) {
        if (nativeWindow == null) {
            throw new IllegalArgumentException("Null target");
        }
        nativeWindow = NativeWindowFactory.getNativeWindow((Object)nativeWindow, null);
        return new WindowsOnscreenWGLDrawable(this, nativeWindow);
    }

    public GLDrawableImpl createOffscreenDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault();
        return new WindowsOffscreenWGLDrawable(this, abstractGraphicsScreen, gLCapabilities, gLCapabilitiesChooser, n, n2);
    }

    public boolean canCreateGLPbuffer() {
        if (!this.pbufferSupportInitialized) {
            final WindowsWGLDrawableFactory windowsWGLDrawableFactory = this;
            Runnable runnable = new Runnable(){

                public void run() {
                    WindowsDummyWGLDrawable windowsDummyWGLDrawable = new WindowsDummyWGLDrawable(windowsWGLDrawableFactory);
                    GLContext gLContext = windowsDummyWGLDrawable.createContext(null);
                    if (gLContext != null) {
                        GLContext gLContext2 = GLContext.getCurrent();
                        if (gLContext2 != null) {
                            gLContext2.release();
                        }
                        gLContext.makeCurrent();
                        GL gL = gLContext.getGL();
                        WindowsWGLDrawableFactory.this.canCreateGLPbuffer = gL.isExtensionAvailable("GL_ARB_pbuffer");
                        WindowsWGLDrawableFactory.this.pbufferSupportInitialized = true;
                        gLContext.release();
                        gLContext.destroy();
                        windowsDummyWGLDrawable.destroy();
                        if (gLContext2 != null) {
                            gLContext2.makeCurrent();
                        }
                    }
                }
            };
            this.maybeDoSingleThreadedWorkaround(runnable);
        }
        if (DEBUG) {
            System.err.println("WindowsWGLDrawableFactory.canCreateGLPbuffer() = " + this.canCreateGLPbuffer);
        }
        return this.canCreateGLPbuffer;
    }

    public GLPbuffer createGLPbuffer(final GLCapabilities gLCapabilities, final GLCapabilitiesChooser gLCapabilitiesChooser, final int n, final int n2, final GLContext gLContext) {
        if (!this.canCreateGLPbuffer()) {
            throw new GLException("Pbuffer support not available with current graphics card");
        }
        final ArrayList arrayList = new ArrayList();
        final WindowsWGLDrawableFactory windowsWGLDrawableFactory = this;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                WindowsDummyWGLDrawable windowsDummyWGLDrawable = new WindowsDummyWGLDrawable(windowsWGLDrawableFactory);
                WindowsWGLContext windowsWGLContext = (WindowsWGLContext)windowsDummyWGLDrawable.createContext(null);
                GLContext gLContext2 = GLContext.getCurrent();
                if (gLContext2 != null) {
                    gLContext2.release();
                }
                windowsWGLContext.makeCurrent();
                WGLExt wGLExt = windowsWGLContext.getWGLExt();
                try {
                    AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault();
                    WindowsPbufferWGLDrawable windowsPbufferWGLDrawable = new WindowsPbufferWGLDrawable(windowsWGLDrawableFactory, abstractGraphicsScreen, gLCapabilities, gLCapabilitiesChooser, n, n2, windowsDummyWGLDrawable, wGLExt);
                    GLPbufferImpl gLPbufferImpl = new GLPbufferImpl(windowsPbufferWGLDrawable, gLContext);
                    arrayList.add(gLPbufferImpl);
                    windowsWGLContext.release();
                    windowsWGLContext.destroy();
                    windowsDummyWGLDrawable.destroy();
                }
                finally {
                    if (gLContext2 != null) {
                        gLContext2.makeCurrent();
                    }
                }
            }
        };
        this.maybeDoSingleThreadedWorkaround(runnable);
        return (GLPbuffer)arrayList.get(0);
    }

    public GLContext createExternalGLContext() {
        return WindowsExternalWGLContext.create(this, null);
    }

    public boolean canCreateExternalGLDrawable() {
        return true;
    }

    public GLDrawable createExternalGLDrawable() {
        return WindowsExternalWGLDrawable.create(this, null);
    }

    public void loadOpenGL32Library() {
        if (this.hopengl32 == 0L) {
            this.hopengl32 = WGL.LoadLibraryA("OpenGL32");
            if (DEBUG && this.hopengl32 == 0L) {
                System.err.println("WindowsWGLDrawableFactory: Could not load OpenGL32.dll - maybe an embedded device");
            }
        }
    }

    public void loadGLULibrary() {
        if (this.hglu32 == 0L) {
            this.hglu32 = WGL.LoadLibraryA("GLU32");
            if (this.hglu32 == 0L) {
                throw new GLException("Error loading GLU32.DLL");
            }
        }
    }

    public long dynamicLookupFunction(String string) {
        long l = WGL.wglGetProcAddress(string);
        if (l == 0L && this.hopengl32 != 0L) {
            l = WGL.GetProcAddress(this.hopengl32, string);
        }
        if (l == 0L && this.hglu32 != 0L) {
            l = WGL.GetProcAddress(this.hglu32, string);
        }
        return l;
    }

    static String wglGetLastError() {
        long l = WGL.GetLastError();
        String string = null;
        switch ((int)l) {
            case 2000: {
                string = "ERROR_INVALID_PIXEL_FORMAT";
                break;
            }
            case 1450: {
                string = "ERROR_NO_SYSTEM_RESOURCES";
                break;
            }
            case 13: {
                string = "ERROR_INVALID_DATA";
                break;
            }
            case 127: {
                string = "ERROR_PROC_NOT_FOUND";
                break;
            }
            case 1400: {
                string = "ERROR_INVALID_WINDOW_HANDLE";
                break;
            }
            default: {
                string = "(Unknown error code " + l + ")";
            }
        }
        return string;
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(runnable);
        } else {
            runnable.run();
        }
    }

    public boolean canCreateContextOnJava2DSurface() {
        return false;
    }

    public GLContext createContextOnJava2DSurface(Object object, GLContext gLContext) throws GLException {
        throw new GLException("Unimplemented on this platform");
    }

    protected int getGammaRampLength() {
        return 256;
    }

    protected boolean setGammaRamp(float[] fArray) {
        short[] sArray = new short[768];
        for (int i = 0; i < 256; ++i) {
            short s;
            sArray[i] = s = (short)(fArray[i] * 65535.0f);
            sArray[i + 256] = s;
            sArray[i + 512] = s;
        }
        long l = WGL.GetDC(0L);
        boolean bl = WGL.SetDeviceGammaRamp(l, ShortBuffer.wrap(sArray));
        WGL.ReleaseDC(0L, l);
        return bl;
    }

    protected Buffer getGammaRamp() {
        ShortBuffer shortBuffer = ShortBuffer.wrap(new short[768]);
        long l = WGL.GetDC(0L);
        boolean bl = WGL.GetDeviceGammaRamp(l, shortBuffer);
        WGL.ReleaseDC(0L, l);
        if (!bl) {
            return null;
        }
        return shortBuffer;
    }

    protected void resetGammaRamp(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        long l = WGL.GetDC(0L);
        WGL.SetDeviceGammaRamp(l, buffer);
        WGL.ReleaseDC(0L, l);
    }
}

