/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11.glx;

import com.sun.gluegen.runtime.DynamicLookupHelper;
import com.sun.gluegen.runtime.opengl.GLProcAddressHelper;
import com.sun.nativewindow.impl.NWReflection;
import com.sun.nativewindow.impl.x11.X11Lib;
import com.sun.nativewindow.impl.x11.X11Util;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.GLPbufferImpl;
import com.sun.opengl.impl.x11.glx.GLX;
import com.sun.opengl.impl.x11.glx.X11ExternalGLXContext;
import com.sun.opengl.impl.x11.glx.X11ExternalGLXDrawable;
import com.sun.opengl.impl.x11.glx.X11GLXGraphicsConfigurationFactory;
import com.sun.opengl.impl.x11.glx.X11OffscreenGLXDrawable;
import com.sun.opengl.impl.x11.glx.X11OnscreenGLXDrawable;
import com.sun.opengl.impl.x11.glx.X11PbufferGLXDrawable;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.x11.X11GraphicsScreen;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.Threading;

public class X11GLXDrawableFactory
extends GLDrawableFactoryImpl
implements DynamicLookupHelper {
    private boolean pbufferSupportInitialized = false;
    private boolean canCreateGLPbuffer = false;
    private boolean gotGammaRampLength;
    private int gammaRampLength;

    public X11GLXDrawableFactory() {
        GLProcAddressHelper.resetProcAddressTable((Object)GLX.getGLXProcAddressTable(), (DynamicLookupHelper)this);
        new X11GLXGraphicsConfigurationFactory();
        try {
            NWReflection.createInstance((String)"com.sun.opengl.impl.x11.glx.awt.X11AWTGLXGraphicsConfigurationFactory", (Object[])new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public GLDrawable createGLDrawable(NativeWindow nativeWindow) {
        if (nativeWindow == null) {
            throw new IllegalArgumentException("Null target");
        }
        nativeWindow = NativeWindowFactory.getNativeWindow((Object)nativeWindow, null);
        return new X11OnscreenGLXDrawable(this, nativeWindow);
    }

    public GLDrawableImpl createOffscreenDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        AbstractGraphicsScreen abstractGraphicsScreen = X11GraphicsScreen.createDefault();
        return new X11OffscreenGLXDrawable(this, abstractGraphicsScreen, gLCapabilities, gLCapabilitiesChooser, n, n2);
    }

    public boolean canCreateGLPbuffer() {
        if (!this.pbufferSupportInitialized) {
            long l = X11Util.getThreadLocalDefaultDisplay();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            boolean bl = false;
            if (!GLX.glXQueryVersion(l, nArray, 0, nArray2, 0)) {
                throw new GLException("glXQueryVersion failed");
            }
            if (DEBUG) {
                System.err.println("!!! GLX version: major " + nArray[0] + ", minor " + nArray2[0]);
            }
            if (nArray[0] == 1 && nArray2[0] == 2) {
                String string = GLX.glXGetClientString(l, 2);
                if (string != null && string.startsWith("1.") && string.charAt(2) >= '3') {
                    this.canCreateGLPbuffer = true;
                }
            } else {
                this.canCreateGLPbuffer = nArray[0] > 1 || nArray2[0] > 2;
            }
            this.pbufferSupportInitialized = true;
        }
        return this.canCreateGLPbuffer;
    }

    public GLPbuffer createGLPbuffer(final GLCapabilities gLCapabilities, final GLCapabilitiesChooser gLCapabilitiesChooser, final int n, final int n2, final GLContext gLContext) {
        if (!this.canCreateGLPbuffer()) {
            throw new GLException("Pbuffer support not available with current graphics card");
        }
        final ArrayList arrayList = new ArrayList();
        final X11GLXDrawableFactory x11GLXDrawableFactory = this;
        Runnable runnable = new Runnable(){

            public void run() {
                AbstractGraphicsScreen abstractGraphicsScreen = X11GraphicsScreen.createDefault();
                X11PbufferGLXDrawable x11PbufferGLXDrawable = new X11PbufferGLXDrawable(x11GLXDrawableFactory, abstractGraphicsScreen, gLCapabilities, gLCapabilitiesChooser, n, n2);
                GLPbufferImpl gLPbufferImpl = new GLPbufferImpl(x11PbufferGLXDrawable, gLContext);
                arrayList.add(gLPbufferImpl);
            }
        };
        this.maybeDoSingleThreadedWorkaround(runnable);
        return (GLPbuffer)arrayList.get(0);
    }

    public GLContext createExternalGLContext() {
        return X11ExternalGLXContext.create(this, null);
    }

    public boolean canCreateExternalGLDrawable() {
        return this.canCreateGLPbuffer();
    }

    public GLDrawable createExternalGLDrawable() {
        return X11ExternalGLXDrawable.create(this, null);
    }

    public void loadGLULibrary() {
        X11Lib.dlopen((String)"/usr/lib/libGLU.so");
    }

    public long dynamicLookupFunction(String string) {
        long l = 0L;
        l = GLX.glXGetProcAddressARB(string);
        if (l == 0L) {
            l = X11Lib.dlsym((String)string);
        }
        return l;
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(runnable);
        } else {
            runnable.run();
        }
    }

    public boolean canCreateContextOnJava2DSurface() {
        return false;
    }

    public GLContext createContextOnJava2DSurface(Object object, GLContext gLContext) throws GLException {
        throw new GLException("Unimplemented on this platform");
    }

    protected synchronized int getGammaRampLength() {
        if (this.gotGammaRampLength) {
            return this.gammaRampLength;
        }
        int[] nArray = new int[1];
        long l = X11Util.getThreadLocalDefaultDisplay();
        boolean bl = X11Lib.XF86VidModeGetGammaRampSize((long)l, (int)X11Lib.DefaultScreen((long)l), (int[])nArray, (int)0);
        if (!bl) {
            return 0;
        }
        this.gotGammaRampLength = true;
        this.gammaRampLength = nArray[0];
        return this.gammaRampLength;
    }

    protected boolean setGammaRamp(float[] fArray) {
        int n = fArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)(fArray[i] * 65535.0f);
        }
        long l = X11Util.getThreadLocalDefaultDisplay();
        boolean bl = X11Lib.XF86VidModeSetGammaRamp((long)l, (int)X11Lib.DefaultScreen((long)l), (int)sArray.length, (short[])sArray, (int)0, (short[])sArray, (int)0, (short[])sArray, (int)0);
        return bl;
    }

    protected Buffer getGammaRamp() {
        int n = this.getGammaRampLength();
        ShortBuffer shortBuffer = ShortBuffer.wrap(new short[3 * n]);
        shortBuffer.position(0);
        shortBuffer.limit(n);
        ShortBuffer shortBuffer2 = shortBuffer.slice();
        shortBuffer.position(n);
        shortBuffer.limit(2 * n);
        ShortBuffer shortBuffer3 = shortBuffer.slice();
        shortBuffer.position(2 * n);
        shortBuffer.limit(3 * n);
        ShortBuffer shortBuffer4 = shortBuffer.slice();
        long l = X11Util.getThreadLocalDefaultDisplay();
        boolean bl = X11Lib.XF86VidModeGetGammaRamp((long)l, (int)X11Lib.DefaultScreen((long)l), (int)n, (ShortBuffer)shortBuffer2, (ShortBuffer)shortBuffer3, (ShortBuffer)shortBuffer4);
        if (!bl) {
            return null;
        }
        return shortBuffer;
    }

    protected void resetGammaRamp(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        ShortBuffer shortBuffer = (ShortBuffer)buffer;
        int n = shortBuffer.capacity();
        if (n % 3 != 0) {
            throw new IllegalArgumentException("Must not be the original gamma ramp");
        }
        int n2 = n / 3;
        shortBuffer.position(0);
        shortBuffer.limit(n2);
        ShortBuffer shortBuffer2 = shortBuffer.slice();
        shortBuffer.position(n2);
        shortBuffer.limit(2 * n2);
        ShortBuffer shortBuffer3 = shortBuffer.slice();
        shortBuffer.position(2 * n2);
        shortBuffer.limit(3 * n2);
        ShortBuffer shortBuffer4 = shortBuffer.slice();
        long l = X11Util.getThreadLocalDefaultDisplay();
        X11Lib.XF86VidModeSetGammaRamp((long)l, (int)X11Lib.DefaultScreen((long)l), (int)n2, (ShortBuffer)shortBuffer2, (ShortBuffer)shortBuffer3, (ShortBuffer)shortBuffer4);
    }
}

