/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import javax.media.opengl.GL;

public class FBObject {
    private int width;
    private int height;
    private int attr;
    private int fb;
    private int fbo_tex;
    private int depth_rb;
    private int stencil_rb;
    private int vStatus;
    private int texInternalFormat;
    private int texDataFormat;
    private int texDataType;
    public static final int ATTR_DEPTH = 1;
    public static final int ATTR_STENCIL = 2;

    public FBObject(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.attr = n3;
    }

    public boolean validateStatus(GL gL) {
        this.vStatus = FBObject.getStatus(gL, this.fb);
        switch (this.vStatus) {
            case 36053: {
                return true;
            }
        }
        return false;
    }

    public static int getStatus(GL gL, int n) {
        if (!gL.glIsFramebuffer(n)) {
            return -1;
        }
        return gL.glCheckFramebufferStatus(36160);
    }

    public String getStatusString() {
        return FBObject.getStatusString(this.vStatus);
    }

    public static String getStatusString(int n) {
        switch (n) {
            case -1: {
                return "NOT A FBO";
            }
            case 36053: {
                return "OK";
            }
            case 36054: {
                return "GL FBO: incomplete,incomplete attachment\n";
            }
            case 36061: {
                return "GL FBO: Unsupported framebuffer format";
            }
            case 36055: {
                return "GL FBO: incomplete,missing attachment";
            }
            case 36057: {
                return "GL FBO: incomplete,attached images must have same dimensions";
            }
            case 36058: {
                return "GL FBO: incomplete,attached images must have same format";
            }
            case 0: {
                return "GL FBO: incomplete, implementation fault";
            }
        }
        return "GL FBO: incomplete, implementation ERROR";
    }

    public void init(GL gL) {
        int n;
        int n2;
        int n3;
        if (gL.isGL2()) {
            n3 = 32856;
            n2 = 32993;
            n = 33639;
        } else if (gL.isGLES()) {
            n3 = 6408;
            n2 = 6408;
            n = 5121;
        } else {
            n3 = 6407;
            n2 = 6407;
            n = 5121;
        }
        this.init(gL, n3, n2, n);
    }

    public void init(GL gL, int n, int n2, int n3) {
        this.texInternalFormat = n;
        this.texDataFormat = n2;
        this.texDataType = n3;
        int[] nArray = new int[1];
        gL.glGenFramebuffers(1, nArray, 0);
        this.fb = nArray[0];
        System.out.println("fb: " + this.fb);
        gL.glGenTextures(1, nArray, 0);
        this.fbo_tex = nArray[0];
        System.out.println("fbo_tex: " + this.fbo_tex);
        if (0 != (this.attr & 1)) {
            gL.glGenRenderbuffers(1, nArray, 0);
            this.depth_rb = nArray[0];
            System.out.println("depth_rb: " + this.depth_rb);
        } else {
            this.depth_rb = 0;
        }
        if (0 != (this.attr & 2)) {
            gL.glGenRenderbuffers(1, nArray, 0);
            this.stencil_rb = nArray[0];
            System.out.println("stencil_rb: " + this.stencil_rb);
        } else {
            this.stencil_rb = 0;
        }
        gL.glBindFramebuffer(36160, this.fb);
        gL.glBindTexture(3553, this.fbo_tex);
        gL.glTexImage2D(3553, 0, this.texInternalFormat, this.width, this.height, 0, this.texDataFormat, this.texDataType, null);
        gL.glTexParameteri(3553, 10240, 9728);
        gL.glTexParameteri(3553, 10241, 9728);
        gL.glFramebufferTexture2D(36160, 36064, 3553, this.fbo_tex, 0);
        if (this.depth_rb != 0) {
            gL.glBindRenderbuffer(36161, this.depth_rb);
            gL.glRenderbufferStorage(36161, 33189, this.width, this.height);
            gL.glFramebufferRenderbuffer(36160, 36096, 36161, this.depth_rb);
        }
        if (this.stencil_rb != 0) {
            gL.glBindRenderbuffer(36161, this.stencil_rb);
            gL.glRenderbufferStorage(36161, 36168, this.width, this.height);
            gL.glFramebufferRenderbuffer(36160, 36128, 36161, this.stencil_rb);
        }
        if (this.validateStatus(gL)) {
            System.out.println("Framebuffer " + this.fb + " is complete");
        } else {
            System.out.println("Framebuffer " + this.fb + " is incomplete: status = 0x" + Integer.toHexString(this.vStatus) + " : " + this.getStatusString());
        }
        this.unbind(gL);
    }

    public void destroy(GL gL) {
        this.unbind(gL);
        int[] nArray = new int[1];
        if (0 != this.stencil_rb) {
            nArray[0] = this.stencil_rb;
            gL.glDeleteRenderbuffers(1, nArray, 0);
            this.stencil_rb = 0;
        }
        if (0 != this.depth_rb) {
            nArray[0] = this.depth_rb;
            gL.glDeleteRenderbuffers(1, nArray, 0);
            this.depth_rb = 0;
        }
        if (0 != this.fbo_tex) {
            nArray[0] = this.fbo_tex;
            gL.glDeleteTextures(1, nArray, 0);
            this.fbo_tex = 0;
        }
        if (0 != this.fb) {
            nArray[0] = this.fb;
            gL.glDeleteFramebuffers(1, nArray, 0);
            this.fb = 0;
        }
    }

    public void bind(GL gL) {
        gL.glBindTexture(3553, this.fbo_tex);
        gL.glBindFramebuffer(36160, this.fb);
    }

    public void unbind(GL gL) {
        gL.glBindTexture(3553, 0);
        gL.glBindFramebuffer(36160, 0);
    }

    public void use(GL gL) {
        gL.glBindTexture(3553, 0);
        gL.glBindFramebuffer(36160, 0);
        gL.glBindTexture(3553, this.fbo_tex);
    }

    public int getFBName() {
        return this.fb;
    }

    public int getTextureName() {
        return this.fbo_tex;
    }
}

