/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture.spi.awt;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.awt.AWTTextureData;
import com.sun.opengl.util.texture.spi.TextureProvider;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class IIOTextureProvider
implements TextureProvider {
    private static final boolean DEBUG = Debug.debug("TextureIO");

    public TextureData newTextureData(File file, int n, int n2, boolean bl, String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            return null;
        }
        if (DEBUG) {
            System.out.println("TextureIO.newTextureData(): BufferedImage type for " + file + " = " + bufferedImage.getType());
        }
        return new AWTTextureData(n, n2, bl, bufferedImage);
    }

    public TextureData newTextureData(InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            return null;
        }
        if (DEBUG) {
            System.out.println("TextureIO.newTextureData(): BufferedImage type for stream = " + bufferedImage.getType());
        }
        return new AWTTextureData(n, n2, bl, bufferedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureData newTextureData(URL uRL, int n, int n2, boolean bl, String string) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            TextureData textureData = this.newTextureData(inputStream, n, n2, bl, string);
            return textureData;
        }
        finally {
            inputStream.close();
        }
    }
}

