/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import javax.media.nativewindow.Capabilities;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class GLCapabilities
extends Capabilities
implements Cloneable {
    private GLProfile glProfile = null;
    private boolean pbuffer = false;
    private boolean doubleBuffered = true;
    private boolean stereo = false;
    private boolean hardwareAccelerated = true;
    private int depthBits = 24;
    private int stencilBits = 0;
    private int accumRedBits = 0;
    private int accumGreenBits = 0;
    private int accumBlueBits = 0;
    private int accumAlphaBits = 0;
    private boolean sampleBuffers = false;
    private int numSamples = 2;
    private boolean pbufferFloatingPointBuffers;
    private boolean pbufferRenderToTexture;
    private boolean pbufferRenderToTextureRectangle;

    public GLCapabilities(GLProfile gLProfile) {
        this.glProfile = null != gLProfile ? gLProfile : GLProfile.getDefault();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new GLException(runtimeException);
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof GLCapabilities)) {
            return false;
        }
        GLCapabilities gLCapabilities = (GLCapabilities)object;
        boolean bl2 = bl = super.equals(object) && gLCapabilities.getGLProfile() == this.glProfile && gLCapabilities.isPBuffer() == this.pbuffer && gLCapabilities.getStereo() == this.stereo && gLCapabilities.getHardwareAccelerated() == this.hardwareAccelerated && gLCapabilities.getDepthBits() == this.depthBits && gLCapabilities.getStencilBits() == this.stencilBits && gLCapabilities.getAccumRedBits() == this.accumRedBits && gLCapabilities.getAccumGreenBits() == this.accumGreenBits && gLCapabilities.getAccumBlueBits() == this.accumBlueBits && gLCapabilities.getAccumAlphaBits() == this.accumAlphaBits && gLCapabilities.getSampleBuffers() == this.sampleBuffers && gLCapabilities.getPbufferFloatingPointBuffers() == this.pbufferFloatingPointBuffers && gLCapabilities.getPbufferRenderToTexture() == this.pbufferRenderToTexture && gLCapabilities.getPbufferRenderToTextureRectangle() == this.pbufferRenderToTextureRectangle;
        if (this.sampleBuffers) {
            bl = bl && gLCapabilities.getNumSamples() == this.numSamples;
        }
        return bl;
    }

    public GLProfile getGLProfile() {
        return this.glProfile;
    }

    public void setGLProfile(GLProfile gLProfile) {
        this.glProfile = gLProfile;
    }

    public boolean isPBuffer() {
        return this.pbuffer;
    }

    public void setPBuffer(boolean bl) {
        this.pbuffer = bl;
    }

    public boolean getDoubleBuffered() {
        return this.doubleBuffered;
    }

    public void setDoubleBuffered(boolean bl) {
        this.doubleBuffered = bl;
    }

    public boolean getStereo() {
        return this.stereo;
    }

    public void setStereo(boolean bl) {
        this.stereo = bl;
    }

    public boolean getHardwareAccelerated() {
        return this.hardwareAccelerated;
    }

    public void setHardwareAccelerated(boolean bl) {
        this.hardwareAccelerated = bl;
    }

    public int getDepthBits() {
        return this.depthBits;
    }

    public void setDepthBits(int n) {
        this.depthBits = n;
    }

    public int getStencilBits() {
        return this.stencilBits;
    }

    public void setStencilBits(int n) {
        this.stencilBits = n;
    }

    public int getAccumRedBits() {
        return this.accumRedBits;
    }

    public void setAccumRedBits(int n) {
        this.accumRedBits = n;
    }

    public int getAccumGreenBits() {
        return this.accumGreenBits;
    }

    public void setAccumGreenBits(int n) {
        this.accumGreenBits = n;
    }

    public int getAccumBlueBits() {
        return this.accumBlueBits;
    }

    public void setAccumBlueBits(int n) {
        this.accumBlueBits = n;
    }

    public int getAccumAlphaBits() {
        return this.accumAlphaBits;
    }

    public void setAccumAlphaBits(int n) {
        this.accumAlphaBits = n;
    }

    public void setSampleBuffers(boolean bl) {
        this.sampleBuffers = bl;
    }

    public boolean getSampleBuffers() {
        return this.sampleBuffers;
    }

    public void setNumSamples(int n) {
        this.numSamples = n;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setPbufferFloatingPointBuffers(boolean bl) {
        this.pbufferFloatingPointBuffers = bl;
    }

    public boolean getPbufferFloatingPointBuffers() {
        return this.pbufferFloatingPointBuffers;
    }

    public void setPbufferRenderToTexture(boolean bl) {
        this.pbufferRenderToTexture = bl;
    }

    public boolean getPbufferRenderToTexture() {
        return this.pbufferRenderToTexture;
    }

    public void setPbufferRenderToTextureRectangle(boolean bl) {
        this.pbufferRenderToTextureRectangle = bl;
    }

    public boolean getPbufferRenderToTextureRectangle() {
        return this.pbufferRenderToTextureRectangle;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GLCapabilities[");
        stringBuffer.append(super.toString());
        stringBuffer.append(", GL profile: " + this.glProfile + ", PBuffer: " + this.pbuffer + ", DoubleBuffered: " + this.doubleBuffered + ", Stereo: " + this.stereo + ", HardwareAccelerated: " + this.hardwareAccelerated + ", DepthBits: " + this.depthBits + ", StencilBits: " + this.stencilBits + ", Red Accum: " + this.accumRedBits + ", Green Accum: " + this.accumGreenBits + ", Blue Accum: " + this.accumBlueBits + ", Alpha Accum: " + this.accumAlphaBits + ", Multisample: " + this.sampleBuffers + ", Num samples: " + (this.sampleBuffers ? this.numSamples : 0));
        stringBuffer.append(", PBuffer-FloatingPointBuffers: " + this.pbufferFloatingPointBuffers + ", PBuffer-RenderToTexture: " + this.pbufferRenderToTexture + ", PBuffer-RenderToTextureRectangle: " + this.pbufferRenderToTextureRectangle + "]");
        return stringBuffer.toString();
    }
}

