/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import java.util.HashMap;
import javax.media.opengl.GL;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;

public abstract class GLContext {
    public static final int CONTEXT_NOT_CURRENT = 0;
    public static final int CONTEXT_CURRENT = 1;
    public static final int CONTEXT_CURRENT_NEW = 2;
    private static ThreadLocal currentContext = new ThreadLocal();
    private HashMap attachedObjects = new HashMap();

    public abstract GLDrawable getGLDrawable();

    public abstract int makeCurrent() throws GLException;

    public abstract void release() throws GLException;

    public abstract void copy(GLContext var1, int var2) throws GLException;

    public static GL getCurrentGL() throws GLException {
        GLContext gLContext = GLContext.getCurrent();
        if (null == gLContext) {
            throw new GLException("No OpenGL context current on this thread");
        }
        return gLContext.getGL();
    }

    public static GLContext getCurrent() {
        return (GLContext)currentContext.get();
    }

    protected static void setCurrent(GLContext gLContext) {
        currentContext.set(gLContext);
    }

    public abstract void destroy();

    public abstract boolean isSynchronized();

    public abstract void setSynchronized(boolean var1);

    public abstract GL getGL();

    public abstract GL setGL(GL var1);

    public Object getAttachedObject(int n) {
        return this.attachedObjects.get(new Integer(n));
    }

    public Object getAttachedObject(String string) {
        return this.attachedObjects.get(string);
    }

    public Object putAttachedObject(int n, Object object) {
        return this.attachedObjects.put(new Integer(n), object);
    }

    public Object putAttachedObject(String string, Object object) {
        return this.attachedObjects.put(string, object);
    }

    public final String toString() {
        return this.getClass().getName() + " [" + this.getGL() + ",\n\tDrawable: " + this.getGLDrawable() + "] ";
    }

    public abstract String getPlatformExtensionsString();
}

