/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;

public class SiteModel {
    private List archiveReferences;
    private Map categories;
    private URLEntry description;
    private List features;
    private URI locationURI;
    private String locationURIString;
    private String mirrorsURIString;
    private boolean supportsPack200;
    private String type;
    private URLEntry[] associateSites;
    private String digestURIString;
    private List messageKeys;
    private Map localizations;

    public void addArchive(URLEntry archiveReference) {
        if (this.archiveReferences == null) {
            this.archiveReferences = new ArrayList();
        }
        if (!this.archiveReferences.contains(archiveReference)) {
            this.archiveReferences.add(archiveReference);
        }
    }

    public void addCategory(SiteCategory category) {
        if (this.categories == null) {
            this.categories = new HashMap();
        }
        if (!this.categories.containsKey(category.getName())) {
            this.categories.put(category.getName(), category);
            if (this.localizations != null && !this.localizations.isEmpty()) {
                category.setLocalizations(this.localizations);
            }
        }
    }

    public void addFeature(SiteFeature featureReference) {
        if (this.features == null) {
            this.features = new ArrayList();
        }
        this.features.add(featureReference);
    }

    public URLEntry[] getArchives() {
        if (this.archiveReferences == null || this.archiveReferences.size() == 0) {
            return new URLEntry[0];
        }
        return this.archiveReferences.toArray(new URLEntry[0]);
    }

    public URLEntry[] getAssociatedSites() {
        return this.associateSites;
    }

    public SiteCategory[] getCategories() {
        if (this.categories == null || this.categories.size() == 0) {
            return new SiteCategory[0];
        }
        return this.categories.values().toArray(new SiteCategory[0]);
    }

    public SiteCategory getCategory(String name) {
        return this.categories == null ? null : this.categories.get(name);
    }

    public URLEntry getDescription() {
        return this.description;
    }

    public SiteFeature[] getFeatures() {
        if (this.features == null || this.features.size() == 0) {
            return new SiteFeature[0];
        }
        return this.features.toArray(new SiteFeature[0]);
    }

    public Map getLocalizations() {
        return this.localizations;
    }

    public URI getLocationURI() {
        if (this.locationURI == null && this.locationURIString != null) {
            try {
                this.locationURI = new URI(this.locationURIString);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return this.locationURI;
    }

    public String getLocationURIString() {
        return this.locationURIString;
    }

    public List getMessageKeys() {
        return this.messageKeys;
    }

    public String getMirrorsURI() {
        return this.mirrorsURIString;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPack200Supported() {
        return this.supportsPack200;
    }

    public void setDescription(URLEntry description) {
        this.description = description;
    }

    public void setLocalizations(Map localizations) {
        this.localizations = localizations;
        if (localizations != null && !localizations.isEmpty() && this.categories != null && !this.categories.isEmpty()) {
            Iterator catIter = this.categories.entrySet().iterator();
            while (catIter.hasNext()) {
                Map.Entry entry = catIter.next();
                SiteCategory category = (SiteCategory)entry.getValue();
                category.setLocalizations(localizations);
            }
        }
    }

    public void setLocationURIString(String locationURIString) {
        this.locationURIString = locationURIString;
    }

    public void setMessageKeys(List keys) {
        this.messageKeys = keys;
    }

    public void setMirrorsURIString(String mirrorsURI) {
        this.mirrorsURIString = mirrorsURI;
    }

    public void setSupportsPack200(boolean value) {
        this.supportsPack200 = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAssociateSites(URLEntry[] associateSites) {
        this.associateSites = associateSites;
    }

    public void setDigestURIString(String digestURIString) {
        this.digestURIString = digestURIString;
    }

    public String getDigestURIString() {
        return this.digestURIString;
    }
}

