/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.widgets.Display;

public class IntervalTask
implements Runnable {
    private final Display _display;
    private final int _interval;
    private final Runnable _task;
    private final AtomicBoolean _scheduled = new AtomicBoolean();
    private long _lastTime;
    private final Runnable _taskTimer = new Runnable(){

        public void run() {
            int delay = (int)Math.max(0L, (long)IntervalTask.this._interval - (System.nanoTime() - IntervalTask.this._lastTime) / 1000000L);
            if (delay == 0) {
                IntervalTask.this._taskRunner.run();
            } else {
                IntervalTask.this._display.timerExec(delay, IntervalTask.this._taskRunner);
            }
        }
    };
    private final Runnable _taskRunner = new Runnable(){

        public void run() {
            IntervalTask.this._scheduled.set(false);
            IntervalTask.this._lastTime = System.nanoTime();
            IntervalTask.this._task.run();
        }
    };

    protected IntervalTask(Display display, int interval) {
        this._display = display;
        this._interval = interval;
        this._task = this;
    }

    public IntervalTask(Display display, int interval, Runnable task) {
        this._display = display;
        this._interval = interval;
        this._task = task;
    }

    public void schedule() {
        if (!this._display.isDisposed() && this._scheduled.compareAndSet(false, true)) {
            this._display.asyncExec(this._taskTimer);
        }
    }

    public void run() {
    }
}

