/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.Perspective;
import ch.kuramo.javie.app.SaveUtil;
import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;

public class NewProjectAction
extends Action {
    private final IWorkbenchWindow window;

    public NewProjectAction(IWorkbenchWindow window) {
        super("\u65b0\u898f\u30d7\u30ed\u30b8\u30a7\u30af\u30c8");
        this.window = window;
        this.setId("ch.kuramo.javie.app.commands.newProject");
        this.setActionDefinitionId("ch.kuramo.javie.app.commands.newProject");
    }

    public void run() {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.window);
        if (pm != null) {
            switch (SaveUtil.saveIfDirty(pm)) {
                case NOT_DIRTY: 
                case SAVED: 
                case UNSAVED: {
                    break;
                }
                default: {
                    return;
                }
            }
            pm.dispose();
            pm = null;
        }
        NewProjectAction.newProject(this.window);
    }

    public static ProjectManager newProject(IWorkbenchWindow window) {
        Perspective.reset(window);
        ProjectManager pm = ProjectManager.newProject(window);
        UIUtil.showView(window.getActivePage(), "ch.kuramo.javie.app.views.projectView");
        return pm;
    }
}

