/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.project.ProjectManager;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.LabelRetargetAction;

public class UndoAction
extends LabelRetargetAction
implements IOperationHistoryListener {
    private final IWorkbenchWindow window;
    private final IAction defaultHandler;

    public UndoAction(IWorkbenchWindow window) {
        super("org.eclipse.ui.edit.undo", "\u53d6\u308a\u6d88\u3057");
        this.window = window;
        window.getPartService().addPartListener((IPartListener)this);
        this.setActionDefinitionId("org.eclipse.ui.edit.undo");
        ISharedImages sharedImages = window.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
        this.defaultHandler = new Action(){

            public void run() {
                ProjectManager pm = ProjectManager.forWorkbenchWindow(UndoAction.this.window);
                if (pm != null) {
                    pm.undo();
                }
            }
        };
        this.updateDefaultHandlerState(null);
        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this);
        super.dispose();
    }

    protected void setActionHandler(IAction handler) {
        if (handler == null) {
            handler = this.defaultHandler;
        }
        super.setActionHandler(handler);
    }

    public void historyNotification(OperationHistoryEvent event) {
        ProjectManager pm;
        IUndoableOperation op = event.getOperation();
        if (!op.hasContext((pm = ProjectManager.forWorkbenchWindow(this.window)).getUndoContext())) {
            return;
        }
        switch (event.getEventType()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.updateDefaultHandlerState(pm);
            }
        }
    }

    private void updateDefaultHandlerState(ProjectManager pm) {
        if (pm != null && pm.canUndo()) {
            this.defaultHandler.setEnabled(true);
            this.defaultHandler.setText(String.format("\u53d6\u308a\u6d88\u3057\uff1a %s", pm.getUndoLabel()));
        } else {
            this.defaultHandler.setEnabled(false);
            this.defaultHandler.setText("\u53d6\u308a\u6d88\u3057\u4e0d\u53ef");
        }
    }
}

