/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.BlendMode;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ModifyLayerBlendModeOperation
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final BlendMode _oldBlendMode;
    private final BlendMode _newBlendMode;

    public ModifyLayerBlendModeOperation(ProjectManager projectManager, MediaLayer layer, BlendMode newBlendMode) {
        super(projectManager, "\u63cf\u753b\u30e2\u30fc\u30c9\u306e\u5909\u66f4");
        LayerComposition comp = projectManager.checkLayer((Layer)layer);
        BlendMode oldBlendMode = layer.getBlendMode();
        this._noEffect = newBlendMode.equals((Object)oldBlendMode);
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._oldBlendMode = oldBlendMode;
        this._newBlendMode = newBlendMode;
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyBlendMode(this._newBlendMode, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyBlendMode(this._oldBlendMode, project, pm);
        return Status.OK_STATUS;
    }

    private void modifyBlendMode(BlendMode blendMode, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        MediaLayer layer = (MediaLayer)comp.getLayer(this._layerId);
        layer.setBlendMode(blendMode);
        if (pm != null) {
            pm.fireLayerPropertyChange((Layer)layer, "blendMode");
        }
    }
}

