/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ModifyLayerExpressionOperation
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final String _property;
    private final String _oldExpr;
    private final String _newExpr;

    public ModifyLayerExpressionOperation(ProjectManager projectManager, Layer layer, String property, String expression) {
        super(projectManager, "\u30a8\u30af\u30b9\u30d7\u30ec\u30c3\u30b7\u30e7\u30f3\u306e\u5909\u66f4");
        LayerComposition comp = projectManager.checkLayer(layer);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
        String old = avalue.getExpression();
        if (expression != null && (expression = expression.trim()).length() == 0) {
            expression = null;
        }
        this._noEffect = expression != null && expression.equals(old) || expression == null && old == null;
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._property = property;
        this._oldExpr = old;
        this._newExpr = expression;
        if (this._oldExpr == null) {
            this.setLabel("\u30a8\u30af\u30b9\u30d7\u30ec\u30c3\u30b7\u30e7\u30f3\u306e\u8ffd\u52a0");
        } else if (this._newExpr == null) {
            this.setLabel("\u30a8\u30af\u30b9\u30d7\u30ec\u30c3\u30b7\u30e7\u30f3\u306e\u524a\u9664");
        }
    }

    String getLayerId() {
        return this._layerId;
    }

    String getProperty() {
        return this._property;
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyExpression(this._newExpr, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyExpression(this._oldExpr, project, pm);
        return Status.OK_STATUS;
    }

    private void modifyExpression(String expression, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Layer layer = comp.getLayer(this._layerId);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, this._property);
        avalue.setExpression(expression);
        if (pm != null) {
            pm.fireLayerExpressionChange(layer, this._property);
        }
    }
}

