/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NewFolderOperation
extends ProjectOperation {
    private final String _folderId;
    private final String _data;
    @Inject
    private ProjectElementFactory _elementFactory;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public NewFolderOperation(ProjectManager projectManager, Folder parent, String name) {
        super(projectManager, "\u65b0\u898f\u30d5\u30a9\u30eb\u30c0");
        projectManager.checkItem((Item)parent);
        InjectorHolder.getInjector().injectMembers((Object)this);
        Folder folder = this._elementFactory.newFolder();
        folder.setName(name);
        folder.setParent(parent);
        this._folderId = folder.getId();
        this._data = this._encoder.encodeElement((Object)folder);
    }

    public NewFolderOperation(ProjectManager projectManager, Folder parent) {
        this(projectManager, parent, projectManager.getUnusedItemName("\u540d\u79f0\u672a\u8a2d\u5b9a"));
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        Folder folder = null;
        try {
            folder = (Folder)this._decoder.decodeElement((CharSequence)this._data, Folder.class);
            folder.afterDecode(project);
        }
        catch (ProjectDecodeException e) {
            if (folder != null) {
                folder.dispose();
            }
            throw new ExecutionException("error decoding folder data", (Throwable)e);
        }
        project.getItems().add(folder);
        if (pm != null) {
            this.fireItemsAdd(folder, pm);
        }
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        Folder folder = (Folder)project.getItem(this._folderId);
        project.getItems().remove(folder);
        if (pm != null) {
            this.fireItemsRemove(folder, pm);
        }
        folder.dispose();
        return Status.OK_STATUS;
    }

    private void fireItemsAdd(Folder folder, ProjectManager pm) {
        Folder parent = folder.getParent();
        if (parent != null) {
            pm.fireItemsAdd(Collections.singleton(folder), Collections.singleton(parent));
        } else {
            pm.fireItemsAdd(Collections.singleton(folder), null);
        }
    }

    private void fireItemsRemove(Folder folder, ProjectManager pm) {
        Folder parent = folder.getParent();
        if (parent != null) {
            pm.fireItemsRemove(Collections.singleton(folder), Collections.singleton(parent));
        } else {
            pm.fireItemsRemove(Collections.singleton(folder), null);
        }
    }

    public String getFolderId() {
        return this._folderId;
    }
}

