/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NewLayerCompositionOperation
extends ProjectOperation {
    private final String _compId;
    private final String _itemId;
    private final String _data;
    @Inject
    private ProjectElementFactory _elementFactory;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public NewLayerCompositionOperation(ProjectManager projectManager, Folder parent, String name, int width, int height, Time frameDuration, Time duration, ColorMode colorMode) {
        super(projectManager, "\u65b0\u898f\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3");
        projectManager.checkItem((Item)parent);
        InjectorHolder.getInjector().injectMembers((Object)this);
        LayerComposition comp = this._elementFactory.newLayerComposition(colorMode, new Size2i(width, height), frameDuration, duration);
        CompositionItem item = this._elementFactory.newCompositionItem((Composition)comp);
        item.setName(name);
        item.setParent(parent);
        this._compId = comp.getId();
        this._itemId = item.getId();
        this._data = this._encoder.encodeElement((Object)new Object[]{comp, item});
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = null;
        CompositionItem item = null;
        try {
            Object[] elements = (Object[])this._decoder.decodeElement((CharSequence)this._data, Object[].class);
            comp = (LayerComposition)elements[0];
            item = (CompositionItem)elements[1];
            project.getCompositions().add(comp);
            project.getItems().add(item);
            comp.afterDecode(project);
            item.afterDecode(project);
        }
        catch (ProjectDecodeException e) {
            this.cleanup(project, (Composition)comp, (Item)item);
            throw new ExecutionException("error decoding SolidColorItem data", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.cleanup(project, (Composition)comp, (Item)item);
            throw e;
        }
        if (pm != null) {
            this.fireItemsAdd((Item)item, pm);
        }
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        Item item = project.getItem(this._itemId);
        Composition comp = project.getComposition(this._compId);
        project.getItems().remove(item);
        project.getCompositions().remove(comp);
        if (pm != null) {
            this.fireItemsRemove(item, pm);
        }
        item.dispose();
        return Status.OK_STATUS;
    }

    private void fireItemsAdd(Item item, ProjectManager pm) {
        Folder parent = item.getParent();
        if (parent != null) {
            pm.fireItemsAdd(Collections.singleton(item), Collections.singleton(parent));
        } else {
            pm.fireItemsAdd(Collections.singleton(item), null);
        }
    }

    private void fireItemsRemove(Item item, ProjectManager pm) {
        Folder parent = item.getParent();
        if (parent != null) {
            pm.fireItemsRemove(Collections.singleton(item), Collections.singleton(parent));
        } else {
            pm.fireItemsRemove(Collections.singleton(item), null);
        }
    }

    private void cleanup(Project project, Composition comp, Item item) {
        project.getCompositions().remove(comp);
        project.getItems().remove(item);
        if (item != null) {
            item.dispose();
        }
    }

    public String getCompositionItemId() {
        return this._itemId;
    }
}

