/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RenameItemOperation
extends ProjectOperation {
    private final String _itemId;
    private final String _newName;
    private final String _oldName;
    private final Set<String> _layerIds = Util.newSet();

    public RenameItemOperation(ProjectManager projectManager, Item item, String newName) {
        super(projectManager, "\u540d\u524d\u306e\u5909\u66f4");
        newName = newName.replaceAll("[\\r\\n]+", "");
        this._noEffect = newName.length() == 0 || newName.equals(item.getName());
        this._itemId = item.getId();
        this._newName = newName;
        this._oldName = item.getName();
        for (Composition comp : projectManager.getProject().getCompositions()) {
            if (!(comp instanceof LayerComposition)) continue;
            for (Layer layer : ((LayerComposition)comp).getLayers()) {
                ItemLayer itemLayer;
                if (!(layer instanceof ItemLayer) || (itemLayer = (ItemLayer)layer).getItem() != item || !itemLayer.getName().equals(this._oldName)) continue;
                this._layerIds.add(itemLayer.getId());
            }
        }
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setName(this._newName, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setName(this._oldName, project, pm);
        return Status.OK_STATUS;
    }

    private void setName(String name, Project project, ProjectManager pm) {
        Item item = project.getItem(this._itemId);
        item.setName(name);
        for (Composition comp : project.getCompositions()) {
            if (!(comp instanceof LayerComposition)) continue;
            for (Layer layer : ((LayerComposition)comp).getLayers()) {
                if (!this._layerIds.contains(layer.getId())) continue;
                layer.setName(name);
            }
        }
        if (pm != null) {
            pm.fireItemNameChange(item);
        }
    }
}

