/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.ComboBoxViewerCellEditor;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.core.AnimatableEnum;
import ch.kuramo.javie.core.JavieRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableEnumElementDelegate<E extends Enum<E>>
extends AnimatableValueElementDelegate<E> {
    private final Class<E> enumType;
    private final E[] values;
    private final String[] texts;
    private ComboBoxViewerCellEditor editor;

    public AnimatableEnumElementDelegate(AnimatableValueElement element, String name, AnimatableEnum<E> avalue) {
        super(element, name, avalue);
        this.enumType = avalue.getEnumType();
        this.values = this.values();
        this.texts = this.texts();
    }

    @Override
    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        this.drawValue(gc, x, y, height, focused, this.texts[((Enum)this.value).ordinal()]);
    }

    @Override
    protected boolean canDragGestureEdit() {
        return false;
    }

    @Override
    protected E dragGesture(double dx, double dy) {
        throw new UnsupportedOperationException("drag gesture edit is not supported");
    }

    @Override
    public boolean canEdit(int columnIndex) {
        if (columnIndex == 1) {
            return this.canInlineEdit;
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new ComboBoxViewerCellEditor((Composite)this.element.viewer.getTree(), 8);
                this.editor.setContenProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                this.editor.setActivationStyle(4);
                ((Combo)this.editor.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AnimatableEnumElementDelegate.this.setCellEditorValue(1, AnimatableEnumElementDelegate.this.editor.getValue());
                    }
                });
            }
            this.editor.setInput(null);
            this.editor.setLabelProvider((IBaseLabelProvider)new EnumLabelProvider());
            this.editor.setInput(this.values());
            return this.editor;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        if (columnIndex == 1) {
            return this.value;
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        if (columnIndex == 1) {
            this.modifyValue((Enum)this.enumType.cast(value));
        }
    }

    private E[] values() {
        try {
            Enum[] values = (Enum[])this.enumType.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            return values;
        }
        catch (IllegalAccessException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    private String[] texts() {
        ResourceBundle bundle;
        String[] texts = new String[this.values.length];
        int i = 0;
        while (i < this.values.length) {
            texts[i] = String.valueOf('!') + ((Enum)this.values[i]).name() + '!';
            ++i;
        }
        try {
            bundle = ResourceBundle.getBundle(String.valueOf(this.enumType.getPackage().getName()) + ".messages", Locale.getDefault(), this.enumType.getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            return texts;
        }
        int i2 = 0;
        while (i2 < this.values.length) {
            try {
                texts[i2] = bundle.getString(String.format("%s.%s", this.enumType.getSimpleName(), ((Enum)this.values[i2]).name()));
            }
            catch (MissingResourceException missingResourceException) {}
            ++i2;
        }
        return texts;
    }

    private class EnumLabelProvider
    extends LabelProvider {
        private EnumLabelProvider() {
        }

        public String getText(Object element) {
            return AnimatableEnumElementDelegate.this.texts[((Enum)AnimatableEnumElementDelegate.this.enumType.cast(element)).ordinal()];
        }
    }
}

