/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.Grego;
import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.ZoneMeta;
import com.ibm.icu.util.BasicTimeZone;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.InitialTimeZoneRule;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeArrayTimeZoneRule;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.TimeZoneRule;
import com.ibm.icu.util.TimeZoneTransition;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.Arrays;
import java.util.Date;

public class OlsonTimeZone
extends BasicTimeZone {
    static final long serialVersionUID = -6281977362477515376L;
    private static final boolean ASSERT = false;
    private static final int UNSIGNED_BYTE_MASK = 255;
    private int transitionCount;
    private int typeCount;
    private int[] transitionTimes;
    private int[] typeOffsets;
    private byte[] typeData;
    private int finalYear = Integer.MAX_VALUE;
    private double finalMillis = Double.MAX_VALUE;
    private SimpleTimeZone finalZone = null;
    private static final boolean DEBUG = ICUDebug.enabled("olson");
    private static final int SECONDS_PER_DAY = 86400;
    private transient InitialTimeZoneRule initialRule;
    private transient TimeZoneTransition firstTZTransition;
    private transient int firstTZTransitionIdx;
    private transient TimeZoneTransition firstFinalTZTransition;
    private transient TimeArrayTimeZoneRule[] historicRules;
    private transient SimpleTimeZone finalZoneWithStartYear;
    private transient boolean transitionRulesInitialized;

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Month is not in the legal range: " + month);
        }
        return this.getOffset(era, year, month, day, dayOfWeek, milliseconds, Grego.monthLength(year, month));
    }

    public int getOffset(int era, int year, int month, int dom, int dow, int millis, int monthLength) {
        if (era != 1 && era != 0 || month < 0 || month > 11 || dom < 1 || dom > monthLength || dow < 1 || dow > 7 || millis < 0 || millis >= 86400000 || monthLength < 28 || monthLength > 31) {
            throw new IllegalArgumentException();
        }
        if (era == 0) {
            year = -year;
        }
        if (year > this.finalYear) {
            return this.finalZone.getOffset(era, year, month, dom, dow, millis);
        }
        long time = Grego.fieldsToDay(year, month, dom) * 86400000L + (long)millis;
        int[] offsets = new int[2];
        this.getHistoricalOffset(time, true, 3, 1, offsets);
        return offsets[0] + offsets[1];
    }

    public void setRawOffset(int offsetMillis) {
        if (this.getRawOffset() == offsetMillis) {
            return;
        }
        GregorianCalendar cal = new GregorianCalendar(ULocale.ROOT);
        cal.setTimeZone(this);
        int tmpFinalYear = cal.get(1) - 1;
        if (this.finalYear > tmpFinalYear) {
            this.finalYear = tmpFinalYear;
            this.finalMillis = Grego.fieldsToDay(tmpFinalYear, 0, 1) * 86400000L;
        }
        if (this.finalZone == null) {
            this.finalZone = new SimpleTimeZone(offsetMillis, this.getID());
        } else {
            this.finalZone.setRawOffset(offsetMillis);
            this.finalZone.setStartYear(this.finalYear);
        }
        this.transitionRulesInitialized = false;
    }

    public Object clone() {
        OlsonTimeZone other = (OlsonTimeZone)super.clone();
        if (this.finalZone != null) {
            this.finalZone.setID(this.getID());
            other.finalZone = (SimpleTimeZone)this.finalZone.clone();
        }
        other.transitionTimes = (int[])this.transitionTimes.clone();
        other.typeData = (byte[])this.typeData.clone();
        other.typeOffsets = (int[])this.typeOffsets.clone();
        return other;
    }

    public void getOffset(long date, boolean local, int[] offsets) {
        if ((double)date >= this.finalMillis && this.finalZone != null) {
            this.finalZone.getOffset(date, local, offsets);
        } else {
            this.getHistoricalOffset(date, local, 4, 12, offsets);
        }
    }

    public void getOffsetFromLocal(long date, int nonExistingTimeOpt, int duplicatedTimeOpt, int[] offsets) {
        if ((double)date >= this.finalMillis && this.finalZone != null) {
            this.finalZone.getOffsetFromLocal(date, nonExistingTimeOpt, duplicatedTimeOpt, offsets);
        } else {
            this.getHistoricalOffset(date, true, nonExistingTimeOpt, duplicatedTimeOpt, offsets);
        }
    }

    public int getRawOffset() {
        int[] ret = new int[2];
        this.getOffset(System.currentTimeMillis(), false, ret);
        return ret[0];
    }

    public boolean useDaylightTime() {
        int[] fields = Grego.timeToFields(System.currentTimeMillis(), null);
        int year = fields[0];
        if (year > this.finalYear) {
            return this.finalZone != null && this.finalZone.useDaylightTime();
        }
        long start = Grego.fieldsToDay(year, 0, 1) * 86400L;
        long limit = Grego.fieldsToDay(year + 1, 0, 1) * 86400L;
        int i = 0;
        while (i < this.transitionCount) {
            if ((long)this.transitionTimes[i] >= limit) break;
            if ((long)this.transitionTimes[i] >= start && this.dstOffset(this.typeData[i]) != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getDSTSavings() {
        if (this.finalZone != null) {
            return this.finalZone.getDSTSavings();
        }
        return super.getDSTSavings();
    }

    public boolean inDaylightTime(Date date) {
        int[] temp = new int[2];
        this.getOffset(date.getTime(), false, temp);
        return temp[1] != 0;
    }

    public boolean hasSameRules(TimeZone other) {
        if (!super.hasSameRules(other)) {
            return false;
        }
        if (!(other instanceof OlsonTimeZone)) {
            return false;
        }
        OlsonTimeZone o = (OlsonTimeZone)other;
        if (this.finalZone == null ? o.finalZone != null && this.finalYear != Integer.MAX_VALUE : o.finalZone == null || this.finalYear != o.finalYear || !this.finalZone.hasSameRules(o.finalZone)) {
            return false;
        }
        return this.transitionCount == o.transitionCount && Arrays.equals(this.transitionTimes, o.transitionTimes) && this.typeCount == o.typeCount && Arrays.equals(this.typeData, o.typeData) && Arrays.equals(this.typeOffsets, o.typeOffsets);
    }

    private void constructEmpty() {
        this.transitionCount = 0;
        this.typeCount = 1;
        this.typeOffsets = new int[2];
        this.transitionTimes = this.typeOffsets;
        this.typeData = new byte[2];
    }

    public OlsonTimeZone(UResourceBundle top, UResourceBundle res) {
        this.construct(top, res);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void construct(UResourceBundle top, UResourceBundle res) {
        int size;
        if (top == null || res == null) {
            throw new IllegalArgumentException();
        }
        if (DEBUG) {
            System.out.println("OlsonTimeZone(" + res.getKey() + ")");
        }
        if ((size = res.getSize()) < 3 || size > 6) {
            throw new IllegalArgumentException("Invalid Format");
        }
        UResourceBundle r = res.get(0);
        this.transitionTimes = r.getIntVector();
        if (this.transitionTimes.length < 0 || this.transitionTimes.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid Format");
        }
        this.transitionCount = this.transitionTimes.length;
        r = res.get(1);
        this.typeOffsets = r.getIntVector();
        if (this.typeOffsets.length < 2 || this.typeOffsets.length > 32766 || (this.typeOffsets.length & 1) != 0) {
            throw new IllegalArgumentException("Invalid Format");
        }
        this.typeCount = this.typeOffsets.length >> 1;
        r = res.get(2);
        this.typeData = r.getBinary().array();
        if (this.typeData.length != this.transitionCount) {
            throw new IllegalArgumentException("Invalid Format");
        }
        if (size < 5) return;
        String ruleid = res.getString(3);
        r = res.get(4);
        int[] data = r.getIntVector();
        if (data == null || data.length != 2) throw new IllegalArgumentException("Invalid Format");
        int rawOffset = data[0] * 1000;
        this.finalYear = data[1] - 1;
        this.finalMillis = Grego.fieldsToDay(data[1], 0, 1) * 86400000L;
        r = OlsonTimeZone.loadRule(top, ruleid);
        data = r.getIntVector();
        if (data.length != 11) throw new IllegalArgumentException("Invalid Format");
        this.finalZone = new SimpleTimeZone(rawOffset, "", data[0], data[1], data[2], data[3] * 1000, data[4], data[5], data[6], data[7], data[8] * 1000, data[9], data[10] * 1000);
    }

    public OlsonTimeZone() {
        this.constructEmpty();
    }

    public OlsonTimeZone(String id) {
        UResourceBundle top = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt40b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle res = ZoneMeta.openOlsonResource(id);
        this.construct(top, res);
        if (this.finalZone != null) {
            this.finalZone.setID(id);
        }
        super.setID(id);
    }

    public void setID(String id) {
        if (this.finalZone != null) {
            this.finalZone.setID(id);
        }
        super.setID(id);
        this.transitionRulesInitialized = false;
    }

    private int getInt(byte val) {
        return 0xFF & val;
    }

    private void getHistoricalOffset(long date, boolean local, int NonExistingTimeOpt, int DuplicatedTimeOpt, int[] offsets) {
        if (this.transitionCount != 0) {
            long sec = OlsonTimeZone.myFloorDivide(date, 1000L);
            int i = 0;
            i = this.transitionCount - 1;
            while (i > 0) {
                int transition = this.transitionTimes[i];
                if (local) {
                    boolean stdToDst;
                    int offsetBefore = this.zoneOffset(this.getInt(this.typeData[i - 1]));
                    boolean dstBefore = this.dstOffset(this.getInt(this.typeData[i - 1])) != 0;
                    int offsetAfter = this.zoneOffset(this.getInt(this.typeData[i]));
                    boolean dstAfter = this.dstOffset(this.getInt(this.typeData[i])) != 0;
                    boolean dstToStd = dstBefore && !dstAfter;
                    boolean bl = stdToDst = !dstBefore && dstAfter;
                    transition = offsetAfter - offsetBefore >= 0 ? ((NonExistingTimeOpt & 3) == 1 && dstToStd || (NonExistingTimeOpt & 3) == 3 && stdToDst ? (transition += offsetBefore) : ((NonExistingTimeOpt & 3) == 1 && stdToDst || (NonExistingTimeOpt & 3) == 3 && dstToStd ? (transition += offsetAfter) : ((NonExistingTimeOpt & 0xC) == 12 ? (transition += offsetBefore) : (transition += offsetAfter)))) : ((DuplicatedTimeOpt & 3) == 1 && dstToStd || (DuplicatedTimeOpt & 3) == 3 && stdToDst ? (transition += offsetAfter) : ((DuplicatedTimeOpt & 3) == 1 && stdToDst || (DuplicatedTimeOpt & 3) == 3 && dstToStd ? (transition += offsetBefore) : ((DuplicatedTimeOpt & 0xC) == 4 ? (transition += offsetBefore) : (transition += offsetAfter))));
                }
                if (sec >= (long)transition) break;
                --i;
            }
            int index = this.getInt(this.typeData[i]);
            offsets[0] = this.rawOffset(index) * 1000;
            offsets[1] = this.dstOffset(index) * 1000;
        } else {
            offsets[0] = this.rawOffset(0) * 1000;
            offsets[1] = this.dstOffset(0) * 1000;
        }
    }

    private int zoneOffset(int index) {
        return this.typeOffsets[index <<= 1] + this.typeOffsets[index + 1];
    }

    private int rawOffset(int index) {
        return this.typeOffsets[index << 1];
    }

    private int dstOffset(int index) {
        return this.typeOffsets[(index << 1) + 1];
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('[');
        buf.append("transitionCount=" + this.transitionCount);
        buf.append(",typeCount=" + this.typeCount);
        buf.append(",transitionTimes=");
        if (this.transitionTimes != null) {
            buf.append('[');
            i = 0;
            while (i < this.transitionTimes.length) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(Integer.toString(this.transitionTimes[i]));
                ++i;
            }
            buf.append(']');
        } else {
            buf.append("null");
        }
        buf.append(",typeOffsets=");
        if (this.typeOffsets != null) {
            buf.append('[');
            i = 0;
            while (i < this.typeOffsets.length) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(Integer.toString(this.typeOffsets[i]));
                ++i;
            }
            buf.append(']');
        } else {
            buf.append("null");
        }
        buf.append(",finalYear=" + this.finalYear);
        buf.append(",finalMillis=" + this.finalMillis);
        buf.append(",finalZone=" + this.finalZone);
        buf.append(']');
        return buf.toString();
    }

    private static UResourceBundle loadRule(UResourceBundle top, String ruleid) {
        UResourceBundle r = top.get("Rules");
        r = r.get(ruleid);
        return r;
    }

    private static final long myFloorDivide(long numerator, long denominator) {
        return numerator >= 0L ? numerator / denominator : (numerator + 1L) / denominator - 1L;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        OlsonTimeZone z = (OlsonTimeZone)obj;
        return Utility.arrayEquals(this.typeData, (Object)z.typeData) || this.finalYear == z.finalYear && (this.finalZone == null && z.finalZone == null || this.finalZone != null && z.finalZone != null && this.finalZone.equals(z.finalZone) && this.transitionCount == z.transitionCount && this.typeCount == z.typeCount && Utility.arrayEquals(this.transitionTimes, (Object)z.transitionTimes) && Utility.arrayEquals(this.typeOffsets, (Object)z.typeOffsets) && Utility.arrayEquals(this.typeData, (Object)z.typeData));
    }

    public int hashCode() {
        int ret = (int)((long)(this.finalYear ^ (this.finalYear >>> 4) + this.transitionCount ^ (this.transitionCount >>> 6) + this.typeCount) ^ (long)(this.typeCount >>> 8) + Double.doubleToLongBits(this.finalMillis) + (long)(this.finalZone == null ? 0 : this.finalZone.hashCode()) + (long)super.hashCode());
        int i = 0;
        while (i < this.transitionTimes.length) {
            ret += this.transitionTimes[i] ^ this.transitionTimes[i] >>> 8;
            ++i;
        }
        i = 0;
        while (i < this.typeOffsets.length) {
            ret += this.typeOffsets[i] ^ this.typeOffsets[i] >>> 8;
            ++i;
        }
        i = 0;
        while (i < this.typeData.length) {
            ret += this.typeData[i] & 0xFF;
            ++i;
        }
        return ret;
    }

    public TimeZoneTransition getNextTransition(long base, boolean inclusive) {
        this.initTransitionRules();
        if (this.finalZone != null) {
            if (inclusive && base == this.firstFinalTZTransition.getTime()) {
                return this.firstFinalTZTransition;
            }
            if (base >= this.firstFinalTZTransition.getTime()) {
                if (this.finalZone.useDaylightTime()) {
                    return this.finalZoneWithStartYear.getNextTransition(base, inclusive);
                }
                return null;
            }
        }
        if (this.historicRules != null) {
            int ttidx = this.transitionCount - 1;
            while (ttidx >= this.firstTZTransitionIdx) {
                long t = (long)this.transitionTimes[ttidx] * 1000L;
                if (base > t || !inclusive && base == t) break;
                --ttidx;
            }
            if (ttidx == this.transitionCount - 1) {
                return this.firstFinalTZTransition;
            }
            if (ttidx < this.firstTZTransitionIdx) {
                return this.firstTZTransition;
            }
            TimeArrayTimeZoneRule to = this.historicRules[this.getInt(this.typeData[ttidx + 1])];
            TimeArrayTimeZoneRule from = this.historicRules[this.getInt(this.typeData[ttidx])];
            long startTime = (long)this.transitionTimes[ttidx + 1] * 1000L;
            if (from.getName().equals(to.getName()) && from.getRawOffset() == to.getRawOffset() && from.getDSTSavings() == to.getDSTSavings()) {
                return this.getNextTransition(startTime, false);
            }
            return new TimeZoneTransition(startTime, from, to);
        }
        return null;
    }

    public TimeZoneTransition getPreviousTransition(long base, boolean inclusive) {
        this.initTransitionRules();
        if (this.finalZone != null) {
            if (inclusive && base == this.firstFinalTZTransition.getTime()) {
                return this.firstFinalTZTransition;
            }
            if (base > this.firstFinalTZTransition.getTime()) {
                if (this.finalZone.useDaylightTime()) {
                    return this.finalZoneWithStartYear.getPreviousTransition(base, inclusive);
                }
                return this.firstFinalTZTransition;
            }
        }
        if (this.historicRules != null) {
            int ttidx = this.transitionCount - 1;
            while (ttidx >= this.firstTZTransitionIdx) {
                long t = (long)this.transitionTimes[ttidx] * 1000L;
                if (base > t || inclusive && base == t) break;
                --ttidx;
            }
            if (ttidx < this.firstTZTransitionIdx) {
                return null;
            }
            if (ttidx == this.firstTZTransitionIdx) {
                return this.firstTZTransition;
            }
            TimeArrayTimeZoneRule to = this.historicRules[this.getInt(this.typeData[ttidx])];
            TimeArrayTimeZoneRule from = this.historicRules[this.getInt(this.typeData[ttidx - 1])];
            long startTime = (long)this.transitionTimes[ttidx] * 1000L;
            if (from.getName().equals(to.getName()) && from.getRawOffset() == to.getRawOffset() && from.getDSTSavings() == to.getDSTSavings()) {
                return this.getPreviousTransition(startTime, false);
            }
            return new TimeZoneTransition(startTime, from, to);
        }
        return null;
    }

    public TimeZoneRule[] getTimeZoneRules() {
        this.initTransitionRules();
        int size = 1;
        if (this.historicRules != null) {
            int i = 0;
            while (i < this.historicRules.length) {
                if (this.historicRules[i] != null) {
                    ++size;
                }
                ++i;
            }
        }
        if (this.finalZone != null) {
            size = this.finalZone.useDaylightTime() ? (size += 2) : ++size;
        }
        TimeZoneRule[] rules = new TimeZoneRule[size];
        int idx = 0;
        rules[idx++] = this.initialRule;
        if (this.historicRules != null) {
            int i = 0;
            while (i < this.historicRules.length) {
                if (this.historicRules[i] != null) {
                    rules[idx++] = this.historicRules[i];
                }
                ++i;
            }
        }
        if (this.finalZone != null) {
            if (this.finalZone.useDaylightTime()) {
                TimeZoneRule[] stzr = this.finalZoneWithStartYear.getTimeZoneRules();
                rules[idx++] = stzr[1];
                rules[idx++] = stzr[2];
            } else {
                rules[idx++] = new TimeArrayTimeZoneRule(String.valueOf(this.getID()) + "(STD)", this.finalZone.getRawOffset(), 0, new long[]{(long)this.finalMillis}, 2);
            }
        }
        return rules;
    }

    private synchronized void initTransitionRules() {
        int dst;
        int raw;
        if (this.transitionRulesInitialized) {
            return;
        }
        this.initialRule = null;
        this.firstTZTransition = null;
        this.firstFinalTZTransition = null;
        this.historicRules = null;
        this.firstTZTransitionIdx = 0;
        this.finalZoneWithStartYear = null;
        String stdName = String.valueOf(this.getID()) + "(STD)";
        String dstName = String.valueOf(this.getID()) + "(DST)";
        if (this.transitionCount > 0) {
            int typeIdx = this.getInt(this.typeData[0]);
            raw = this.typeOffsets[typeIdx * 2] * 1000;
            dst = this.typeOffsets[typeIdx * 2 + 1] * 1000;
            this.initialRule = new InitialTimeZoneRule(dst == 0 ? stdName : dstName, raw, dst);
            int transitionIdx = 1;
            while (transitionIdx < this.transitionCount) {
                ++this.firstTZTransitionIdx;
                if (typeIdx != this.getInt(this.typeData[transitionIdx])) break;
                ++transitionIdx;
            }
            if (transitionIdx != this.transitionCount) {
                long[] times = new long[this.transitionCount];
                typeIdx = 0;
                while (typeIdx < this.typeCount) {
                    int nTimes = 0;
                    transitionIdx = this.firstTZTransitionIdx;
                    while (transitionIdx < this.transitionCount) {
                        long tt;
                        if (typeIdx == this.getInt(this.typeData[transitionIdx]) && (double)(tt = (long)this.transitionTimes[transitionIdx] * 1000L) < this.finalMillis) {
                            times[nTimes++] = tt;
                        }
                        ++transitionIdx;
                    }
                    if (nTimes > 0) {
                        long[] startTimes = new long[nTimes];
                        System.arraycopy(times, 0, startTimes, 0, nTimes);
                        raw = this.typeOffsets[typeIdx * 2] * 1000;
                        dst = this.typeOffsets[typeIdx * 2 + 1] * 1000;
                        if (this.historicRules == null) {
                            this.historicRules = new TimeArrayTimeZoneRule[this.typeCount];
                        }
                        this.historicRules[typeIdx] = new TimeArrayTimeZoneRule(dst == 0 ? stdName : dstName, raw, dst, startTimes, 2);
                    }
                    ++typeIdx;
                }
                typeIdx = this.getInt(this.typeData[this.firstTZTransitionIdx]);
                this.firstTZTransition = new TimeZoneTransition((long)this.transitionTimes[this.firstTZTransitionIdx] * 1000L, this.initialRule, this.historicRules[typeIdx]);
            }
        }
        if (this.initialRule == null) {
            raw = this.typeOffsets[0] * 1000;
            dst = this.typeOffsets[1] * 1000;
            this.initialRule = new InitialTimeZoneRule(dst == 0 ? stdName : dstName, raw, dst);
        }
        if (this.finalZone != null) {
            TimeZoneRule firstFinalRule;
            long startTime = (long)this.finalMillis;
            if (this.finalZone.useDaylightTime()) {
                this.finalZoneWithStartYear = (SimpleTimeZone)this.finalZone.clone();
                this.finalZoneWithStartYear.setStartYear(this.finalYear + 1);
                TimeZoneTransition tzt = this.finalZoneWithStartYear.getNextTransition(startTime, false);
                firstFinalRule = tzt.getTo();
                startTime = tzt.getTime();
            } else {
                this.finalZoneWithStartYear = this.finalZone;
                firstFinalRule = new TimeArrayTimeZoneRule(this.finalZone.getID(), this.finalZone.getRawOffset(), 0, new long[]{startTime}, 2);
            }
            TimeZoneRule prevRule = null;
            if (this.transitionCount > 0) {
                prevRule = this.historicRules[this.getInt(this.typeData[this.transitionCount - 1])];
            }
            if (prevRule == null) {
                prevRule = this.initialRule;
            }
            this.firstFinalTZTransition = new TimeZoneTransition(startTime, prevRule, firstFinalRule);
        }
        this.transitionRulesInitialized = true;
    }
}

