/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime.auth;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.runtime.auth.Activator;
import org.eclipse.core.internal.runtime.auth.AuthorizationDatabase;
import org.eclipse.core.internal.runtime.auth.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AuthorizationHandler {
    static final String F_KEYRING = ".keyring";
    private static AuthorizationDatabase keyring = null;
    private static long keyringTimeStamp;
    private static String keyringFile;
    private static String password;
    static /* synthetic */ Class class$0;

    static {
        keyringFile = null;
        password = "";
    }

    private static void loadKeyring() throws CoreException {
        if (keyring != null && new File(keyringFile).lastModified() == keyringTimeStamp) {
            return;
        }
        if (keyringFile == null) {
            ServiceReference[] refs = null;
            try {
                BundleContext bundleContext = Activator.getContext();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((refs = bundleContext.getServiceReferences(clazz.getName(), Location.CONFIGURATION_FILTER)) == null || refs.length == 0) {
                    return;
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                return;
            }
            Location configurationLocation = (Location)Activator.getContext().getService(refs[0]);
            if (configurationLocation == null) {
                return;
            }
            File file = new File(String.valueOf(configurationLocation.getURL().getPath()) + "/org.eclipse.core.runtime");
            Activator.getContext().ungetService(refs[0]);
            file = new File(file, F_KEYRING);
            keyringFile = file.getAbsolutePath();
        }
        try {
            keyring = new AuthorizationDatabase(keyringFile, password);
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
        if (keyring == null) {
            new File(keyringFile).delete();
            keyring = new AuthorizationDatabase(keyringFile, password);
        }
        keyringTimeStamp = new File(keyringFile).lastModified();
    }

    private static void saveKeyring() throws CoreException {
        keyring.save();
        keyringTimeStamp = new File(keyringFile).lastModified();
    }

    public static synchronized void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) throws CoreException {
        AuthorizationHandler.loadKeyring();
        keyring.addAuthorizationInfo(serverUrl, realm, authScheme, new HashMap(info));
        AuthorizationHandler.saveKeyring();
    }

    public static synchronized void addProtectionSpace(URL resourceUrl, String realm) throws CoreException {
        AuthorizationHandler.loadKeyring();
        keyring.addProtectionSpace(resourceUrl, realm);
        AuthorizationHandler.saveKeyring();
    }

    public static synchronized void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        AuthorizationHandler.loadKeyring();
        keyring.flushAuthorizationInfo(serverUrl, realm, authScheme);
        AuthorizationHandler.saveKeyring();
    }

    public static synchronized Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        Map info = null;
        try {
            AuthorizationHandler.loadKeyring();
            info = keyring.getAuthorizationInfo(serverUrl, realm, authScheme);
        }
        catch (CoreException coreException) {}
        return info == null ? null : new HashMap(info);
    }

    public static synchronized String getProtectionSpace(URL resourceUrl) {
        try {
            AuthorizationHandler.loadKeyring();
        }
        catch (CoreException coreException) {
            return null;
        }
        return keyring.getProtectionSpace(resourceUrl);
    }

    public static void setKeyringFile(String file) {
        if (keyringFile != null) {
            throw new IllegalStateException(NLS.bind((String)Messages.meta_keyringFileAlreadySpecified, (Object)keyringFile));
        }
        keyringFile = file;
    }

    public static void setPassword(String keyringPassword) {
        password = keyringPassword;
    }
}

