/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.api;

import ch.kuramo.javie.api.Size2i;

public final class VideoBounds {
    public final double x;
    public final double y;
    public final int width;
    public final int height;

    public VideoBounds(double x, double y, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must be grater than or equal 0");
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public VideoBounds(int width, int height) {
        this(0.0, 0.0, width, height);
    }

    public VideoBounds(Size2i size) {
        this(0.0, 0.0, size.width, size.height);
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VideoBounds other = (VideoBounds)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public String toString() {
        return "VideoBounds [x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

