/*
 * Decompiled with CFR 0.152.
 */
package ca.uol.aig.fftpack;

import ca.uol.aig.fftpack.RealDoubleFFT_Mixed;

public class RealDoubleFFT_Even
extends RealDoubleFFT_Mixed {
    public double norm_factor;
    private double[] wavetable;
    private int ndim;

    public RealDoubleFFT_Even(int n) {
        this.ndim = n;
        this.norm_factor = 2 * (n - 1);
        if (this.wavetable == null || this.wavetable.length != 3 * this.ndim + 15) {
            this.wavetable = new double[3 * this.ndim + 15];
        }
        this.costi(this.ndim, this.wavetable);
    }

    public void ft(double[] x) {
        this.cost(this.ndim, x, this.wavetable);
    }

    public void bt(double[] x) {
        this.cost(this.ndim, x, this.wavetable);
    }

    void cost(int n, double[] x, double[] wtable) {
        int nm1 = n - 1;
        int ns2 = n / 2;
        if (n - 2 < 0) {
            return;
        }
        if (n == 2) {
            double x1h = x[0] + x[1];
            x[1] = x[0] - x[1];
            x[0] = x1h;
        } else if (n == 3) {
            double x1p3 = x[0] + x[2];
            double tx2 = x[1] + x[1];
            x[1] = x[0] - x[2];
            x[0] = x1p3 + tx2;
            x[2] = x1p3 - tx2;
        } else {
            double c1 = x[0] - x[n - 1];
            x[0] = x[0] + x[n - 1];
            int k = 1;
            while (k < ns2) {
                int kc = nm1 - k;
                double t1 = x[k] + x[kc];
                double t2 = x[k] - x[kc];
                c1 += wtable[kc] * t2;
                t2 = wtable[k] * t2;
                x[k] = t1 - t2;
                x[kc] = t1 + t2;
                ++k;
            }
            int modn = n % 2;
            if (modn != 0) {
                int n2 = ns2;
                x[n2] = x[n2] + x[ns2];
            }
            this.rfftf1(nm1, x, wtable, n);
            double xim2 = x[1];
            x[1] = c1;
            int i = 3;
            while (i < n) {
                double xi = x[i];
                x[i] = x[i - 2] - x[i - 1];
                x[i - 1] = xim2;
                xim2 = xi;
                i += 2;
            }
            if (modn != 0) {
                x[n - 1] = xim2;
            }
        }
    }

    void costi(int n, double[] wtable) {
        if (n <= 3) {
            return;
        }
        int ns2 = n / 2;
        double dt = Math.PI / (double)(n - 1);
        int k = 1;
        while (k < ns2) {
            int kc = n - k - 1;
            wtable[k] = 2.0 * Math.sin((double)k * dt);
            wtable[kc] = 2.0 * Math.cos((double)k * dt);
            ++k;
        }
        this.rffti1(n - 1, wtable, n);
    }
}

