/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.effects.Texture1D;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.javie.Grid", category="ch.kuramo.javie.api.effectCategory.generate")
public class Grid {
    @Property
    private IAnimatableVec2d anchor;
    @Property(value="100", min="0", max="4000")
    private IAnimatableVec2d gridSize;
    @Property(value="5", min="0", max="4000")
    private IAnimatableVec2d border;
    @Property(value="0", min="0", max="400")
    private IAnimatableVec2d feather;
    @Property
    private IAnimatableBoolean invert;
    @Property(value="1,1,1")
    private IAnimatableColor color;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlendSupport blendSupport;
    private final IArrayPools arrayPools;
    private final IShaderProgram gridSamplerProgram;
    private final IShaderProgram invertSamplerProgram;
    @ShaderSource
    public static final String[] GRID_SAMPLER = Grid.createSamplerProgram(false);
    @ShaderSource
    public static final String[] INVERT_SAMPLER = Grid.createSamplerProgram(true);

    @Inject
    public Grid(IVideoEffectContext context, IVideoRenderSupport support, IBlendSupport blendSupport, IArrayPools arrayPools, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blendSupport = blendSupport;
        this.arrayPools = arrayPools;
        this.gridSamplerProgram = shaders.getProgram(Grid.class, "GRID_SAMPLER");
        this.invertSamplerProgram = shaders.getProgram(Grid.class, "INVERT_SAMPLER");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer original;
        VideoBounds bounds;
        BlendMode blendMode = (BlendMode)this.context.value(this.blendMode);
        if (blendMode == BlendMode.NONE) {
            bounds = this.context.getPreviousBounds();
            original = this.context.createVideoBuffer(bounds);
        } else {
            original = this.context.doPreviousEffect();
            bounds = original.getBounds();
        }
        if (bounds.isEmpty()) {
            return original;
        }
        GridParams params = null;
        IVideoBuffer grid = null;
        try {
            final GridParams p = params = new GridParams();
            IShaderProgram program = p.invert ? this.invertSamplerProgram : this.gridSamplerProgram;
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texX", 0));
            uniforms.add(new GLUniformData("texY", 1));
            uniforms.add(new GLUniformData("texSize", 4, FloatBuffer.wrap(new float[]{p.texSize[0], p.texSize[1], p.texSize[0], p.texSize[1]})));
            uniforms.add(new GLUniformData("texOffset", 4, FloatBuffer.wrap(new float[]{(float)((((GridParams)p).gridSize.x - ((GridParams)p).border.x - (double)p.texSize[0]) * 0.5), (float)((((GridParams)p).gridSize.y - ((GridParams)p).border.y - (double)p.texSize[1]) * 0.5), (float)((((GridParams)p).gridSize.x + ((GridParams)p).border.x - (double)p.texSize[0]) * 0.5), (float)((((GridParams)p).gridSize.y + ((GridParams)p).border.y - (double)p.texSize[1]) * 0.5)})));
            float gridSizeX = (float)Math.max(((GridParams)p).gridSize.x, 1.0E-10);
            float gridSizeY = (float)Math.max(((GridParams)p).gridSize.y, 1.0E-10);
            uniforms.add(new GLUniformData("gridSize", 4, FloatBuffer.wrap(new float[]{gridSizeX, gridSizeY, gridSizeX, gridSizeY})));
            uniforms.add(new GLUniformData("anchor", 2, FloatBuffer.wrap(new float[]{(float)(((GridParams)p).anchor.x - bounds.x), (float)(((GridParams)p).anchor.y - bounds.y)})));
            uniforms.add(new GLUniformData("color", 4, FloatBuffer.wrap(new float[]{(float)((GridParams)p).color.r, (float)((GridParams)p).color.g, (float)((GridParams)p).color.b, (float)((GridParams)p).color.a})));
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = Grid.this.context.getGL().getGL2();
                    gl.glActiveTexture(33984);
                    gl.glBindTexture(3552, p.texture[0]);
                    gl.glActiveTexture(33985);
                    gl.glBindTexture(3552, p.texture[1]);
                    Grid.this.support.ortho2D(bounds);
                    Grid.this.support.quad2D(bounds, (double[][][])new double[0][][]);
                }
            };
            grid = this.context.createVideoBuffer(bounds);
            this.support.useShaderProgram(program, uniforms, operation, 262144, grid, new IVideoBuffer[0]);
            if (blendMode == BlendMode.NONE && p.opacity == 1.0) {
                IVideoBuffer result = grid;
                grid = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            IVideoBuffer iVideoBuffer = this.blendSupport.blend(grid, original, null, blendMode, p.opacity, this.context);
            return iVideoBuffer;
        }
        finally {
            if (original != null) {
                original.dispose();
            }
            if (grid != null) {
                grid.dispose();
            }
            if (params != null) {
                this.deleteTextures(params.texture);
            }
        }
    }

    private int[] createGridTextures(Vec2d feather, int[] texSize) {
        int[] nArray;
        IArray<float[]> data1;
        int tex1;
        int tex0;
        block9: {
            tex0 = 0;
            tex1 = 0;
            IArray<float[]> data0 = null;
            data1 = null;
            try {
                data0 = this.createGridData(feather.x);
                tex0 = Texture1D.fromArray(data0, this.context);
                texSize[0] = data0.getLength();
                data1 = this.createGridData(feather.y);
                tex1 = Texture1D.fromArray(data1, this.context);
                texSize[1] = data1.getLength();
                int[] result = new int[]{tex0, tex1};
                tex1 = 0;
                tex0 = 0;
                nArray = result;
                if (data0 == null) break block9;
            }
            catch (Throwable throwable) {
                if (data0 != null) {
                    data0.release();
                }
                if (data1 != null) {
                    data1.release();
                }
                if (tex0 != 0) {
                    this.deleteTextures(tex0);
                }
                if (tex1 != 0) {
                    this.deleteTextures(tex1);
                }
                throw throwable;
            }
            data0.release();
        }
        if (data1 != null) {
            data1.release();
        }
        if (tex0 != 0) {
            this.deleteTextures(tex0);
        }
        if (tex1 != 0) {
            this.deleteTextures(tex1);
        }
        return nArray;
    }

    private IArray<float[]> createGridData(double feather) {
        int halfLen = (int)Math.ceil(feather) + 1;
        IArray data = this.arrayPools.getFloatArray(halfLen * 2);
        float[] array = (float[])data.getArray();
        int arrayLen = data.getLength();
        int i = 0;
        while (i < arrayLen) {
            double t = (double)i + 0.5;
            double d = t <= (double)halfLen - feather ? 0.0 : (t >= (double)halfLen + feather ? 1.0 : 0.5 * (1.0 - Math.cos(Math.PI * 2 * (t - ((double)halfLen - feather)) / (4.0 * feather))));
            array[i] = (float)d;
            ++i;
        }
        return data;
    }

    private void deleteTextures(int ... texture) {
        GL2 gl = this.context.getGL().getGL2();
        gl.glDeleteTextures(texture.length, texture, 0);
    }

    private static final String[] createSamplerProgram(boolean invert) {
        return new String[]{"uniform sampler1D texX;", "uniform sampler1D texY;", "uniform vec4 texSize;", "uniform vec4 texOffset;", "uniform vec4 gridSize;", "uniform vec2 anchor;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec2 gridCoord = gl_FragCoord.st - anchor;", "\tgridCoord = gridCoord / gridSize.st + 0.5;", "\tgridCoord -= floor(gridCoord);", "\tgridCoord *= gridSize.st;", "", "\tvec4 texCoord = (vec4(gridCoord, gridCoord) - texOffset) / texSize;", "", "\tvec2 a1 = vec2(texture1D(texX, texCoord.x).a, texture1D(texY, texCoord.y).a);", "\tvec2 a2 = vec2(texture1D(texX, texCoord.z).a, texture1D(texY, texCoord.w).a);", "\tvec2 a = 1.0 - a1*(1.0-a2);", "", invert ? "\tgl_FragColor = color * a.x*a.y;" : "\tgl_FragColor = color * (1.0-a.x*a.y);", "}"};
    }

    private class GridParams {
        private final Vec2d anchor;
        private final Vec2d gridSize;
        private final Vec2d border;
        private final boolean invert;
        private final Color color;
        private final double opacity;
        private final int[] texture;
        private final int[] texSize = new int[2];

        private GridParams() {
            Resolution resolution = Grid.this.context.getVideoResolution();
            this.anchor = resolution.scale((Vec2d)Grid.this.context.value((IAnimatableValue)Grid.this.anchor));
            this.gridSize = resolution.scale((Vec2d)Grid.this.context.value((IAnimatableValue)Grid.this.gridSize));
            this.border = resolution.scale((Vec2d)Grid.this.context.value((IAnimatableValue)Grid.this.border));
            this.invert = (Boolean)Grid.this.context.value((IAnimatableValue)Grid.this.invert);
            this.opacity = (Double)Grid.this.context.value((IAnimatableValue)Grid.this.opacity) / 100.0;
            Color color = (Color)Grid.this.context.value((IAnimatableValue)Grid.this.color);
            double a = color.a;
            this.color = new Color(color.r * a, color.g * a, color.b * a, a);
            Vec2d feather = resolution.scale((Vec2d)Grid.this.context.value((IAnimatableValue)Grid.this.feather));
            this.texture = Grid.this.createGridTextures(feather, this.texSize);
        }
    }
}

