/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IConvolutionSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Mosaic", category="ch.kuramo.javie.api.effectCategory.stylize")
public class Mosaic {
    @ShaderSource
    public static final String[] MOSAIC_SHARP_COLORS = new String[]{"uniform sampler2D texture;", "uniform vec2 blockSize;", "", "void main(void)", "{", "\tgl_FragColor = texture2D(texture, (floor(gl_TexCoord[0].st/blockSize)+0.5)*blockSize);", "}"};
    @Property(value="10", min="1")
    private IAnimatableInteger horizontalBlocks;
    @Property(value="10", min="1")
    private IAnimatableInteger verticalBlocks;
    @Property
    private IAnimatableBoolean sharpColors;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IConvolutionSupport convolution;
    private final IShaderProgram sharpColorsProgram;

    @Inject
    public Mosaic(IVideoEffectContext context, IVideoRenderSupport support, IConvolutionSupport convolution, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.convolution = convolution;
        this.sharpColorsProgram = shaders.getProgram(Mosaic.class, "MOSAIC_SHARP_COLORS");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        int hBlocks = (Integer)this.context.value((IAnimatableValue)this.horizontalBlocks);
        int vBlocks = (Integer)this.context.value((IAnimatableValue)this.verticalBlocks);
        int w = bounds.width;
        int h = bounds.height;
        hBlocks = Math.min(hBlocks, w);
        vBlocks = Math.min(vBlocks, h);
        if (hBlocks == w && vBlocks == h) {
            return input;
        }
        boolean sharpColors = (Boolean)this.context.value((IAnimatableValue)this.sharpColors);
        IVideoBuffer output = null;
        try {
            output = sharpColors ? this.doSharpColorsMosaic(input, hBlocks, vBlocks) : this.doAverageColorsMosaic(input, hBlocks, vBlocks);
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            if (input != output) {
                input.dispose();
            }
        }
    }

    private IVideoBuffer doSharpColorsMosaic(IVideoBuffer input, int hBlocks, int vBlocks) {
        float[] blockSize = new float[]{1.0f / (float)hBlocks, 1.0f / (float)vBlocks};
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("texture", 0));
        uniforms.add(new GLUniformData("blockSize", 2, FloatBuffer.wrap(blockSize)));
        return this.support.useShaderProgram(this.sharpColorsProgram, uniforms, null, new IVideoBuffer[]{input});
    }

    private IVideoBuffer doAverageColorsMosaic(IVideoBuffer input, int hBlocks, int vBlocks) {
        IVideoBuffer.TextureFilter filter = input.getTextureFilter();
        IVideoBuffer buffer = null;
        try {
            buffer = this.context.createVideoBuffer(new VideoBounds(hBlocks, vBlocks));
            this.average(input, buffer);
            this.scale(buffer, input);
            IVideoBuffer iVideoBuffer = input;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
            input.setTextureFilter(filter);
        }
    }

    private void average(IVideoBuffer src, IVideoBuffer dst) {
        IVideoBuffer tmpBuf = null;
        try {
            VideoBounds srcBounds = src.getBounds();
            VideoBounds dstBounds = dst.getBounds();
            int hBlocks = dstBounds.width;
            int vBlocks = dstBounds.height;
            double bwidth = (double)srcBounds.width / (double)hBlocks;
            double bheight = (double)srcBounds.height / (double)vBlocks;
            if (bwidth > 5.0 || bheight > 5.0) {
                tmpBuf = this.context.createVideoBuffer(new VideoBounds(bwidth > 5.0 ? hBlocks * 5 : hBlocks, bheight > 5.0 ? vBlocks * 5 : vBlocks));
                this.average(src, tmpBuf);
                src = tmpBuf;
                srcBounds = src.getBounds();
                bwidth = (double)srcBounds.width / (double)hBlocks;
                bheight = (double)srcBounds.height / (double)vBlocks;
            }
            int kwidth = (int)bwidth;
            int kheight = (int)bheight;
            int ksize = kwidth * kheight;
            float[] kernel = new float[ksize];
            float[] offset = new float[ksize * 2];
            int j = 0;
            while (j < kheight) {
                int i = 0;
                while (i < kwidth) {
                    int k = j * kwidth + i;
                    kernel[k] = 1.0f / (float)ksize;
                    offset[k * 2] = (float)(bwidth * ((0.5 + (double)i) / (double)kwidth - 0.5) / (double)srcBounds.width);
                    offset[k * 2 + 1] = (float)(bheight * ((0.5 + (double)j) / (double)kheight - 0.5) / (double)srcBounds.height);
                    ++i;
                }
                ++j;
            }
            final VideoBounds bounds = dstBounds;
            final double[][] texCoords = new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}};
            Runnable operation = new Runnable(){

                public void run() {
                    Mosaic.this.support.ortho2D(bounds);
                    Mosaic.this.support.quad2D(bounds, (double[][][])new double[][][]{texCoords});
                }
            };
            src.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            this.convolution.convolve(src, dst, kernel, offset, operation, 0);
        }
        finally {
            if (tmpBuf != null) {
                tmpBuf.dispose();
            }
        }
    }

    private void scale(IVideoBuffer src, IVideoBuffer dst) {
        final VideoBounds dstBounds = dst.getBounds();
        final double[][] texCoords = new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}};
        Runnable operation = new Runnable(){

            public void run() {
                Mosaic.this.support.ortho2D(dstBounds);
                Mosaic.this.support.quad2D(dstBounds, (double[][][])new double[][][]{texCoords});
            }
        };
        this.support.useFramebuffer(operation, 0, dst, new IVideoBuffer[]{src});
    }
}

