/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.egl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.egl.EGL;
import com.sun.opengl.impl.egl.EGLGraphicsConfiguration;
import com.sun.opengl.impl.egl._EGLConfig;
import java.io.PrintStream;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.egl.EGLGraphicsDevice;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class EGLGraphicsConfigurationFactory
extends GraphicsConfigurationFactory {
    protected static final boolean DEBUG = GraphicsConfigurationFactory.DEBUG || Debug.debug("EGL");

    public EGLGraphicsConfigurationFactory() {
        GraphicsConfigurationFactory.registerFactory((Class)EGLGraphicsDevice.class, (GraphicsConfigurationFactory)this);
    }

    public AbstractGraphicsConfiguration chooseGraphicsConfiguration(Capabilities capabilities, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (abstractGraphicsScreen == null) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only AbstractGraphicsDevice objects");
        }
        if (capabilities != null && !(capabilities instanceof GLCapabilities)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        return EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilities)capabilities, (GLCapabilitiesChooser)capabilitiesChooser, abstractGraphicsScreen, 4);
    }

    public static EGLGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        int[] nArray;
        _EGLConfig[] _EGLConfigArray;
        if (gLCapabilities == null) {
            gLCapabilities = new GLCapabilities(null);
        }
        GLProfile gLProfile = gLCapabilities.getGLProfile();
        if (null == abstractGraphicsScreen) {
            throw new GLException("Null AbstractGraphicsScreen");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            throw new GLException("GraphicsDevice must be a valid EGLGraphicsDevice");
        }
        long l = abstractGraphicsDevice.getHandle();
        if (l == 0L) {
            throw new GLException("Invalid EGL display: " + abstractGraphicsDevice);
        }
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilities, gLCapabilities, gLCapabilitiesChooser, abstractGraphicsScreen, n);
        if (null != eGLGraphicsConfiguration) {
            return eGLGraphicsConfiguration;
        }
        if (DEBUG) {
            System.err.println("eglChooseConfig failed with given capabilities surfaceType 0x" + Integer.toHexString(n) + ", " + gLCapabilities);
        }
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        if (!EGL.eglGetConfigs(l, _EGLConfigArray = new _EGLConfig[10], _EGLConfigArray.length, nArray = new int[1], 0)) {
            throw new GLException("Graphics configuration fetch (eglGetConfigs) failed");
        }
        if (nArray[0] == 0) {
            throw new GLException("Graphics configuration fetch (eglGetConfigs) - no EGLConfig found");
        }
        Capabilities[] capabilitiesArray = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(gLProfile, l, _EGLConfigArray, nArray[0]);
        if (DEBUG) {
            EGLGraphicsConfigurationFactory.printCaps("eglGetConfigs", (GLCapabilities[])capabilitiesArray, System.err);
        }
        int n2 = -1;
        try {
            n2 = gLCapabilitiesChooser.chooseCapabilities(gLCapabilities, capabilitiesArray, -1);
        }
        catch (NativeWindowException nativeWindowException) {
            throw new GLException(nativeWindowException);
        }
        if (n2 < 0) {
            throw new GLException("Graphics configuration chooser failed");
        }
        if (DEBUG) {
            System.err.println("Choosen " + capabilitiesArray[n2]);
        }
        if (null != (eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(l, (GLCapabilities)capabilitiesArray[n2], gLCapabilities, gLCapabilitiesChooser, abstractGraphicsScreen, n))) {
            return eGLGraphicsConfiguration;
        }
        if (DEBUG) {
            System.err.println("eglChooseConfig failed with eglGetConfig/choosen capabilities surfaceType 0x" + Integer.toHexString(n));
        }
        GLCapabilities gLCapabilities2 = new GLCapabilities(gLProfile);
        gLCapabilities2.setRedBits(5);
        gLCapabilities2.setGreenBits(6);
        gLCapabilities2.setBlueBits(5);
        gLCapabilities2.setDepthBits(16);
        gLCapabilities2.setSampleBuffers(true);
        gLCapabilities2.setNumSamples(4);
        if (DEBUG) {
            System.err.println("trying fixed caps: " + gLCapabilities2);
        }
        if (null == (eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilities2, gLCapabilities, gLCapabilitiesChooser, abstractGraphicsScreen, n))) {
            throw new GLException("Graphics configuration failed [direct caps, eglGetConfig/chooser and fixed-caps]");
        }
        return eGLGraphicsConfiguration;
    }

    protected static EGLGraphicsConfiguration eglChooseConfig(long l, GLCapabilities gLCapabilities, GLCapabilities gLCapabilities2, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        int[] nArray;
        _EGLConfig[] _EGLConfigArray;
        GLProfile gLProfile = gLCapabilities.getGLProfile();
        int[] nArray2 = EGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilities, n);
        if (!EGL.eglChooseConfig(l, nArray2, 0, _EGLConfigArray = new _EGLConfig[10], _EGLConfigArray.length, nArray = new int[1], 0)) {
            throw new GLException("Graphics configuration selection (eglChooseConfig) failed for surfaceType 0x" + Integer.toHexString(n) + ", " + gLCapabilities);
        }
        if (nArray[0] > 0) {
            Object[] objectArray;
            if (DEBUG) {
                objectArray = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(gLProfile, l, _EGLConfigArray, nArray[0]);
                EGLGraphicsConfigurationFactory.printCaps("eglChooseConfig", (GLCapabilities[])objectArray, System.err);
            }
            if (!EGL.eglGetConfigAttrib(l, _EGLConfigArray[0], 12328, objectArray = new int[1], 0)) {
                if (DEBUG) {
                    System.err.println("EGL couldn't retrieve ConfigID for already chosen eglConfig " + gLCapabilities + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
                }
                objectArray[0] = 0;
            }
            GLCapabilities gLCapabilities3 = EGLGraphicsConfiguration.EGLConfig2Capabilities(gLProfile, l, _EGLConfigArray[0]);
            if (DEBUG) {
                System.err.println("eglChooseConfig found: surfaceType 0x" + Integer.toHexString(n) + ", " + gLCapabilities + " -> " + gLCapabilities3);
            }
            return new EGLGraphicsConfiguration(abstractGraphicsScreen, gLCapabilities3, gLCapabilities2, gLCapabilitiesChooser, _EGLConfigArray[0], objectArray[0]);
        }
        return null;
    }

    protected static GLCapabilities[] eglConfigs2GLCaps(GLProfile gLProfile, long l, _EGLConfig[] _EGLConfigArray, int n) {
        GLCapabilities[] gLCapabilitiesArray = new GLCapabilities[n];
        for (int i = 0; i < n; ++i) {
            gLCapabilitiesArray[i] = EGLGraphicsConfiguration.EGLConfig2Capabilities(gLProfile, l, _EGLConfigArray[i]);
        }
        return gLCapabilitiesArray;
    }

    protected static void printCaps(String string, GLCapabilities[] gLCapabilitiesArray, PrintStream printStream) {
        for (int i = 0; i < gLCapabilitiesArray.length; ++i) {
            printStream.println(string + "[" + i + "] " + gLCapabilitiesArray[i]);
        }
    }
}

