/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.glu.nurbs;

import com.sun.opengl.impl.glu.nurbs.Backend;
import com.sun.opengl.impl.glu.nurbs.CArrayOfFloats;
import com.sun.opengl.impl.glu.nurbs.CArrayOfQuiltspecs;
import com.sun.opengl.impl.glu.nurbs.Flist;
import com.sun.opengl.impl.glu.nurbs.Knotvector;
import com.sun.opengl.impl.glu.nurbs.Mapdesc;
import com.sun.opengl.impl.glu.nurbs.Quiltspec;
import com.sun.opengl.impl.glu.nurbs.Splinespec;

public class Quilt {
    private static final int MAXDIM = 2;
    Mapdesc mapdesc;
    public CArrayOfQuiltspecs qspec;
    public CArrayOfQuiltspecs eqspec;
    public CArrayOfFloats cpts;
    public Quilt next;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Quilt(Mapdesc mapdesc) {
        this.mapdesc = mapdesc;
        Quiltspec[] quiltspecArray = new Quiltspec[2];
        for (int i = 0; i < quiltspecArray.length; ++i) {
            quiltspecArray[i] = new Quiltspec();
        }
        this.qspec = new CArrayOfQuiltspecs(quiltspecArray);
    }

    public void toBezier(Knotvector knotvector, Knotvector knotvector2, CArrayOfFloats cArrayOfFloats, int n) {
        Splinespec splinespec = new Splinespec(2);
        splinespec.kspecinit(knotvector, knotvector2);
        splinespec.select();
        splinespec.layout(n);
        splinespec.setupquilt(this);
        splinespec.copy(cArrayOfFloats);
        splinespec.transform();
    }

    public void toBezier(Knotvector knotvector, CArrayOfFloats cArrayOfFloats, int n) {
        Splinespec splinespec = new Splinespec(1);
        splinespec.kspecinit(knotvector);
        splinespec.select();
        splinespec.layout(n);
        splinespec.setupquilt(this);
        splinespec.copy(cArrayOfFloats);
        splinespec.transform();
    }

    public void downloadAll(float[] fArray, float[] fArray2, Backend backend) {
        Quilt quilt = this;
        while (quilt != null) {
            quilt.select(fArray, fArray2);
            quilt.download(backend);
            quilt = quilt.next;
        }
    }

    private void download(Backend backend) {
        if (this.getDimension() == 2) {
            CArrayOfFloats cArrayOfFloats = new CArrayOfFloats(this.cpts);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)0).offset);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)1).offset);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)0).index * this.qspec.get((int)0).order * this.qspec.get((int)0).stride);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)1).index * this.qspec.get((int)1).order * this.qspec.get((int)1).stride);
            backend.surfpts(this.mapdesc.getType(), cArrayOfFloats, this.qspec.get((int)0).stride, this.qspec.get((int)1).stride, this.qspec.get((int)0).order, this.qspec.get((int)1).order, this.qspec.get((int)0).breakpoints[this.qspec.get((int)0).index], this.qspec.get((int)0).breakpoints[this.qspec.get((int)0).index + 1], this.qspec.get((int)1).breakpoints[this.qspec.get((int)1).index], this.qspec.get((int)1).breakpoints[this.qspec.get((int)1).index + 1]);
        } else {
            CArrayOfFloats cArrayOfFloats = new CArrayOfFloats(this.cpts.getArray(), 0);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)0).offset);
            cArrayOfFloats.raisePointerBy(this.qspec.get((int)0).index * this.qspec.get((int)0).order * this.qspec.get((int)0).stride);
            backend.curvpts(this.mapdesc.getType(), cArrayOfFloats, this.qspec.get((int)0).stride, this.qspec.get((int)0).order, this.qspec.get((int)0).breakpoints[this.qspec.get((int)0).index], this.qspec.get((int)0).breakpoints[this.qspec.get((int)0).index + 1]);
        }
    }

    private int getDimension() {
        return this.eqspec.getPointer() - this.qspec.getPointer();
    }

    private void select(float[] fArray, float[] fArray2) {
        int n = this.eqspec.getPointer() - this.qspec.getPointer();
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = this.qspec.get((int)i).width - 1; !(n2 < 0 || this.qspec.get((int)i).breakpoints[n2] <= fArray[i] && fArray2[i] <= this.qspec.get((int)i).breakpoints[n2 + 1]); --n2) {
            }
            if (!$assertionsDisabled && n2 == -1) {
                throw new AssertionError();
            }
            this.qspec.get((int)i).index = n2;
        }
    }

    public void getRange(float[] fArray, float[] fArray2, Flist flist) {
        this.getRange(fArray, fArray2, 0, flist);
    }

    private void getRange(float[] fArray, float[] fArray2, int n, Flist flist) {
        Quilt quilt = this;
        fArray[n] = quilt.qspec.get((int)n).breakpoints[0];
        fArray2[n] = quilt.qspec.get((int)n).breakpoints[quilt.qspec.get((int)n).width];
        int n2 = 0;
        Quilt quilt2 = quilt;
        while (quilt2 != null) {
            if (quilt2.qspec.get((int)n).breakpoints[0] > fArray[n]) {
                fArray[n] = quilt2.qspec.get((int)n).breakpoints[0];
            }
            if (quilt2.qspec.get((int)n).breakpoints[quilt2.qspec.get((int)n).width] < fArray2[n]) {
                fArray2[n] = quilt2.qspec.get((int)n).breakpoints[quilt2.qspec.get((int)n).width];
            }
            n2 += quilt2.qspec.get((int)n).width + 1;
            quilt2 = quilt2.next;
        }
        flist.grow(n2);
        quilt2 = quilt;
        while (quilt2 != null) {
            for (int i = 0; i <= quilt2.qspec.get((int)n).width; ++i) {
                flist.add(quilt2.qspec.get((int)n).breakpoints[i]);
            }
            quilt2 = quilt2.next;
        }
        flist.filter();
        flist.taper(fArray[n], fArray2[n]);
    }

    public int isCulled() {
        if (this.mapdesc.isCulling()) {
            return 0;
        }
        return 1;
    }

    public void getRange(float[] fArray, float[] fArray2, Flist flist, Flist flist2) {
        this.getRange(fArray, fArray2, 0, flist);
        this.getRange(fArray, fArray2, 1, flist2);
    }

    public void findRates(Flist flist, Flist flist2, float[] fArray) {
    }

    static {
        $assertionsDisabled = !Quilt.class.desiredAssertionStatus();
    }
}

