/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows.wgl;

import com.sun.gluegen.runtime.DynamicLookupHelper;
import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.windows.wgl.WGL;
import com.sun.opengl.impl.windows.wgl.WindowsWGLDrawableFactory;
import com.sun.opengl.impl.windows.wgl.WindowsWGLGraphicsConfiguration;
import javax.media.nativewindow.NativeWindow;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;

public abstract class WindowsWGLDrawable
extends GLDrawableImpl {
    private static final int MAX_SET_PIXEL_FORMAT_FAIL_COUNT = 5;
    private static final boolean PROFILING = Debug.debug("WindowsWGLDrawable.profiling");
    private static final int PROFILING_TICKS = 200;
    private int profilingLockSurfaceTicks;
    private long profilingLockSurfaceTime;
    private int profilingUnlockSurfaceTicks;
    private long profilingUnlockSurfaceTime;
    private int profilingSwapBuffersTicks;
    private long profilingSwapBuffersTime;

    public WindowsWGLDrawable(GLDrawableFactory gLDrawableFactory, NativeWindow nativeWindow, boolean bl) {
        super(gLDrawableFactory, nativeWindow, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRealized(boolean bl) {
        super.setRealized(bl);
        if (!bl) {
            return;
        }
        if (1 == this.lockSurface()) {
            throw new GLException("WindowsWGLDrawable.setRealized(true): lockSurface - surface not ready");
        }
        try {
            NativeWindow nativeWindow = this.getNativeWindow();
            WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeWindow.getGraphicsConfiguration().getNativeGraphicsConfiguration();
            windowsWGLGraphicsConfiguration.updateGraphicsConfiguration(this.getFactory(), nativeWindow);
            if (DEBUG) {
                System.err.println("!!! WindowsWGLDrawable.setRealized(true): " + windowsWGLGraphicsConfiguration);
            }
        }
        finally {
            this.unlockSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swapBuffersImpl() {
        boolean bl = false;
        try {
            if (!this.isSurfaceLocked()) {
                if (this.lockSurface() == 1) {
                    return;
                }
                bl = true;
            }
            long l = 0L;
            if (PROFILING) {
                l = System.currentTimeMillis();
            }
            if (!WGL.SwapBuffers(this.getNativeWindow().getSurfaceHandle()) && WGL.GetLastError() != 0) {
                throw new GLException("Error swapping buffers");
            }
            if (PROFILING) {
                long l2 = System.currentTimeMillis();
                this.profilingSwapBuffersTime += l2 - l;
                int n = 200;
                if (++this.profilingSwapBuffersTicks == n) {
                    System.err.println("SwapBuffers calls: " + this.profilingSwapBuffersTime + " ms / " + n + "  calls (" + (float)this.profilingSwapBuffersTime / (float)n + " ms/call)");
                    this.profilingSwapBuffersTime = 0L;
                    this.profilingSwapBuffersTicks = 0;
                }
            }
        }
        finally {
            if (bl) {
                this.unlockSurface();
            }
        }
    }

    public DynamicLookupHelper getDynamicLookupHelper() {
        return (WindowsWGLDrawableFactory)this.getFactoryImpl();
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }
}

