/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import com.sun.opengl.util.FixedPoint;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.media.opengl.GLException;

public class BufferUtil {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;
    private static boolean isCDCFP;
    private static Class byteOrderClass;
    private static Object nativeOrderObject;
    private static Method orderMethod;

    public static final int sizeOfGLType(int n) {
        switch (n) {
            case 5121: {
                return 1;
            }
            case 5120: {
                return 1;
            }
            case 5123: {
                return 2;
            }
            case 5122: {
                return 2;
            }
            case 5126: {
                return 4;
            }
            case 5132: {
                return 4;
            }
            case 5124: {
                return 4;
            }
            case 5125: {
                return 4;
            }
            case 5130: {
                return 8;
            }
        }
        return -1;
    }

    public static final int sizeOfBufferElem(Buffer buffer) {
        if (buffer == null) {
            return 0;
        }
        if (buffer instanceof ByteBuffer) {
            return 1;
        }
        if (buffer instanceof IntBuffer) {
            return 4;
        }
        if (buffer instanceof ShortBuffer) {
            return 2;
        }
        if (buffer instanceof FloatBuffer) {
            return 4;
        }
        if (buffer instanceof DoubleBuffer) {
            return 8;
        }
        throw new RuntimeException("Unexpected buffer type " + buffer.getClass().getName());
    }

    private BufferUtil() {
    }

    public static final Buffer newGLBuffer(int n, int n2) {
        switch (n) {
            case 5120: 
            case 5121: {
                return BufferUtil.newByteBuffer(n2);
            }
            case 5122: 
            case 5123: {
                return BufferUtil.newShortBuffer(n2);
            }
            case 5126: {
                return BufferUtil.newFloatBuffer(n2);
            }
            case 5124: 
            case 5125: 
            case 5132: {
                return BufferUtil.newIntBuffer(n2);
            }
            case 5130: {
                return BufferUtil.newDoubleBuffer(n2);
            }
        }
        return null;
    }

    public static final Buffer sliceGLBuffer(ByteBuffer byteBuffer, int n, int n2, int n3) {
        if (byteBuffer == null || n2 == 0) {
            return null;
        }
        byteBuffer.position(n);
        byteBuffer.limit(n + n2);
        switch (n3) {
            case 5120: 
            case 5121: {
                return byteBuffer.slice();
            }
            case 5122: 
            case 5123: {
                return byteBuffer.asShortBuffer();
            }
            case 5126: {
                return byteBuffer.asFloatBuffer();
            }
            case 5124: 
            case 5125: 
            case 5132: {
                return byteBuffer.asIntBuffer();
            }
            case 5130: {
                return byteBuffer.asDoubleBuffer();
            }
        }
        return null;
    }

    public static ByteBuffer newByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        BufferUtil.nativeOrder(byteBuffer);
        return byteBuffer;
    }

    public static ByteBuffer newByteBuffer(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n2);
        byteBuffer.put(byArray, n, n2);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer newByteBuffer(byte[] byArray, int n) {
        return BufferUtil.newByteBuffer(byArray, n, byArray.length - n);
    }

    public static ByteBuffer newByteBuffer(byte[] byArray) {
        return BufferUtil.newByteBuffer(byArray, 0);
    }

    public static DoubleBuffer newDoubleBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n * 8);
        return byteBuffer.asDoubleBuffer();
    }

    public static DoubleBuffer newDoubleBuffer(double[] dArray, int n) {
        int n2 = dArray.length - n;
        DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(n2);
        doubleBuffer.put(dArray, n, n2);
        doubleBuffer.rewind();
        return doubleBuffer;
    }

    public static DoubleBuffer newDoubleBuffer(double[] dArray) {
        return BufferUtil.newDoubleBuffer(dArray, 0);
    }

    public static FloatBuffer newFloatBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n * 4);
        return byteBuffer.asFloatBuffer();
    }

    public static FloatBuffer newFloatBuffer(float[] fArray, int n, int n2) {
        FloatBuffer floatBuffer = BufferUtil.newFloatBuffer(n2);
        floatBuffer.put(fArray, n, n2);
        floatBuffer.rewind();
        return floatBuffer;
    }

    public static FloatBuffer newFloatBuffer(float[] fArray, int n) {
        return BufferUtil.newFloatBuffer(fArray, 0, fArray.length - n);
    }

    public static FloatBuffer newFloatBuffer(float[] fArray) {
        return BufferUtil.newFloatBuffer(fArray, 0);
    }

    public static IntBuffer newIntBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n * 4);
        return byteBuffer.asIntBuffer();
    }

    public static IntBuffer newIntBuffer(int[] nArray, int n, int n2) {
        IntBuffer intBuffer = BufferUtil.newIntBuffer(n2);
        intBuffer.put(nArray, n, n2);
        intBuffer.rewind();
        return intBuffer;
    }

    public static IntBuffer newIntBuffer(int[] nArray, int n) {
        return BufferUtil.newIntBuffer(nArray, 0, nArray.length - n);
    }

    public static IntBuffer newIntBuffer(int[] nArray) {
        return BufferUtil.newIntBuffer(nArray, 0);
    }

    public static LongBuffer newLongBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n * 8);
        return byteBuffer.asLongBuffer();
    }

    public static ShortBuffer newShortBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n * 2);
        return byteBuffer.asShortBuffer();
    }

    public static ShortBuffer newShortBuffer(short[] sArray, int n, int n2) {
        ShortBuffer shortBuffer = BufferUtil.newShortBuffer(n2);
        shortBuffer.put(sArray, n, n2);
        shortBuffer.rewind();
        return shortBuffer;
    }

    public static ShortBuffer newShortBuffer(short[] sArray, int n) {
        return BufferUtil.newShortBuffer(sArray, 0, sArray.length - n);
    }

    public static ShortBuffer newShortBuffer(short[] sArray) {
        return BufferUtil.newShortBuffer(sArray, 0);
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = BufferUtil.newByteBuffer(byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        byteBuffer2.rewind();
        return byteBuffer2;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer floatBuffer) {
        return BufferUtil.copyFloatBufferAsByteBuffer(floatBuffer).asFloatBuffer();
    }

    public static IntBuffer copyIntBuffer(IntBuffer intBuffer) {
        return BufferUtil.copyIntBufferAsByteBuffer(intBuffer).asIntBuffer();
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer shortBuffer) {
        return BufferUtil.copyShortBufferAsByteBuffer(shortBuffer).asShortBuffer();
    }

    public static ByteBuffer copyFloatBufferAsByteBuffer(FloatBuffer floatBuffer) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(floatBuffer.remaining() * 4);
        byteBuffer.asFloatBuffer().put(floatBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyIntBufferAsByteBuffer(IntBuffer intBuffer) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(intBuffer.remaining() * 4);
        byteBuffer.asIntBuffer().put(intBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyShortBufferAsByteBuffer(ShortBuffer shortBuffer) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(shortBuffer.remaining() * 2);
        byteBuffer.asShortBuffer().put(shortBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static final float[] getFloatArray(double[] dArray) {
        int n = dArray.length;
        float[] fArray = new float[n--];
        while (n >= 0) {
            fArray[n] = (float)dArray[n];
            --n;
        }
        return fArray;
    }

    public static final FloatBuffer getFloatBuffer(DoubleBuffer doubleBuffer) {
        doubleBuffer.rewind();
        FloatBuffer floatBuffer = BufferUtil.newFloatBuffer(doubleBuffer.limit());
        while (doubleBuffer.hasRemaining()) {
            floatBuffer.put((float)doubleBuffer.get());
        }
        return floatBuffer;
    }

    public static ByteBuffer nativeOrder(ByteBuffer byteBuffer) {
        if (!isCDCFP) {
            try {
                if (byteOrderClass == null) {
                    byteOrderClass = Class.forName("java.nio.ByteOrder");
                    orderMethod = ByteBuffer.class.getMethod("order", byteOrderClass);
                    Method method = byteOrderClass.getMethod("nativeOrder", null);
                    nativeOrderObject = method.invoke(null, null);
                }
            }
            catch (Throwable throwable) {
                isCDCFP = true;
            }
            if (!isCDCFP) {
                try {
                    orderMethod.invoke((Object)byteBuffer, nativeOrderObject);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return byteBuffer;
    }

    public static void put(Buffer buffer, Buffer buffer2) {
        if (buffer instanceof ByteBuffer && buffer2 instanceof ByteBuffer) {
            ((ByteBuffer)buffer).put((ByteBuffer)buffer2);
        } else if (buffer instanceof ShortBuffer && buffer2 instanceof ShortBuffer) {
            ((ShortBuffer)buffer).put((ShortBuffer)buffer2);
        } else if (buffer instanceof IntBuffer && buffer2 instanceof IntBuffer) {
            ((IntBuffer)buffer).put((IntBuffer)buffer2);
        } else if (buffer instanceof FloatBuffer && buffer2 instanceof FloatBuffer) {
            ((FloatBuffer)buffer).put((FloatBuffer)buffer2);
        } else {
            throw new GLException("Incompatible Buffer classes: dest = " + buffer.getClass().getName() + ", src = " + buffer2.getClass().getName());
        }
    }

    public static void putb(Buffer buffer, byte by) {
        if (buffer instanceof ByteBuffer) {
            ((ByteBuffer)buffer).put(by);
        } else if (buffer instanceof ShortBuffer) {
            ((ShortBuffer)buffer).put(by);
        } else if (buffer instanceof IntBuffer) {
            ((IntBuffer)buffer).put(by);
        } else {
            throw new GLException("Byte doesn't match Buffer Class: " + buffer);
        }
    }

    public static void puts(Buffer buffer, short s) {
        if (buffer instanceof ShortBuffer) {
            ((ShortBuffer)buffer).put(s);
        } else if (buffer instanceof IntBuffer) {
            ((IntBuffer)buffer).put(s);
        } else {
            throw new GLException("Short doesn't match Buffer Class: " + buffer);
        }
    }

    public static void puti(Buffer buffer, int n) {
        if (!(buffer instanceof IntBuffer)) {
            throw new GLException("Integer doesn't match Buffer Class: " + buffer);
        }
        ((IntBuffer)buffer).put(n);
    }

    public static void putx(Buffer buffer, int n) {
        BufferUtil.puti(buffer, n);
    }

    public static void putf(Buffer buffer, float f) {
        if (buffer instanceof FloatBuffer) {
            ((FloatBuffer)buffer).put(f);
        } else if (buffer instanceof IntBuffer) {
            ((IntBuffer)buffer).put(FixedPoint.toFixed(f));
        } else {
            throw new GLException("Float doesn't match Buffer Class: " + buffer);
        }
    }

    public static void putd(Buffer buffer, double d) {
        if (!(buffer instanceof FloatBuffer)) {
            throw new GLException("Double doesn't match Buffer Class: " + buffer);
        }
        ((FloatBuffer)buffer).put((float)d);
    }
}

