/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.project.AddExpressionsOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Util;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchWindow;

public class AddExpressionsAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchWindow window;
    private final Set<AnimatableValueElement> elements = Util.newLinkedHashSet();

    public AddExpressionsAction(IWorkbenchWindow window, Viewer viewer) {
        super("\u30a8\u30af\u30b9\u30d7\u30ec\u30c3\u30b7\u30e7\u30f3\u306e\u8ffd\u52a0");
        this.window = window;
        this.updateState(viewer.getSelection());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void updateState(ISelection selection) {
        this.elements.clear();
        if (selection instanceof IStructuredSelection) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                AnimatableValueElement element;
                if (o instanceof AnimatableValueElement && !(element = (AnimatableValueElement)o).hasExpression()) {
                    this.elements.add(element);
                    continue;
                }
                this.elements.clear();
                break;
            }
        }
        this.setEnabled(!this.elements.isEmpty());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateState(event.getSelection());
    }

    public void run() {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.window);
        LayerCompositionView view = (LayerCompositionView)this.window.getActivePage().getActivePart();
        LayerComposition comp = view.getLayerComposition();
        AddExpressionsOperation op = new AddExpressionsOperation(pm, comp);
        LinkedHashSet elements = Util.newLinkedHashSet(this.elements);
        for (AnimatableValueElement element : elements) {
            op.add(element.createAddExpressionOperation(pm));
        }
        pm.postOperation(op);
        if (elements.size() == 1) {
            view.editExpression((AnimatableValueElement)elements.iterator().next());
        }
    }
}

