/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.player;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.player.AbstractClock;
import ch.kuramo.javie.app.player.Clock;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.DataLine;

public class TimeKeeper {
    private final Clock clock;
    private final AtomicReference<Time[]> timesRef = new AtomicReference();
    private volatile boolean paused = true;

    public TimeKeeper(Clock clock) {
        this.clock = clock;
        this.resetTime();
    }

    private Time[] getTimes() {
        Time now;
        Time[] times = this.timesRef.get();
        if (!this.paused && (now = new Time(this.clock.getValue() - times[1].timeValue, times[1].timeScale)).after(times[0])) {
            Time[] newTimes = new Time[]{now, times[1]};
            times = this.timesRef.compareAndSet(times, newTimes) ? newTimes : this.timesRef.get();
        }
        return times;
    }

    public Time[] getTimeAndBase() {
        return (Time[])this.getTimes().clone();
    }

    public Time getTime() {
        return this.getTimes()[0];
    }

    public void setTime(Time time) {
        int clockScale = this.clock.getScale();
        long timeValueInClockScale = time.timeScale == clockScale ? time.timeValue : Math.round((double)clockScale * (double)time.timeValue / (double)time.timeScale);
        Time baseTime = new Time(this.clock.getValue() - timeValueInClockScale, clockScale);
        this.timesRef.set(new Time[]{time, baseTime});
    }

    public void resetTime() {
        int clockScale = this.clock.getScale();
        this.timesRef.set(new Time[]{new Time(0L, clockScale), new Time(this.clock.getValue(), clockScale)});
    }

    public Time pause() {
        Time time = this.getTime();
        this.paused = true;
        return time;
    }

    public Time resume(Time time) {
        if (this.paused && time == null) {
            time = this.getTime();
        }
        if (time != null) {
            this.setTime(time);
        }
        this.paused = false;
        return time;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public static TimeKeeper fromSystemTime() {
        return new TimeKeeper(new AbstractClock(1000000000){

            protected long rawValue() {
                return System.nanoTime();
            }
        });
    }

    public static TimeKeeper fromAudioLine(final DataLine line) {
        return new TimeKeeper(new AbstractClock((int)line.getFormat().getFrameRate()){

            protected long rawValue() {
                return line.getLongFramePosition();
            }
        });
    }
}

