/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayerSwitchOperation
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;

    public LayerSwitchOperation(ProjectManager projectManager, Layer layer, String label) {
        super(projectManager, label);
        LayerComposition comp = projectManager.checkLayer(layer);
        this._compId = comp.getId();
        this._layerId = layer.getId();
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setSwitchValue(false, (Layer)this.getLayer(project), pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setSwitchValue(true, (Layer)this.getLayer(project), pm);
        return Status.OK_STATUS;
    }

    protected abstract void setSwitchValue(boolean var1, Layer var2, ProjectManager var3);

    protected <L extends Layer> L getLayer(Project project) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Layer layer = comp.getLayer(this._layerId);
        return (L)layer;
    }

    public static class Audio
    extends LayerSwitchOperation {
        private final boolean _oldValue;

        public Audio(ProjectManager projectManager, Layer layer) {
            super(projectManager, layer, "\u30aa\u30fc\u30c7\u30a3\u30aa\u30b9\u30a4\u30c3\u30c1\u306e\u5909\u66f4");
            this._oldValue = LayerNature.isAudioEnabled((Layer)layer);
        }

        protected void setSwitchValue(boolean undo, Layer layer, ProjectManager pm) {
            LayerNature.setAudioEnabled((Layer)layer, (boolean)(undo ? this._oldValue : !this._oldValue));
            if (pm != null) {
                pm.fireLayerPropertyChange(layer, "audioEnabled");
            }
        }
    }

    public static class CTCR
    extends LayerSwitchOperation {
        private final boolean _oldValue;

        public CTCR(ProjectManager projectManager, Layer layer) {
            super(projectManager, layer, CTCR.label(layer));
            this._oldValue = LayerNature.isCTCR((Layer)layer);
        }

        private static String label(Layer layer) {
            if (layer instanceof MediaItemLayer && ((MediaItemLayer)layer).isPrecompositionLayer()) {
                return "\u30b3\u30e9\u30c3\u30d7\u30b9\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30e0\u30b9\u30a4\u30c3\u30c1\u306e\u5909\u66f4";
            }
            return "\u9023\u7d9a\u30e9\u30b9\u30bf\u30e9\u30a4\u30ba\u30b9\u30a4\u30c3\u30c1\u306e\u5909\u66f4";
        }

        protected void setSwitchValue(boolean undo, Layer layer, ProjectManager pm) {
            LayerNature.setCTCR((Layer)layer, (boolean)(undo ? this._oldValue : !this._oldValue));
            if (pm != null) {
                pm.fireLayerPropertyChange(layer, "CTCR");
            }
        }
    }

    public static class Effects
    extends LayerSwitchOperation {
        private final boolean _oldValue;

        public Effects(ProjectManager projectManager, EffectableLayer layer) {
            super(projectManager, (Layer)layer, "\u30a8\u30d5\u30a7\u30af\u30c8\u30b9\u30a4\u30c3\u30c1\u306e\u5909\u66f4");
            this._oldValue = layer.isEffectsEnabled();
        }

        protected void setSwitchValue(boolean undo, Layer layer, ProjectManager pm) {
            ((EffectableLayer)layer).setEffectsEnabled(undo ? this._oldValue : !this._oldValue);
            if (pm != null) {
                pm.fireLayerPropertyChange(layer, "effectsEnabled");
            }
        }
    }

    public static class FrameBlend
    extends LayerSwitchOperation {
        private final ch.kuramo.javie.core.FrameBlend _newValue;
        private final ch.kuramo.javie.core.FrameBlend _oldValue;

        public FrameBlend(ProjectManager projectManager, Layer layer, ch.kuramo.javie.core.FrameBlend newValue) {
            super(projectManager, layer, "\u30d5\u30ec\u30fc\u30e0\u30d6\u30ec\u30f3\u30c9\u30b9\u30a4\u30c3\u30c1\u306e\u5909\u66f4");
            this._newValue = newValue;
            this._oldValue = LayerNature.getFrameBlend((Layer)layer);
            this._noEffect = this._newValue == this._oldValue;
        }

        protected void setSwitchValue(boolean undo, Layer layer, ProjectManager pm) {
            LayerNature.setFrameBlend((Layer)layer, (ch.kuramo.javie.core.FrameBlend)(undo ? this._oldValue : this._newValue));
            if (pm != null) {
                pm.fireLayerPropertyChange(layer, "frameBlend");
            }
        }
    }

    public static class MotionBlur
    extends LayerSwitchOperation {
        private final ch.kuramo.javie.core.MotionBlur _newValue;
        private final ch.kuramo.javie.core.MotionBlur _oldValue;

        public MotionBlur(ProjectManager projectManager, Layer layer, ch.kuramo.javie.core.MotionBlur newValue) {
            super(projectManager, layer, "\u30e2\u30fc\u30b7\u30e7\u30f3\u30d6\u30e9\u30fc\u30b9\u30a4\u30c3\u30c1\u306e\u5909\u66f4");
            this._newValue = newValue;
            this._oldValue = LayerNature.getMotionBlur((Layer)layer);
            this._noEffect = this._newValue == this._oldValue;
        }

        protected void setSwitchValue(boolean undo, Layer layer, ProjectManager pm) {
            LayerNature.setMotionBlur((Layer)layer, (ch.kuramo.javie.core.MotionBlur)(undo ? this._oldValue : this._newValue));
            if (pm != null) {
                pm.fireLayerPropertyChange(layer, "motionBlur");
            }
        }
    }

    public static class Quality
    extends LayerSwitchOperation {
        private final ch.kuramo.javie.core.Quality _newValue;
        private final ch.kuramo.javie.core.Quality _oldValue;

        public Quality(ProjectManager projectManager, Layer layer, ch.kuramo.javie.core.Quality newValue) {
            super(projectManager, layer, "\u753b\u8cea\u30b9\u30a4\u30c3\u30c1\u306e\u5909\u66f4");
            this._newValue = newValue;
            this._oldValue = LayerNature.getQuality((Layer)layer);
            this._noEffect = this._newValue == this._oldValue;
        }

        protected void setSwitchValue(boolean undo, Layer layer, ProjectManager pm) {
            LayerNature.setQuality((Layer)layer, (ch.kuramo.javie.core.Quality)(undo ? this._oldValue : this._newValue));
            if (pm != null) {
                pm.fireLayerPropertyChange(layer, "quality");
            }
        }
    }

    public static class Shy
    extends LayerSwitchOperation {
        private final boolean _oldValue;

        public Shy(ProjectManager projectManager, Layer layer) {
            super(projectManager, layer, "\u30b7\u30e3\u30a4\u30b9\u30a4\u30c3\u30c1\u306e\u5909\u66f4");
            this._oldValue = layer.isShy();
        }

        protected void setSwitchValue(boolean undo, Layer layer, ProjectManager pm) {
            layer.setShy(undo ? this._oldValue : !this._oldValue);
            if (pm != null) {
                pm.fireLayerPropertyChange(layer, "shy");
            }
        }
    }

    public static class Video
    extends LayerSwitchOperation {
        private final boolean _oldValue;

        public Video(ProjectManager projectManager, Layer layer) {
            super(projectManager, layer, "\u30d3\u30c7\u30aa\u30b9\u30a4\u30c3\u30c1\u306e\u5909\u66f4");
            this._oldValue = LayerNature.isVideoEnabled((Layer)layer);
        }

        protected void setSwitchValue(boolean undo, Layer layer, ProjectManager pm) {
            LayerNature.setVideoEnabled((Layer)layer, (boolean)(undo ? this._oldValue : !this._oldValue));
            if (pm != null) {
                pm.fireLayerPropertyChange(layer, "videoEnabled");
            }
        }
    }
}

