/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReorderLayersOperation
extends ProjectOperation {
    private final String _compId;
    private final List<String> _oldOrder = Util.newList();
    private final List<String> _newOrder = Util.newList();
    private final List<String> _layerIds = Util.newList();

    public ReorderLayersOperation(ProjectManager projectManager, List<Layer> newOrder, List<Layer> layers) {
        super(projectManager, "\u30ec\u30a4\u30e4\u30fc\u306e\u79fb\u52d5");
        if (Util.newSet(newOrder).size() != newOrder.size()) {
            throw new IllegalArgumentException("dupulicated elements found in the order list");
        }
        if (Util.newSet(layers).size() != layers.size()) {
            throw new IllegalArgumentException("dupulicated elements found in the layer list");
        }
        LayerComposition comp = projectManager.checkLayer(newOrder.get(0));
        this._compId = comp.getId();
        for (Layer l : newOrder) {
            if (projectManager.checkLayer(l) != comp) {
                throw new IllegalArgumentException("all layers must belong to same composition");
            }
            this._newOrder.add(l.getId());
        }
        for (Layer l : comp.getLayers()) {
            this._oldOrder.add(l.getId());
        }
        for (Layer l : layers) {
            if (projectManager.checkLayer(l) != comp) {
                throw new IllegalArgumentException("all layers must belong to same composition");
            }
            this._layerIds.add(l.getId());
        }
        this._noEffect = this._newOrder.equals(this._oldOrder);
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.reorder(this._newOrder, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.reorder(this._oldOrder, project, pm);
        return Status.OK_STATUS;
    }

    private void reorder(List<String> ids, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List newOrder = Util.newList();
        for (String id : ids) {
            Layer layer = comp.getLayer(id);
            if (layer == null) {
                throw new ExecutionException("no layer found: id=" + id);
            }
            newOrder.add(layer);
        }
        List layers = Util.newList();
        for (String id : this._layerIds) {
            Layer layer = comp.getLayer(id);
            if (layer == null) {
                throw new ExecutionException("no layer found: id=" + id);
            }
            layers.add(layer);
        }
        comp.getLayers().clear();
        comp.getLayers().addAll(newOrder);
        if (pm != null) {
            pm.fireLayersReorder(comp, layers);
        }
    }
}

