/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.player.PlayerLock;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Util;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShadowOperationRunner
extends Thread {
    private static final Runnable END = new Runnable(){

        public void run() {
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(ShadowOperationRunner.class);
    private final BlockingQueue<Runnable> shadowOperations = new LinkedBlockingQueue<Runnable>();
    private final ProjectManager projectManager;

    ShadowOperationRunner(ProjectManager pm) {
        super("ShadowOperationRunner");
        this.projectManager = pm;
    }

    void put(Runnable operation) {
        try {
            this.shadowOperations.put(operation);
        }
        catch (InterruptedException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    void end() {
        this.put(END);
    }

    public void run() {
        Set drain = Util.newSet();
        while (true) {
            drain.clear();
            try {
                drain.add(this.shadowOperations.take());
            }
            catch (InterruptedException e) {
                logger.warn("unexpected interrupt", (Throwable)e);
                continue;
            }
            this.shadowOperations.drainTo(drain);
            PlayerLock.writeLock().lock();
            try {
                for (Runnable op : drain) {
                    if (op == END) {
                        return;
                    }
                    try {
                        op.run();
                    }
                    catch (Throwable e) {
                        logger.error("error running shadow operation", e);
                        return;
                    }
                }
            }
            finally {
                PlayerLock.writeLock().unlock();
            }
            this.projectManager.fireShadowOperationExecution();
        }
    }
}

